/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Base class for specialized real-to-complex forward Fast Fourier Transform .


This is a base class for the "forward" or "direct" discrete
Fourier Transform . This is an abstract base class: the actual implementation is
provided by the best child class available on the system when the
object is created via the object factory system.

This class transforms a real input image into its complex Fourier
transform. The Fourier transform of a real input image has Hermitian
symmetry: $ f(\\mathbf{x}) = f^*(-\\mathbf{x}) $ . That is, when the result of the transform is split in half along
the X-dimension, the values in the second half of the transform are
the complex conjugates of values in the first half reflected about the
center of the image in each dimension. This filter takes advantage of
the Hermitian symmetry property and reduces the size of the output in
the first dimension to N/2+1, where N is the size of the input image
in that dimension and the division by 2 is rounded down.


See:
 HalfHermitianToRealInverseFFTImageFilter

 ForwardFFTImageFilter

 itk::simple::RealToHalfHermitianForwardFFT for the procedural interface

 itk::RealToHalfHermitianForwardFFTImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkRealToHalfHermitianForwardFFTImageFilter.h
*/
public class RealToHalfHermitianForwardFFTImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected RealToHalfHermitianForwardFFTImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.RealToHalfHermitianForwardFFTImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(RealToHalfHermitianForwardFFTImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(RealToHalfHermitianForwardFFTImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::RealToHalfHermitianForwardFFTImageFilter::~RealToHalfHermitianForwardFFTImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_RealToHalfHermitianForwardFFTImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::RealToHalfHermitianForwardFFTImageFilter::RealToHalfHermitianForwardFFTImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  RealToHalfHermitianForwardFFTImageFilter() {
    this(SimpleITKJNI.new_RealToHalfHermitianForwardFFTImageFilter(), true);
  }

  /**
std::string itk::simple::RealToHalfHermitianForwardFFTImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.RealToHalfHermitianForwardFFTImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::RealToHalfHermitianForwardFFTImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.RealToHalfHermitianForwardFFTImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::RealToHalfHermitianForwardFFTImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.RealToHalfHermitianForwardFFTImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
