/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Set;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.initialization.LoadProjectsBuildOperationType;
import org.gradle.initialization.ProjectsIdentifiedProgressDetails;
import org.gradle.internal.build.BuildState;

public class BuildStructureOperationProject
implements LoadProjectsBuildOperationType.Result.Project,
ProjectsIdentifiedProgressDetails.Project {
    private static final Comparator<LoadProjectsBuildOperationType.Result.Project> PROJECT_COMPARATOR = Comparator.comparing(LoadProjectsBuildOperationType.Result.Project::getName);
    private final String name;
    private final String path;
    private final String identityPath;
    private final String projectDir;
    private final String buildFile;
    private final Set<BuildStructureOperationProject> children;

    public BuildStructureOperationProject(String name, String path, String identityPath, String projectDir, String buildFile, Set<BuildStructureOperationProject> children) {
        this.name = name;
        this.path = path;
        this.identityPath = identityPath;
        this.projectDir = projectDir;
        this.buildFile = buildFile;
        this.children = children;
    }

    private static BuildStructureOperationProject convert(ProjectState project) {
        return new BuildStructureOperationProject(project.getName(), project.getIdentity().getProjectPath().asString(), project.getIdentity().getBuildTreePath().asString(), project.getProjectDir().getAbsolutePath(), project.getMutableModel().getBuildFile().getAbsolutePath(), BuildStructureOperationProject.convertAll(project.getChildProjects()));
    }

    private static Set<BuildStructureOperationProject> convertAll(Iterable<ProjectState> children) {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PROJECT_COMPARATOR);
        for (ProjectState child : children) {
            builder.add((Object)BuildStructureOperationProject.convert(child));
        }
        return builder.build();
    }

    public static BuildStructureOperationProject from(BuildState build) {
        return BuildStructureOperationProject.convert(build.getProjects().getRootProject());
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getIdentityPath() {
        return this.identityPath;
    }

    public String getProjectDir() {
        return this.projectDir;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public Set<BuildStructureOperationProject> getChildren() {
        return this.children;
    }
}

