﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/inspector2/Inspector2_EXPORTS.h>
#include <aws/inspector2/model/CisScan.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Inspector2 {
namespace Model {
class ListCisScansResult {
 public:
  AWS_INSPECTOR2_API ListCisScansResult() = default;
  AWS_INSPECTOR2_API ListCisScansResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_INSPECTOR2_API ListCisScansResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The CIS scans.</p>
   */
  inline const Aws::Vector<CisScan>& GetScans() const { return m_scans; }
  template <typename ScansT = Aws::Vector<CisScan>>
  void SetScans(ScansT&& value) {
    m_scansHasBeenSet = true;
    m_scans = std::forward<ScansT>(value);
  }
  template <typename ScansT = Aws::Vector<CisScan>>
  ListCisScansResult& WithScans(ScansT&& value) {
    SetScans(std::forward<ScansT>(value));
    return *this;
  }
  template <typename ScansT = CisScan>
  ListCisScansResult& AddScans(ScansT&& value) {
    m_scansHasBeenSet = true;
    m_scans.emplace_back(std::forward<ScansT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The pagination token from a previous request that's used to retrieve the next
   * page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListCisScansResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListCisScansResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<CisScan> m_scans;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_scansHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Inspector2
}  // namespace Aws
