﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoTRequest.h>
#include <aws/iot/IoT_EXPORTS.h>

#include <utility>

namespace Aws {
namespace IoT {
namespace Model {

/**
 * <p>The input for the DeletePolicyVersion operation.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iot-2015-05-28/DeletePolicyVersionRequest">AWS
 * API Reference</a></p>
 */
class DeletePolicyVersionRequest : public IoTRequest {
 public:
  AWS_IOT_API DeletePolicyVersionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeletePolicyVersion"; }

  AWS_IOT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The name of the policy.</p>
   */
  inline const Aws::String& GetPolicyName() const { return m_policyName; }
  inline bool PolicyNameHasBeenSet() const { return m_policyNameHasBeenSet; }
  template <typename PolicyNameT = Aws::String>
  void SetPolicyName(PolicyNameT&& value) {
    m_policyNameHasBeenSet = true;
    m_policyName = std::forward<PolicyNameT>(value);
  }
  template <typename PolicyNameT = Aws::String>
  DeletePolicyVersionRequest& WithPolicyName(PolicyNameT&& value) {
    SetPolicyName(std::forward<PolicyNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The policy version ID.</p>
   */
  inline const Aws::String& GetPolicyVersionId() const { return m_policyVersionId; }
  inline bool PolicyVersionIdHasBeenSet() const { return m_policyVersionIdHasBeenSet; }
  template <typename PolicyVersionIdT = Aws::String>
  void SetPolicyVersionId(PolicyVersionIdT&& value) {
    m_policyVersionIdHasBeenSet = true;
    m_policyVersionId = std::forward<PolicyVersionIdT>(value);
  }
  template <typename PolicyVersionIdT = Aws::String>
  DeletePolicyVersionRequest& WithPolicyVersionId(PolicyVersionIdT&& value) {
    SetPolicyVersionId(std::forward<PolicyVersionIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_policyName;

  Aws::String m_policyVersionId;
  bool m_policyNameHasBeenSet = false;
  bool m_policyVersionIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
