/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.internal.ui.util.SWTUtil;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SearchHistorySelectionDialog
extends SelectionDialog {
    private static final int REMOVE_ID = 1025;
    private static final int WIDTH_IN_CHARACTERS = 55;
    private final List<ISearchResult> fInput;
    private final List<ISearchResult> fRemovedEntries;
    private TableViewer fViewer;
    private Button fRemoveButton;
    private boolean fIsOpenInNewView;
    private Link fLink;

    public SearchHistorySelectionDialog(Shell parent, List<ISearchResult> input) {
        super(parent);
        this.setTitle(SearchMessages.SearchesDialog_title);
        this.setMessage(SearchMessages.SearchesDialog_message);
        this.fInput = input;
        this.fRemovedEntries = new ArrayList<ISearchResult>();
        this.setHelpAvailable(false);
    }

    public boolean isOpenInNewView() {
        return this.fIsOpenInNewView;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return SearchPlugin.getDefault().getDialogSettingsSection("DialogBounds_SearchHistorySelectionDialog");
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    protected Label createMessageArea(Composite composite) {
        Composite parent = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(768));
        Label label = new Label(parent, 64);
        label.setText(this.getMessage());
        GridData gd = new GridData(768);
        label.setLayoutData((Object)gd);
        SearchHistorySelectionDialog.applyDialogFont((Control)label);
        return label;
    }

    public void create() {
        super.create();
        List initialSelection = this.getInitialElementSelections();
        if (initialSelection != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(initialSelection));
        }
        this.validateDialogState();
    }

    protected Control createDialogArea(Composite container) {
        Composite ancestor = (Composite)super.createDialogArea(container);
        this.createMessageArea(ancestor);
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.fViewer = new TableViewer(parent, 68354);
        this.fViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = this.fViewer.getTable();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SearchHistorySelectionDialog.this.okPressed();
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new SearchesLabelProvider());
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        table.setLayoutData((Object)gd);
        this.fRemoveButton = new Button(parent, 8);
        this.fRemoveButton.setText(SearchMessages.SearchesDialog_remove_label);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SearchHistorySelectionDialog.this.buttonPressed(1025);
            }
        });
        this.fRemoveButton.setLayoutData((Object)new GridData(1, 1, false, false));
        SWTUtil.setButtonDimensionHint(this.fRemoveButton);
        this.fViewer.addSelectionChangedListener(event -> this.validateDialogState());
        this.fLink = new Link(parent, 0);
        this.configureHistoryLink();
        this.fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoryConfigurationDialog dialog = new HistoryConfigurationDialog(SearchHistorySelectionDialog.this.getShell(), SearchHistorySelectionDialog.this.fInput, SearchHistorySelectionDialog.this.fRemovedEntries);
                if (dialog.open() == 0) {
                    SearchHistorySelectionDialog.this.fViewer.refresh();
                    SearchHistorySelectionDialog.this.configureHistoryLink();
                }
            }
        });
        this.fLink.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        SearchHistorySelectionDialog.applyDialogFont((Control)ancestor);
        this.fViewer.setInput(this.fInput);
        this.fViewer.getTable().setFocus();
        return ancestor;
    }

    private void configureHistoryLink() {
        int historyLimit = SearchPreferencePage.getHistoryLimit();
        this.fLink.setText(MessageFormat.format(SearchMessages.SearchHistorySelectionDialog_configure_link_label, historyLimit));
    }

    protected final void validateDialogState() {
        Button openInNewButton;
        IStructuredSelection sel = this.fViewer.getStructuredSelection();
        int elementsSelected = sel.toList().size();
        this.fRemoveButton.setEnabled(elementsSelected > 0);
        Button okButton = this.getOkButton();
        if (okButton != null) {
            okButton.setEnabled(elementsSelected == 1);
        }
        if ((openInNewButton = this.getButton(11)) != null) {
            openInNewButton.setEnabled(elementsSelected == 1);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OPEN_LABEL, true);
        this.createButton(parent, 11, SearchMessages.SearchHistorySelectionDialog_open_in_new_button, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            IStructuredSelection selection = this.fViewer.getStructuredSelection();
            for (ISearchResult curr : selection) {
                this.fRemovedEntries.add(curr);
                this.fInput.remove(curr);
                this.fViewer.remove((Object)curr);
            }
            if (this.fViewer.getSelection().isEmpty() && !this.fInput.isEmpty()) {
                this.fViewer.setSelection((ISelection)new StructuredSelection((Object)this.fInput.get(0)));
            }
            return;
        }
        if (buttonId == 11) {
            this.fIsOpenInNewView = true;
            buttonId = 0;
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        ISelection selection = this.fViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setResult(this.fViewer.getStructuredSelection().toList());
        }
        for (ISearchResult result : this.fRemovedEntries) {
            ISearchQuery query = result.getQuery();
            if (query == null) continue;
            InternalSearchUI.getInstance().removeQuery(query);
        }
        super.okPressed();
    }

    private static class HistoryConfigurationDialog
    extends StatusDialog {
        private static final int DEFAULT_ID = 100;
        private int fHistorySize;
        private Text fHistorySizeTextField;
        private final List<ISearchResult> fCurrentList;
        private final List<ISearchResult> fCurrentRemoves;

        public HistoryConfigurationDialog(Shell parent, List<ISearchResult> currentList, List<ISearchResult> removedEntries) {
            super(parent);
            this.fCurrentList = currentList;
            this.fCurrentRemoves = removedEntries;
            this.setTitle(SearchMessages.SearchHistorySelectionDialog_history_size_title);
            this.fHistorySize = SearchPreferencePage.getHistoryLimit();
            this.setHelpAvailable(false);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite container) {
            Composite ancestor = (Composite)super.createDialogArea(container);
            GridLayout layout = (GridLayout)ancestor.getLayout();
            layout.numColumns = 2;
            ancestor.setLayout((Layout)layout);
            Label limitText = new Label(ancestor, 0);
            limitText.setText(SearchMessages.SearchHistorySelectionDialog_history_size_description);
            limitText.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            this.fHistorySizeTextField = new Text(ancestor, 133120);
            this.fHistorySizeTextField.setTextLimit(2);
            this.fHistorySizeTextField.setText(String.valueOf(this.fHistorySize));
            this.fHistorySizeTextField.addModifyListener(e -> {
                boolean bl = this.validateDialogState();
            });
            GridData gridData = new GridData(131072, 0x1000000, false, false, 1, 1);
            gridData.widthHint = this.convertWidthInCharsToPixels(6);
            this.fHistorySizeTextField.setLayoutData((Object)gridData);
            this.fHistorySizeTextField.setSelection(0, this.fHistorySizeTextField.getText().length());
            HistoryConfigurationDialog.applyDialogFont((Control)ancestor);
            return ancestor;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 100, SearchMessages.SearchHistorySelectionDialog_restore_default_button, false);
            super.createButtonsForButtonBar(parent);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 100) {
                IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
                this.fHistorySizeTextField.setText(store.getDefaultString("org.eclipse.search.limitHistory"));
                this.validateDialogState();
            }
            super.buttonPressed(buttonId);
        }

        protected final boolean validateDialogState() {
            Status status = null;
            try {
                String historySize = this.fHistorySizeTextField.getText();
                int size = Integer.parseInt(historySize);
                if (size < 1 || size >= 100) {
                    status = new Status(4, SearchPlugin.getID(), 4, SearchMessages.SearchHistorySelectionDialog_history_size_error, null);
                } else {
                    this.fHistorySize = size;
                }
            }
            catch (NumberFormatException e) {
                status = new Status(4, SearchPlugin.getID(), 4, SearchMessages.SearchHistorySelectionDialog_history_size_error, null);
            }
            if (status == null) {
                status = Status.OK_STATUS;
            }
            this.updateStatus((IStatus)status);
            return !status.matches(4);
        }

        protected void okPressed() {
            IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
            store.setValue("org.eclipse.search.limitHistory", this.fHistorySize);
            int i = this.fCurrentList.size() - 1;
            while (i >= this.fHistorySize) {
                this.fCurrentRemoves.add(this.fCurrentList.get(i));
                this.fCurrentList.remove(i);
                --i;
            }
            super.okPressed();
        }
    }

    private static final class SearchesLabelProvider
    extends LabelProvider {
        private ArrayList<Image> fImages = new ArrayList();

        private SearchesLabelProvider() {
        }

        public String getText(Object element) {
            return ((ISearchResult)element).getLabel();
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDescriptor = ((ISearchResult)element).getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            Image image = imageDescriptor.createImage();
            this.fImages.add(image);
            return image;
        }

        public void dispose() {
            Iterator<Image> iter = this.fImages.iterator();
            while (iter.hasNext()) {
                iter.next().dispose();
            }
            this.fImages = null;
        }
    }
}

