/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.security;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2GlobalObject;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthBase;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthColumn;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthIDType;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthIndex;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthMaterializedQueryTable;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthModule;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthPackage;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthProcedure;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthSchema;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthSequence;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthTable;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthTablespace;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthUDF;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthVariable;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthView;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthXMLSchema;
import org.jkiss.dbeaver.ext.db2.model.security.DB2DatabaseAuth;
import org.jkiss.dbeaver.ext.db2.model.security.DB2GranteeAuthCache;
import org.jkiss.dbeaver.ext.db2.model.security.DB2GranteeDatabaseAuthCache;
import org.jkiss.dbeaver.ext.db2.model.security.DB2GranteeRoleCache;
import org.jkiss.dbeaver.ext.db2.model.security.DB2RoleAuth;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class DB2Grantee
extends DB2GlobalObject
implements DBPRefreshableObject {
    private final DB2GranteeAuthCache authCache = new DB2GranteeAuthCache();
    private final DB2GranteeRoleCache roleCache = new DB2GranteeRoleCache();
    private final DB2GranteeDatabaseAuthCache databaseAuthCache = new DB2GranteeDatabaseAuthCache();
    private Map<Class<?>, Collection<? extends DB2AuthBase>> cachePerObject;
    private String name;

    public DB2Grantee(DBRProgressMonitor monitor, DB2DataSource dataSource, ResultSet resultSet, String keyColName) {
        super(dataSource, true);
        this.name = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)keyColName);
        this.cachePerObject = new HashMap(12);
    }

    public abstract DB2AuthIDType getType();

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.authCache.clearCache();
        this.roleCache.clearCache();
        this.databaseAuthCache.clearCache();
        this.cachePerObject.clear();
        return this;
    }

    @Association
    public Collection<DB2AuthColumn> getColumnsAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthColumn.class);
    }

    @Association
    public Collection<DB2DatabaseAuth> getDatabaseAuths(DBRProgressMonitor monitor) throws DBException {
        return this.databaseAuthCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<DB2AuthUDF> getFunctionsAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthUDF.class);
    }

    @Association
    public Collection<DB2AuthIndex> getIndexesAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthIndex.class);
    }

    @Association
    public Collection<DB2AuthModule> getModulesAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthModule.class);
    }

    @Association
    public Collection<DB2AuthPackage> getPackagesAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthPackage.class);
    }

    @Association
    public Collection<DB2AuthProcedure> getProceduresAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthProcedure.class);
    }

    @Association
    public Collection<DB2RoleAuth> getRoles(DBRProgressMonitor monitor) throws DBException {
        return this.roleCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<DB2AuthSchema> getSchemasAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthSchema.class);
    }

    @Association
    public Collection<DB2AuthSequence> getSequencesAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthSequence.class);
    }

    @Association
    public Collection<DB2AuthTable> getTablesAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthTable.class);
    }

    @Association
    public Collection<DB2AuthTablespace> getTablespacesAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthTablespace.class);
    }

    @Association
    public Collection<DB2AuthVariable> getVariablesAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthVariable.class);
    }

    @Association
    public Collection<DB2AuthView> getViewsAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthView.class);
    }

    @Association
    public Collection<DB2AuthMaterializedQueryTable> getMQTAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthMaterializedQueryTable.class);
    }

    @Association
    public Collection<DB2AuthXMLSchema> getXMLSchemasAuths(DBRProgressMonitor monitor) throws DBException {
        return this.getAuths(monitor, DB2AuthXMLSchema.class);
    }

    private <T extends DB2AuthBase> Collection<T> getAuths(DBRProgressMonitor monitor, Class<T> authClass) throws DBException {
        Collection<? extends DB2AuthBase> listAuths = this.cachePerObject.get(authClass.getClass());
        if (listAuths == null) {
            listAuths = new ArrayList<DB2AuthBase>();
            for (DB2AuthBase db2Auth : this.authCache.getAllObjects(monitor, this)) {
                if (!authClass.isInstance(db2Auth)) continue;
                listAuths.add(db2Auth);
            }
        }
        return listAuths;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }
}

