/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.AnimationManager;
import org.eclipse.ui.internal.progress.IAnimationProcessor;
import org.eclipse.ui.internal.progress.ProgressAnimationItem;

class ProgressAnimationProcessor
implements IAnimationProcessor {
    AnimationManager manager;
    List<AnimationItem> items = new ArrayList<AnimationItem>();

    ProgressAnimationProcessor(AnimationManager animationManager) {
        this.manager = animationManager;
    }

    public void startAnimationLoop(IProgressMonitor monitor) {
        if (this.items.isEmpty()) {
            return;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        while (this.manager.isAnimated() && !monitor.isCanceled()) {
        }
        ProgressAnimationItem[] progressAnimationItemArray = this.getAnimationItems();
        int n = progressAnimationItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProgressAnimationItem animationItem = progressAnimationItemArray[n2];
            animationItem.animationDone();
            ++n2;
        }
    }

    @Override
    public void addItem(AnimationItem item) {
        Assert.isTrue((boolean)(item instanceof ProgressAnimationItem));
        this.items.add(item);
    }

    @Override
    public void removeItem(AnimationItem item) {
        Assert.isTrue((boolean)(item instanceof ProgressAnimationItem));
        this.items.remove(item);
    }

    @Override
    public boolean hasItems() {
        return this.items.size() > 0;
    }

    public void itemsInactiveRedraw() {
    }

    @Override
    public void animationStarted() {
        ProgressAnimationItem[] progressAnimationItemArray = this.getAnimationItems();
        int n = progressAnimationItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProgressAnimationItem animationItem = progressAnimationItemArray[n2];
            ((AnimationItem)animationItem).animationStart();
            ++n2;
        }
    }

    @Override
    public int getPreferredWidth() {
        return 30;
    }

    private ProgressAnimationItem[] getAnimationItems() {
        ProgressAnimationItem[] animationItems = new ProgressAnimationItem[this.items.size()];
        this.items.toArray(animationItems);
        return animationItems;
    }

    @Override
    public void animationFinished() {
        ProgressAnimationItem[] progressAnimationItemArray = this.getAnimationItems();
        int n = progressAnimationItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProgressAnimationItem animationItem = progressAnimationItemArray[n2];
            ((AnimationItem)animationItem).animationDone();
            ++n2;
        }
    }

    @Override
    public boolean isProcessorJob(Job job) {
        return false;
    }
}

