/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMNotSupportedException;
import io.sf.carte.doc.DOMNullCharacterException;
import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.MediaQuery;
import io.sf.carte.doc.style.css.MediaQueryHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.MediaQueryListListener;
import io.sf.carte.doc.style.css.impl.MediaListAccess;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.CSSValueMediaQueryFactory;
import io.sf.carte.doc.style.css.om.MediaQueryImpl;
import io.sf.carte.doc.style.css.parser.AbstractMediaQuery;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.NumberValue;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

class MediaQueryListImpl
implements MediaQueryList,
MediaListAccess,
Serializable {
    private static final long serialVersionUID = 2L;
    private final LinkedList<AbstractMediaQuery> queryList;
    private LinkedList<CSSParseException> queryErrorList = null;
    boolean invalidQueryList = false;
    private boolean hasProxy = false;

    MediaQueryListImpl() {
        this.queryList = new LinkedList();
    }

    MediaQueryListImpl(String medium) {
        this.queryList = new LinkedList();
        if (medium != null && !"all".equalsIgnoreCase(medium)) {
            MediaQueryImpl query = this.createMediaQuery();
            query.setMediaType(medium);
            this.queryList.add(query);
        }
    }

    MediaQueryListImpl(MediaQueryListImpl copyMe) {
        this.queryList = (LinkedList)copyMe.queryList.clone();
        this.invalidQueryList = copyMe.invalidQueryList;
        this.hasProxy = copyMe.hasProxy;
        if (copyMe.queryErrorList != null) {
            this.queryErrorList = copyMe.queryErrorList;
        }
    }

    protected MediaQueryImpl createMediaQuery() {
        return new MediaQueryImpl(){
            private static final long serialVersionUID = 1L;

            @Override
            protected CSSNumberValue createNumberValue(short unit, float valueInSpecifiedUnit, boolean calculated) {
                NumberValue value = NumberValue.createCSSNumberValue(unit, valueInSpecifiedUnit);
                value.setCalculatedNumber(calculated);
                return value;
            }
        };
    }

    @Override
    public String getMedia() {
        if (this.queryList.isEmpty()) {
            if (this.invalidQueryList) {
                return "not all";
            }
            return "all";
        }
        StringBuilder buf = new StringBuilder();
        Iterator it = this.queryList.iterator();
        buf.append(((AbstractMediaQuery)it.next()).getMedia());
        while (it.hasNext()) {
            buf.append(',').append(((AbstractMediaQuery)it.next()).getMedia());
        }
        return buf.toString();
    }

    @Override
    public String getMinifiedMedia() {
        if (this.queryList.isEmpty()) {
            if (this.invalidQueryList) {
                return "not all";
            }
            return "all";
        }
        StringBuilder buf = new StringBuilder();
        Iterator it = this.queryList.iterator();
        buf.append(((AbstractMediaQuery)it.next()).getMinifiedMedia());
        while (it.hasNext()) {
            buf.append(',').append(((AbstractMediaQuery)it.next()).getMinifiedMedia());
        }
        return buf.toString();
    }

    @Override
    public String getMediaText() {
        return this.getMedia();
    }

    @Override
    public void setMediaText(String mediaText) throws DOMException {
        this.queryList.clear();
        if (!this.parse(mediaText, null)) {
            throw new DOMSyntaxException("Invalid media query: " + mediaText);
        }
    }

    @Override
    public int getLength() {
        int sz = this.queryList.size();
        if (sz == 0 && this.invalidQueryList) {
            return 1;
        }
        return sz;
    }

    @Override
    public String item(int index) {
        int sz = this.queryList.size();
        if (sz == 0 && this.invalidQueryList && index == 0) {
            return "not all";
        }
        if (index < 0 || index >= sz) {
            return null;
        }
        return this.queryList.get(index).getMedia();
    }

    @Override
    public MediaQuery getMediaQuery(int index) {
        int sz = this.queryList.size();
        if (index < 0 || index >= sz || this.invalidQueryList) {
            return null;
        }
        return this.queryList.get(index);
    }

    @Override
    public void setMediaQuery(int index, AbstractMediaQuery query) {
        this.queryList.set(index, query);
    }

    @Override
    public MediaQueryList unmodifiable() {
        return this.hasProxy ? this.clone() : new UnmodifiableMediaQueryList();
    }

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        if (!this.parse(newMedium, null)) {
            throw new DOMSyntaxException("Invalid media query: " + newMedium);
        }
    }

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        throw new DOMNotSupportedException("Delete operation not supported");
    }

    @Override
    public boolean matches(String medium, CSSCanvas canvas) {
        if (this.isAllMedia()) {
            return true;
        }
        for (AbstractMediaQuery query : this.queryList) {
            if (!query.matches(medium, canvas)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(MediaQueryList otherMedia) {
        MediaQueryListImpl otherqlist;
        if (otherMedia == null) {
            return !this.isNotAllMedia();
        }
        if (otherMedia.isNotAllMedia()) {
            return false;
        }
        if (this.isAllMedia()) {
            return true;
        }
        if (otherMedia.isAllMedia()) {
            return false;
        }
        if (otherMedia instanceof MediaQueryListImpl) {
            otherqlist = (MediaQueryListImpl)otherMedia;
        } else if (otherMedia.getClass() == UnmodifiableMediaQueryList.class) {
            otherqlist = ((UnmodifiableMediaQueryList)otherMedia).getEnclosingInstance();
        } else {
            return this.oldMatch(otherMedia);
        }
        HashSet<AbstractMediaQuery> otherList = new HashSet<AbstractMediaQuery>(otherqlist.queryList.size());
        otherList.addAll(otherqlist.queryList);
        for (AbstractMediaQuery query : this.queryList) {
            Iterator otherIt = otherList.iterator();
            while (otherIt.hasNext()) {
                AbstractMediaQuery othermq = (AbstractMediaQuery)otherIt.next();
                if (!query.matches(othermq)) continue;
                otherIt.remove();
            }
            if (!otherList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean oldMatch(MediaQueryList otherMedia) {
        int sz = this.getLength();
        HashSet<String> mediastringList = new HashSet<String>(sz);
        for (int i = 0; i < sz; ++i) {
            String item = this.item(i).toLowerCase(Locale.ROOT);
            mediastringList.add(item);
        }
        int osz = otherMedia.getLength();
        for (int i = 0; i < osz; ++i) {
            String item = otherMedia.item(i).toLowerCase(Locale.ROOT);
            if (!mediastringList.contains(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllMedia() {
        return this.queryList.isEmpty() && !this.invalidQueryList;
    }

    @Override
    public boolean isNotAllMedia() {
        return this.invalidQueryList || this.queryList.size() == 1 && this.queryList.get(0).isNotAllMedia();
    }

    @Override
    public boolean hasProxy() {
        return this.hasProxy;
    }

    @Override
    public boolean hasErrors() {
        return this.invalidQueryList || this.queryErrorList != null;
    }

    public LinkedList<CSSParseException> getExceptions() {
        return this.queryErrorList;
    }

    public int hashCode() {
        int result = 1;
        if (this.queryList != null) {
            for (MediaQuery mediaQuery : this.queryList) {
                result += mediaQuery.hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        MediaQueryListImpl other;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == UnmodifiableMediaQueryList.class) {
            other = ((UnmodifiableMediaQueryList)obj).getEnclosingInstance();
        } else if (obj instanceof MediaQueryListImpl) {
            other = (MediaQueryListImpl)obj;
        } else {
            return false;
        }
        return !(this.queryList == null ? other.queryList != null : this.queryList.size() != other.queryList.size() || !this.queryList.containsAll(other.queryList));
    }

    public String toString() {
        return this.getMedia();
    }

    public MediaQueryList clone() {
        return new MediaQueryListImpl(this);
    }

    boolean parse(String mediaQueryString, Node owner) {
        CSSValueMediaQueryFactory mqf = this.getMediaQueryFactory();
        Parser parser = mqf.createParser();
        MyMediaQueryHandler qhandler = new MyMediaQueryHandler(owner);
        this.invalidQueryList = false;
        parser.parseMediaQueryList(mediaQueryString, mqf, qhandler);
        return !this.invalidQueryList;
    }

    protected CSSValueMediaQueryFactory getMediaQueryFactory() {
        return new CSSValueMediaQueryFactory();
    }

    private class UnmodifiableMediaQueryList
    implements MediaQueryList,
    MediaListAccess {
        UnmodifiableMediaQueryList() {
        }

        @Override
        public MediaQuery getMediaQuery(int index) {
            return MediaQueryListImpl.this.getMediaQuery(index);
        }

        @Override
        public String getMedia() {
            return MediaQueryListImpl.this.getMedia();
        }

        @Override
        public String getMinifiedMedia() {
            return MediaQueryListImpl.this.getMinifiedMedia();
        }

        @Override
        public String getMediaText() {
            return this.getMedia();
        }

        @Override
        public int getLength() {
            return MediaQueryListImpl.this.getLength();
        }

        @Override
        public String item(int index) {
            return MediaQueryListImpl.this.item(index);
        }

        @Override
        public boolean isAllMedia() {
            return MediaQueryListImpl.this.isAllMedia();
        }

        @Override
        public boolean isNotAllMedia() {
            return MediaQueryListImpl.this.isNotAllMedia();
        }

        @Override
        public boolean matches(MediaQueryList otherMedia) {
            return MediaQueryListImpl.this.matches(otherMedia);
        }

        @Override
        public boolean matches(String medium, CSSCanvas canvas) {
            return MediaQueryListImpl.this.matches(medium, canvas);
        }

        @Override
        public MediaQueryList unmodifiable() {
            return this;
        }

        public MediaQueryList clone() {
            return this;
        }

        @Override
        public boolean hasProxy() {
            return false;
        }

        @Override
        public boolean hasErrors() {
            return MediaQueryListImpl.this.hasErrors();
        }

        public LinkedList<CSSParseException> getExceptions() {
            return MediaQueryListImpl.this.getExceptions();
        }

        @Override
        public void addListener(MediaQueryListListener listener) {
            MediaQueryListImpl.this.addListener(listener);
        }

        @Override
        public void removeListener(MediaQueryListListener listener) {
            MediaQueryListImpl.this.removeListener(listener);
        }

        public int hashCode() {
            return MediaQueryListImpl.this.hashCode();
        }

        public boolean equals(Object obj) {
            return MediaQueryListImpl.this.equals(obj);
        }

        public String toString() {
            return this.getMedia();
        }

        @Override
        public void setMediaQuery(int index, AbstractMediaQuery query) {
            throw this.createNoModificationAllowedException();
        }

        @Override
        public void setMediaText(String mediaText) throws DOMException {
            throw this.createNoModificationAllowedException();
        }

        @Override
        public void appendMedium(String newMedium) throws DOMException {
            throw this.createNoModificationAllowedException();
        }

        @Override
        public void deleteMedium(String oldMedium) throws DOMException {
            throw this.createNoModificationAllowedException();
        }

        private DOMException createNoModificationAllowedException() {
            return new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
        }

        private MediaQueryListImpl getEnclosingInstance() {
            return MediaQueryListImpl.this;
        }
    }

    class MyMediaQueryHandler
    implements MediaQueryHandler {
        private MediaQueryImpl currentQuery;
        private boolean invalidQuery = false;
        private boolean compatQuery = false;
        private boolean allMedia = false;
        private final Node ownerNode;

        MyMediaQueryHandler(Node ownerNode) {
            this.ownerNode = ownerNode;
        }

        @Override
        public void startQuery() {
            this.currentQuery = MediaQueryListImpl.this.createMediaQuery();
        }

        @Override
        public void mediaType(String mediaType) {
            String unescaped;
            try {
                unescaped = ParseHelper.unescapeStringValue(mediaType, false, false);
            }
            catch (DOMNullCharacterException e) {
                unescaped = mediaType;
            }
            this.currentQuery.setMediaType(unescaped);
        }

        @Override
        public void negativeQuery() {
            this.currentQuery.setNegative(true);
        }

        @Override
        public void onlyPrefix() {
            this.currentQuery.setOnlyPrefix(true);
        }

        @Override
        public void condition(BooleanCondition condition) {
            this.currentQuery.setFeaturePredicate(condition);
        }

        @Override
        public void endQuery() {
            if (!this.invalidQuery) {
                if (!this.currentQuery.isNotAllMedia() || !this.containsNotAll()) {
                    MediaQueryListImpl.this.queryList.add(this.currentQuery);
                }
                if (MediaQueryListImpl.this.invalidQueryList && !this.compatQuery) {
                    MediaQueryListImpl.this.invalidQueryList = false;
                }
                if (this.currentQuery.isAllMedia()) {
                    this.allMedia = true;
                }
            }
            this.currentQuery = null;
            this.invalidQuery = false;
            this.compatQuery = false;
        }

        private boolean containsNotAll() {
            for (AbstractMediaQuery query : MediaQueryListImpl.this.queryList) {
                if (!query.isNotAllMedia()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void endQueryList() {
            if (this.allMedia) {
                MediaQueryListImpl.this.queryList.clear();
            }
        }

        @Override
        public MediaQueryList getMediaQueryList() {
            return MediaQueryListImpl.this;
        }

        @Override
        public void setContainsProxy() {
            MediaQueryListImpl.this.hasProxy = true;
        }

        @Override
        public boolean reportsErrors() {
            return this.ownerNode != null;
        }

        @Override
        public void invalidQuery(CSSParseException queryError) {
            this.invalidQuery = true;
            MediaQueryListImpl.this.invalidQueryList = true;
            if (MediaQueryListImpl.this.queryErrorList == null) {
                MediaQueryListImpl.this.queryErrorList = new LinkedList();
            }
            MediaQueryListImpl.this.queryErrorList.add(queryError);
            if (this.ownerNode != null) {
                CSSMediaException e = new CSSMediaException(queryError);
                ((CSSDocument)this.ownerNode.getOwnerDocument()).getErrorHandler().mediaQueryError(this.ownerNode, e);
            }
        }

        @Override
        public void compatQuery(CSSParseException exception) {
            MediaQueryListImpl.this.invalidQueryList = true;
            this.compatQuery = true;
            if (MediaQueryListImpl.this.queryErrorList == null) {
                MediaQueryListImpl.this.queryErrorList = new LinkedList();
            }
            MediaQueryListImpl.this.queryErrorList.add(exception);
            if (this.ownerNode != null) {
                CSSMediaException e = new CSSMediaException(exception);
                ((CSSDocument)this.ownerNode.getOwnerDocument()).getErrorHandler().mediaQueryWarning(this.ownerNode, e);
            }
        }
    }
}

