# Contributing

Thank you for your interest in contributing to the E-Series SANtricity Collection! 🎉

We appreciate that you want to take the time to contribute! Please follow these steps before submitting your PR.

## Creating a Pull Request

1. Please search [existing issues](https://github.com/netappeseries/santricity/issues) to determine if an issue already exists for what you intend to contribute.
2. If the issue does not exist, [create a new one](https://github.com/netappeseries/santricity/issues/new) that explains the bug or feature request.
    * Let us know in the issue that you plan on creating a pull request for it. This helps us to keep track of the pull request and make sure there isn't duplicate effort.
3. Before creating a pull request, write up a brief proposal in the issue describing what your change would be and how it would work so that others can comment.
    * It's better to wait for feedback from someone on NetApp's E-Series SANtricity Collection development team before writing code. We don't have an SLA for our feedback, but we will do our best to respond in a timely manner (at a minimum, to give you an idea if you're on the right track and that you should proceed, or not).
4. Sign and submit [NetApp's Corporate Contributor License Agreement (CCLA)](https://netapp.tap.thinksmart.com/prod/Portal/ShowWorkFlow/AnonymousEmbed/3d2f3aa5-9161-4970-997d-e482b0b033fa).
    * From the **Project Name** dropdown select `E-Series SANtricity Collection`.
    * For the **Project Website** specify `https://github.com/netappeseries/santricity`
5. If you've made it this far, have written the code that solves your issue, and addressed the review comments, then feel free to create your pull request.

Important: **NetApp will NOT look at the PR or any of the code submitted in the PR if the CCLA is not on file with NetApp Legal.**

## E-Series SANtricity Collection Team's Commitment

While we truly appreciate your efforts on pull requests, we **cannot** commit to including your PR in the E-Series SANtricity Collection project. Here are a few reasons why:

* There are many factors involved in integrating new code into this project, including things like:
    * support for a wide variety of NetApp backends
    * proper adherence to our existing and/or upcoming architecture
    * sufficient functional and/or scenario tests across all backends
    * etc.

In other words, while your bug fix or feature may be perfect as a standalone patch, we have to ensure that the changes work in all use cases, configurations, backends and across our support matrix.

* The E-Series SANtricity Collection team must plan our resources to integrate your code into our code base and CI platform, and depending on the complexity of your PR, we may or may not have the resources available to make it happen in a timely fashion. We'll do our best.

* Sometimes a PR doesn't fit into our future plans or conflicts with other items on the roadmap. It's possible that a PR you submit doesn't align with our upcoming plans, thus we won't be able to use it. It's not personal.

Thank you for considering to contribute to the E-Series SANtricity Collection project!