﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanroomsml/CleanRoomsMLRequest.h>
#include <aws/cleanroomsml/CleanRoomsML_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace CleanRoomsML {
namespace Model {

/**
 */
class GetConfiguredAudienceModelRequest : public CleanRoomsMLRequest {
 public:
  AWS_CLEANROOMSML_API GetConfiguredAudienceModelRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetConfiguredAudienceModel"; }

  AWS_CLEANROOMSML_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the configured audience model that you are
   * interested in.</p>
   */
  inline const Aws::String& GetConfiguredAudienceModelArn() const { return m_configuredAudienceModelArn; }
  inline bool ConfiguredAudienceModelArnHasBeenSet() const { return m_configuredAudienceModelArnHasBeenSet; }
  template <typename ConfiguredAudienceModelArnT = Aws::String>
  void SetConfiguredAudienceModelArn(ConfiguredAudienceModelArnT&& value) {
    m_configuredAudienceModelArnHasBeenSet = true;
    m_configuredAudienceModelArn = std::forward<ConfiguredAudienceModelArnT>(value);
  }
  template <typename ConfiguredAudienceModelArnT = Aws::String>
  GetConfiguredAudienceModelRequest& WithConfiguredAudienceModelArn(ConfiguredAudienceModelArnT&& value) {
    SetConfiguredAudienceModelArn(std::forward<ConfiguredAudienceModelArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_configuredAudienceModelArn;
  bool m_configuredAudienceModelArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRoomsML
}  // namespace Aws
