﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/MalwareProtectionPlanSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {
class ListMalwareProtectionPlansResult {
 public:
  AWS_GUARDDUTY_API ListMalwareProtectionPlansResult() = default;
  AWS_GUARDDUTY_API ListMalwareProtectionPlansResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GUARDDUTY_API ListMalwareProtectionPlansResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of unique identifiers associated with each Malware Protection
   * plan.</p>
   */
  inline const Aws::Vector<MalwareProtectionPlanSummary>& GetMalwareProtectionPlans() const { return m_malwareProtectionPlans; }
  template <typename MalwareProtectionPlansT = Aws::Vector<MalwareProtectionPlanSummary>>
  void SetMalwareProtectionPlans(MalwareProtectionPlansT&& value) {
    m_malwareProtectionPlansHasBeenSet = true;
    m_malwareProtectionPlans = std::forward<MalwareProtectionPlansT>(value);
  }
  template <typename MalwareProtectionPlansT = Aws::Vector<MalwareProtectionPlanSummary>>
  ListMalwareProtectionPlansResult& WithMalwareProtectionPlans(MalwareProtectionPlansT&& value) {
    SetMalwareProtectionPlans(std::forward<MalwareProtectionPlansT>(value));
    return *this;
  }
  template <typename MalwareProtectionPlansT = MalwareProtectionPlanSummary>
  ListMalwareProtectionPlansResult& AddMalwareProtectionPlans(MalwareProtectionPlansT&& value) {
    m_malwareProtectionPlansHasBeenSet = true;
    m_malwareProtectionPlans.emplace_back(std::forward<MalwareProtectionPlansT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>You can use this parameter when paginating results. Set the value of this
   * parameter to null on your first call to the list action. For subsequent calls to
   * the action, fill nextToken in the request with the value of
   * <code>NextToken</code> from the previous response to continue listing data.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListMalwareProtectionPlansResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListMalwareProtectionPlansResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<MalwareProtectionPlanSummary> m_malwareProtectionPlans;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_malwareProtectionPlansHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
