﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotwireless/IoTWireless_EXPORTS.h>
#include <aws/iotwireless/model/LoRaWANDevice.h>
#include <aws/iotwireless/model/PositioningConfigStatus.h>
#include <aws/iotwireless/model/SidewalkDevice.h>
#include <aws/iotwireless/model/WirelessDeviceType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoTWireless {
namespace Model {
class GetWirelessDeviceResult {
 public:
  AWS_IOTWIRELESS_API GetWirelessDeviceResult() = default;
  AWS_IOTWIRELESS_API GetWirelessDeviceResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOTWIRELESS_API GetWirelessDeviceResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The wireless device type.</p>
   */
  inline WirelessDeviceType GetType() const { return m_type; }
  inline void SetType(WirelessDeviceType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline GetWirelessDeviceResult& WithType(WirelessDeviceType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the resource.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetWirelessDeviceResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the resource.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  GetWirelessDeviceResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the destination to which the device is assigned.</p>
   */
  inline const Aws::String& GetDestinationName() const { return m_destinationName; }
  template <typename DestinationNameT = Aws::String>
  void SetDestinationName(DestinationNameT&& value) {
    m_destinationNameHasBeenSet = true;
    m_destinationName = std::forward<DestinationNameT>(value);
  }
  template <typename DestinationNameT = Aws::String>
  GetWirelessDeviceResult& WithDestinationName(DestinationNameT&& value) {
    SetDestinationName(std::forward<DestinationNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the wireless device.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  GetWirelessDeviceResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name of the resource.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  GetWirelessDeviceResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the thing associated with the wireless device. The value is empty
   * if a thing isn't associated with the device.</p>
   */
  inline const Aws::String& GetThingName() const { return m_thingName; }
  template <typename ThingNameT = Aws::String>
  void SetThingName(ThingNameT&& value) {
    m_thingNameHasBeenSet = true;
    m_thingName = std::forward<ThingNameT>(value);
  }
  template <typename ThingNameT = Aws::String>
  GetWirelessDeviceResult& WithThingName(ThingNameT&& value) {
    SetThingName(std::forward<ThingNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the thing associated with the wireless device.</p>
   */
  inline const Aws::String& GetThingArn() const { return m_thingArn; }
  template <typename ThingArnT = Aws::String>
  void SetThingArn(ThingArnT&& value) {
    m_thingArnHasBeenSet = true;
    m_thingArn = std::forward<ThingArnT>(value);
  }
  template <typename ThingArnT = Aws::String>
  GetWirelessDeviceResult& WithThingArn(ThingArnT&& value) {
    SetThingArn(std::forward<ThingArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the wireless device.</p>
   */
  inline const LoRaWANDevice& GetLoRaWAN() const { return m_loRaWAN; }
  template <typename LoRaWANT = LoRaWANDevice>
  void SetLoRaWAN(LoRaWANT&& value) {
    m_loRaWANHasBeenSet = true;
    m_loRaWAN = std::forward<LoRaWANT>(value);
  }
  template <typename LoRaWANT = LoRaWANDevice>
  GetWirelessDeviceResult& WithLoRaWAN(LoRaWANT&& value) {
    SetLoRaWAN(std::forward<LoRaWANT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Sidewalk device object.</p>
   */
  inline const SidewalkDevice& GetSidewalk() const { return m_sidewalk; }
  template <typename SidewalkT = SidewalkDevice>
  void SetSidewalk(SidewalkT&& value) {
    m_sidewalkHasBeenSet = true;
    m_sidewalk = std::forward<SidewalkT>(value);
  }
  template <typename SidewalkT = SidewalkDevice>
  GetWirelessDeviceResult& WithSidewalk(SidewalkT&& value) {
    SetSidewalk(std::forward<SidewalkT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The integration status of the Device Location feature for LoRaWAN and
   * Sidewalk devices.</p>
   */
  inline PositioningConfigStatus GetPositioning() const { return m_positioning; }
  inline void SetPositioning(PositioningConfigStatus value) {
    m_positioningHasBeenSet = true;
    m_positioning = value;
  }
  inline GetWirelessDeviceResult& WithPositioning(PositioningConfigStatus value) {
    SetPositioning(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetWirelessDeviceResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  WirelessDeviceType m_type{WirelessDeviceType::NOT_SET};

  Aws::String m_name;

  Aws::String m_description;

  Aws::String m_destinationName;

  Aws::String m_id;

  Aws::String m_arn;

  Aws::String m_thingName;

  Aws::String m_thingArn;

  LoRaWANDevice m_loRaWAN;

  SidewalkDevice m_sidewalk;

  PositioningConfigStatus m_positioning{PositioningConfigStatus::NOT_SET};

  Aws::String m_requestId;
  bool m_typeHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_destinationNameHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_thingNameHasBeenSet = false;
  bool m_thingArnHasBeenSet = false;
  bool m_loRaWANHasBeenSet = false;
  bool m_sidewalkHasBeenSet = false;
  bool m_positioningHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTWireless
}  // namespace Aws
