﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/qapps/QAppsRequest.h>
#include <aws/qapps/QApps_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace QApps {
namespace Model {

/**
 */
class GetLibraryItemRequest : public QAppsRequest {
 public:
  AWS_QAPPS_API GetLibraryItemRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetLibraryItem"; }

  AWS_QAPPS_API Aws::String SerializePayload() const override;

  AWS_QAPPS_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  AWS_QAPPS_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The unique identifier of the Amazon Q Business application environment
   * instance.</p>
   */
  inline const Aws::String& GetInstanceId() const { return m_instanceId; }
  inline bool InstanceIdHasBeenSet() const { return m_instanceIdHasBeenSet; }
  template <typename InstanceIdT = Aws::String>
  void SetInstanceId(InstanceIdT&& value) {
    m_instanceIdHasBeenSet = true;
    m_instanceId = std::forward<InstanceIdT>(value);
  }
  template <typename InstanceIdT = Aws::String>
  GetLibraryItemRequest& WithInstanceId(InstanceIdT&& value) {
    SetInstanceId(std::forward<InstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the library item to retrieve.</p>
   */
  inline const Aws::String& GetLibraryItemId() const { return m_libraryItemId; }
  inline bool LibraryItemIdHasBeenSet() const { return m_libraryItemIdHasBeenSet; }
  template <typename LibraryItemIdT = Aws::String>
  void SetLibraryItemId(LibraryItemIdT&& value) {
    m_libraryItemIdHasBeenSet = true;
    m_libraryItemId = std::forward<LibraryItemIdT>(value);
  }
  template <typename LibraryItemIdT = Aws::String>
  GetLibraryItemRequest& WithLibraryItemId(LibraryItemIdT&& value) {
    SetLibraryItemId(std::forward<LibraryItemIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the Amazon Q App associated with the library
   * item.</p>
   */
  inline const Aws::String& GetAppId() const { return m_appId; }
  inline bool AppIdHasBeenSet() const { return m_appIdHasBeenSet; }
  template <typename AppIdT = Aws::String>
  void SetAppId(AppIdT&& value) {
    m_appIdHasBeenSet = true;
    m_appId = std::forward<AppIdT>(value);
  }
  template <typename AppIdT = Aws::String>
  GetLibraryItemRequest& WithAppId(AppIdT&& value) {
    SetAppId(std::forward<AppIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_instanceId;

  Aws::String m_libraryItemId;

  Aws::String m_appId;
  bool m_instanceIdHasBeenSet = false;
  bool m_libraryItemIdHasBeenSet = false;
  bool m_appIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace QApps
}  // namespace Aws
