﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/lightsail/Lightsail_EXPORTS.h>
#include <aws/lightsail/model/MetricUnit.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Lightsail {
namespace Model {

/**
 * <p>Describes the metric data point.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/MetricDatapoint">AWS
 * API Reference</a></p>
 */
class MetricDatapoint {
 public:
  AWS_LIGHTSAIL_API MetricDatapoint() = default;
  AWS_LIGHTSAIL_API MetricDatapoint(Aws::Utils::Json::JsonView jsonValue);
  AWS_LIGHTSAIL_API MetricDatapoint& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LIGHTSAIL_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The average.</p>
   */
  inline double GetAverage() const { return m_average; }
  inline bool AverageHasBeenSet() const { return m_averageHasBeenSet; }
  inline void SetAverage(double value) {
    m_averageHasBeenSet = true;
    m_average = value;
  }
  inline MetricDatapoint& WithAverage(double value) {
    SetAverage(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum.</p>
   */
  inline double GetMaximum() const { return m_maximum; }
  inline bool MaximumHasBeenSet() const { return m_maximumHasBeenSet; }
  inline void SetMaximum(double value) {
    m_maximumHasBeenSet = true;
    m_maximum = value;
  }
  inline MetricDatapoint& WithMaximum(double value) {
    SetMaximum(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The minimum.</p>
   */
  inline double GetMinimum() const { return m_minimum; }
  inline bool MinimumHasBeenSet() const { return m_minimumHasBeenSet; }
  inline void SetMinimum(double value) {
    m_minimumHasBeenSet = true;
    m_minimum = value;
  }
  inline MetricDatapoint& WithMinimum(double value) {
    SetMinimum(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The sample count.</p>
   */
  inline double GetSampleCount() const { return m_sampleCount; }
  inline bool SampleCountHasBeenSet() const { return m_sampleCountHasBeenSet; }
  inline void SetSampleCount(double value) {
    m_sampleCountHasBeenSet = true;
    m_sampleCount = value;
  }
  inline MetricDatapoint& WithSampleCount(double value) {
    SetSampleCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The sum.</p>
   */
  inline double GetSum() const { return m_sum; }
  inline bool SumHasBeenSet() const { return m_sumHasBeenSet; }
  inline void SetSum(double value) {
    m_sumHasBeenSet = true;
    m_sum = value;
  }
  inline MetricDatapoint& WithSum(double value) {
    SetSum(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp (<code>1479816991.349</code>).</p>
   */
  inline const Aws::Utils::DateTime& GetTimestamp() const { return m_timestamp; }
  inline bool TimestampHasBeenSet() const { return m_timestampHasBeenSet; }
  template <typename TimestampT = Aws::Utils::DateTime>
  void SetTimestamp(TimestampT&& value) {
    m_timestampHasBeenSet = true;
    m_timestamp = std::forward<TimestampT>(value);
  }
  template <typename TimestampT = Aws::Utils::DateTime>
  MetricDatapoint& WithTimestamp(TimestampT&& value) {
    SetTimestamp(std::forward<TimestampT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unit. </p>
   */
  inline MetricUnit GetUnit() const { return m_unit; }
  inline bool UnitHasBeenSet() const { return m_unitHasBeenSet; }
  inline void SetUnit(MetricUnit value) {
    m_unitHasBeenSet = true;
    m_unit = value;
  }
  inline MetricDatapoint& WithUnit(MetricUnit value) {
    SetUnit(value);
    return *this;
  }
  ///@}
 private:
  double m_average{0.0};

  double m_maximum{0.0};

  double m_minimum{0.0};

  double m_sampleCount{0.0};

  double m_sum{0.0};

  Aws::Utils::DateTime m_timestamp{};

  MetricUnit m_unit{MetricUnit::NOT_SET};
  bool m_averageHasBeenSet = false;
  bool m_maximumHasBeenSet = false;
  bool m_minimumHasBeenSet = false;
  bool m_sampleCountHasBeenSet = false;
  bool m_sumHasBeenSet = false;
  bool m_timestampHasBeenSet = false;
  bool m_unitHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
