/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.transport.cipher;

import com.hierynomus.sshj.transport.cipher.GcmCipher;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.transport.cipher.Cipher;

public class GcmCiphers {
    public static final String GALOIS_COUNTER_MODE = "GCM";

    public static Factory AES128GCM() {
        return new Factory(12, 16, 128, "aes128-gcm@openssh.com", "AES", GALOIS_COUNTER_MODE);
    }

    public static Factory AES256GCM() {
        return new Factory(12, 16, 256, "aes256-gcm@openssh.com", "AES", GALOIS_COUNTER_MODE);
    }

    public static class Factory
    implements Factory.Named<Cipher> {
        private final int keysize;
        private final int authSize;
        private final String cipher;
        private final String mode;
        private final String name;
        private final int ivsize;

        public Factory(int ivsize, int authSize, int keysize, String name, String cipher, String mode) {
            this.name = name;
            this.keysize = keysize;
            this.cipher = cipher;
            this.mode = mode;
            this.ivsize = ivsize;
            this.authSize = authSize;
        }

        @Override
        public Cipher create() {
            return new GcmCipher(this.ivsize, this.authSize, this.keysize / 8, this.cipher, this.cipher + "/" + this.mode + "/NoPadding");
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

