/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.meta.IPropertyValueTransformer;

public class DBPositiveNumberTransformer
implements IPropertyValueTransformer<Object, Number> {
    @Override
    @Nullable
    public Number transform(@NotNull Object object, @Nullable Number value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double && value.doubleValue() <= 0.0) {
            return null;
        }
        if (value instanceof Float && (double)value.floatValue() <= 0.0) {
            return null;
        }
        if (value.longValue() <= 0L) {
            return null;
        }
        return value;
    }
}

