/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreServerHome;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceURLProvider;
import org.jkiss.dbeaver.model.DatabaseURL;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.connection.NativeClientLocationUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.LocalSystemRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class PostgreDataSourceProvider
extends JDBCDataSourceProvider
implements DBPNativeClientLocationManager {
    private static Map<String, String> connectionsProps = new HashMap<String, String>();
    @Nullable
    private static Collection<DBPNativeClientLocation> localClients;

    public static Map<String, String> getConnectionsProps() {
        return connectionsProps;
    }

    public long getFeatures() {
        return 3L;
    }

    @NotNull
    public String getConnectionURL(@NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        DBPDataSourceURLProvider sourceURLProvider;
        String connectionURL;
        DBAAuthModel authModel;
        DBPConnectionConfiguration configToUse = connectionInfo;
        String databaseName = connectionInfo.getDatabaseName();
        if (databaseName != null && databaseName.contains("/")) {
            configToUse = new DBPConnectionConfiguration(connectionInfo);
            configToUse.setDatabaseName(databaseName.replace("/", "%2F"));
        }
        if ((authModel = configToUse.getAuthModel()) instanceof DBPDataSourceURLProvider && CommonUtils.isNotEmpty((String)(connectionURL = (sourceURLProvider = (DBPDataSourceURLProvider)authModel).getConnectionURL(driver, configToUse)))) {
            return connectionURL;
        }
        if (configToUse.getConfigurationType() == DBPDriverConfigurationType.URL) {
            return configToUse.getUrl();
        }
        PostgreServerType serverType = PostgreUtils.getServerType(driver);
        if (serverType.supportsCustomConnectionURL()) {
            return DatabaseURL.generateUrlByTemplate((DBPDriver)driver, (DBPConnectionConfiguration)configToUse);
        }
        StringBuilder url = new StringBuilder("jdbc:postgresql://");
        url.append(configToUse.getHostName());
        if (!CommonUtils.isEmpty((String)configToUse.getHostPort())) {
            url.append(":").append(configToUse.getHostPort());
        }
        url.append("/");
        if (!CommonUtils.isEmpty((String)configToUse.getDatabaseName())) {
            url.append(configToUse.getDatabaseName());
        }
        return url.toString();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new PostgreDataSource(monitor, container);
    }

    public boolean providesDriverClasses() {
        return true;
    }

    public List<DBPNativeClientLocation> findLocalClientLocations() {
        return new ArrayList<DBPNativeClientLocation>(PostgreDataSourceProvider.findLocalClients());
    }

    public DBPNativeClientLocation getDefaultLocalClientLocation() {
        return (DBPNativeClientLocation)CommonUtils.getFirstOrNull(this.findLocalClientLocations());
    }

    public String getProductName(DBPNativeClientLocation location) {
        if (location instanceof PostgreServerHome) {
            return location.getDisplayName();
        }
        return "PostgreSQL";
    }

    public String getProductVersion(DBPNativeClientLocation location) {
        return PostgreDataSourceProvider.getFullServerVersion(location.getPath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized Collection<DBPNativeClientLocation> findLocalClients() {
        if (localClients != null) {
            return localClients;
        }
        if (RuntimeUtils.isWindows()) {
            localClients = new HashSet<DBPNativeClientLocation>();
            try {
                String[] homeKeys;
                LocalSystemRegistry.Registry registry = LocalSystemRegistry.getInstance();
                if (!registry.registryKeyExists("HKEY_LOCAL_MACHINE", "SOFTWARE\\PostgreSQL\\Installations") || (homeKeys = registry.registryGetKeys("HKEY_LOCAL_MACHINE", "SOFTWARE\\PostgreSQL\\Installations")) == null) return localClients;
                block2: for (String homeKey : homeKeys) {
                    Map valuesMap = registry.registryGetValues("HKEY_LOCAL_MACHINE", "SOFTWARE\\PostgreSQL\\Installations\\" + homeKey);
                    for (String key : valuesMap.keySet()) {
                        if (!"Base Directory".equalsIgnoreCase(key)) continue;
                        String baseDir = CommonUtils.removeTrailingSlash((String)CommonUtils.toString(valuesMap.get("Base Directory")));
                        String branding = CommonUtils.toString(valuesMap.get("Branding"));
                        localClients.add((DBPNativeClientLocation)new PostgreServerHome(homeKey, baseDir, branding));
                        continue block2;
                    }
                }
                return localClients;
            }
            catch (Throwable e) {
                log.warn((Object)"Error reading Windows registry", e);
                return localClients;
            }
        } else {
            localClients = NativeClientLocationUtils.findLocalClientsOnUnix(List.of("/Library/PostgreSQL", "/Applications/Postgres.app/Contents/versions"), List.of("bin/psql"), path -> {
                String absolutePath = path.toAbsolutePath().toString();
                return new PostgreServerHome(absolutePath, absolutePath, absolutePath);
            }).values();
        }
        return localClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getFullServerVersion(File path) {
        File binPath = path;
        File binSubfolder = new File(binPath, "bin");
        if (binSubfolder.exists()) {
            binPath = binSubfolder;
        }
        String cmd = new File(binPath, RuntimeUtils.getNativeBinaryName((String)"psql")).getAbsolutePath();
        try {
            Process p = Runtime.getRuntime().exec(new String[]{cmd, "--version"});
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line = input.readLine();
                    if (line == null) return null;
                    String string = line;
                    return string;
                }
                finally {
                    IOUtils.close((Closeable)input);
                }
            }
            finally {
                p.destroy();
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Error reading PostgreSQL local client version from " + cmd), (Throwable)ex);
        }
        return null;
    }

    static {
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        if (preferenceStore != null) {
            PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)preferenceStore, (String)"postgresql.dd.plain.string", (Object)false);
            PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)preferenceStore, (String)"postgresql.dd.tag.string", (Object)false);
        }
    }
}

