/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.INavigatorListener;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.DatabaseLazyEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.ILazyEditor;
import org.jkiss.dbeaver.ui.editors.INavigatorEditorInput;

public class DatabaseEditorListener
implements INavigatorListener {
    private final IDatabaseEditor databaseEditor;
    private DBPDataSourceContainer dataSourceContainer;

    DatabaseEditorListener(IDatabaseEditor databaseEditor) {
        this.databaseEditor = databaseEditor;
        IEditorInput editorInput = databaseEditor.getEditorInput();
        if (editorInput instanceof IDatabaseEditorInput) {
            IDatabaseEditorInput databaseEditorInput = (IDatabaseEditorInput)editorInput;
            DBSObject dBSObject = databaseEditorInput.getDatabaseObject();
            if (dBSObject instanceof DBPDataSourceContainer) {
                DBPDataSourceContainer container;
                this.dataSourceContainer = container = (DBPDataSourceContainer)dBSObject;
            } else if (databaseEditorInput.getNavigatorNode() != null) {
                this.dataSourceContainer = databaseEditorInput.getNavigatorNode().getDataSourceContainer();
            }
            if (this.dataSourceContainer != null) {
                this.dataSourceContainer.acquire((DBPDataSourceTask)databaseEditor);
            }
        }
        DBWorkbench.getPlatform().getNavigatorModel().addListener((INavigatorListener)this);
    }

    public void dispose() {
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.release((DBPDataSourceTask)this.databaseEditor);
            this.dataSourceContainer = null;
        }
        DBWorkbench.getPlatform().getNavigatorModel().removeListener((INavigatorListener)this);
    }

    public void nodeChanged(DBNEvent event) {
        if (this.isValuableNode(event.getNode())) {
            Strategy strategy = Strategy.DO_NOTHING;
            if (event.getAction() == DBNEvent.Action.REMOVE) {
                strategy = Strategy.CLOSE;
            } else if (event.getAction() == DBNEvent.Action.UPDATE) {
                if (event.getNodeChange() == DBNEvent.NodeChange.REFRESH || event.getNodeChange() == DBNEvent.NodeChange.LOAD) {
                    if (this.isSameNode(event.getNode())) {
                        this.databaseEditor.refreshPart(event, event.getNodeChange() == DBNEvent.NodeChange.REFRESH && event.getSource() == DBNEvent.FORCE_REFRESH);
                    } else if (event.getNodeChange() == DBNEvent.NodeChange.LOAD && event.getNode() instanceof DBNDataSource) {
                        strategy = Strategy.LOAD;
                    }
                } else if (event.getNodeChange() == DBNEvent.NodeChange.UNLOAD) {
                    strategy = Strategy.UNLOAD;
                }
            }
            if (strategy != Strategy.DO_NOTHING) {
                IWorkbenchPage workbenchPage;
                if (DBWorkbench.getPlatform().isShuttingDown()) {
                    this.dispose();
                    return;
                }
                if (strategy == Strategy.LOAD) {
                    if (this.databaseEditor instanceof ILazyEditor) {
                        ((ILazyEditor)((Object)this.databaseEditor)).loadEditorInput();
                    }
                    return;
                }
                if (strategy == Strategy.UNLOAD && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ui.editors.keep-editors-on-disconnect") && this.databaseEditor instanceof ILazyEditor && ((ILazyEditor)((Object)this.databaseEditor)).unloadEditorInput()) {
                    return;
                }
                IWorkbenchWindow workbenchWindow = this.databaseEditor.getSite().getWorkbenchWindow();
                if (workbenchWindow != null && (workbenchPage = workbenchWindow.getActivePage()) != null) {
                    workbenchPage.closeEditor((IEditorPart)this.databaseEditor, false);
                }
            }
        }
    }

    private boolean isSameNode(@NotNull DBNNode other) {
        DBNNode editorNode = this.getEditorNode();
        if (editorNode != null) {
            return editorNode == other;
        }
        String path = this.getEditorNodePath();
        return path != null && path.equals(other.getNodeUri());
    }

    private boolean isValuableNode(@NotNull DBNNode node) {
        DBNNode editorNode = this.getEditorNode();
        if (editorNode != null) {
            return editorNode == node || editorNode.isChildOf(node);
        }
        String path = this.getEditorNodePath();
        return path != null && path.startsWith(node.getNodeUri());
    }

    @Nullable
    private DBNNode getEditorNode() {
        IEditorInput input = this.databaseEditor.getEditorInput();
        if (input instanceof INavigatorEditorInput) {
            INavigatorEditorInput navigatorEditorInput = (INavigatorEditorInput)input;
            return navigatorEditorInput.getNavigatorNode();
        }
        return null;
    }

    @Nullable
    private String getEditorNodePath() {
        IEditorInput input = this.databaseEditor.getEditorInput();
        if (input instanceof DatabaseLazyEditorInput) {
            DatabaseLazyEditorInput lazyEditorInput = (DatabaseLazyEditorInput)input;
            return lazyEditorInput.getNodePath();
        }
        if (input instanceof IDatabaseEditorInput) {
            IDatabaseEditorInput databaseEditorInput = (IDatabaseEditorInput)input;
            DBNDatabaseNode navigatorNode = databaseEditorInput.getNavigatorNode();
            return navigatorNode == null ? null : navigatorNode.getNodeUri();
        }
        return null;
    }

    private static enum Strategy {
        DO_NOTHING,
        CLOSE,
        UNLOAD,
        LOAD;

    }
}

