/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.rules.EndOfLineRule;

public class SQLKeywordLineRule
extends EndOfLineRule {
    public SQLKeywordLineRule(String keywordString, TPToken token) {
        super(keywordString, token);
    }

    @Override
    protected TPToken doEvaluate(TPCharacterScanner scanner, boolean resume) {
        int c;
        if (resume ? this.endSequenceDetected(scanner) : Character.toLowerCase(c = scanner.read()) == Character.toLowerCase(this.fStartSequence[0]) && this.caselessSequenceDetected(scanner, this.fStartSequence, false) && this.endSequenceDetected(scanner)) {
            return this.fToken;
        }
        scanner.unread();
        return TPTokenAbstract.UNDEFINED;
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner, boolean resume) {
        if (this.fColumn == -1) {
            return this.doEvaluate(scanner, resume);
        }
        int c = scanner.read();
        scanner.unread();
        if (Character.toLowerCase(c) == Character.toLowerCase(this.fStartSequence[0])) {
            return this.fColumn == scanner.getColumn() ? this.doEvaluate(scanner, resume) : TPTokenAbstract.UNDEFINED;
        }
        return TPTokenAbstract.UNDEFINED;
    }

    protected boolean caselessSequenceDetected(TPCharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        for (int i = 1; i < sequence.length; ++i) {
            int c = scanner.read();
            if (Character.toLowerCase(c) == Character.toLowerCase(sequence[i])) continue;
            scanner.unread();
            for (int j = i - 1; j > 0; --j) {
                scanner.unread();
            }
            return false;
        }
        int nc = scanner.read();
        if (Character.isLetterOrDigit(nc)) {
            for (int j = sequence.length; j > 0; --j) {
                scanner.unread();
            }
            return false;
        }
        scanner.unread();
        return true;
    }
}

