/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.sql.task;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class SQLScriptDataReceiver
implements DBDDataReceiver {
    private Integer rowSize;
    private Writer dumpWriter;
    private List<? extends DBCAttributeMetaData> attributes;

    public void fetchStart(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
        if (resultSet == null) {
            return;
        }
        if (this.dumpWriter != null) {
            DBCResultSetMetaData rsMeta = resultSet.getMeta();
            this.attributes = rsMeta.getAttributes();
            this.rowSize = this.attributes.size();
            try {
                this.dumpWriter.append("Columns:\t");
                for (DBCAttributeMetaData dBCAttributeMetaData : this.attributes) {
                    this.dumpWriter.append(dBCAttributeMetaData.getLabel() + "\t");
                }
                this.dumpWriter.append("\n");
            }
            catch (IOException e1) {
                throw new DBCException("IOException writing to dumpWriter", (Throwable)e1);
            }
        }
    }

    public void fetchRow(@NotNull DBCSession session, @NotNull DBCResultSet resultSet) throws DBCException {
        if (resultSet == null) {
            return;
        }
        if (this.dumpWriter != null) {
            try {
                for (int i = 0; i < this.rowSize; ++i) {
                    if (resultSet.getAttributeValue(i) != null) {
                        DBCAttributeMetaData type = this.attributes.get(i);
                        DBDValueHandler valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)type);
                        Object object = valueHandler.fetchValueObject(session, resultSet, (DBSTypedObject)type, i);
                        this.dumpWriter.append(object.toString()).append("\t");
                        continue;
                    }
                    this.dumpWriter.append("NULL\t");
                }
                this.dumpWriter.append("\n");
            }
            catch (IOException e) {
                throw new DBCException("IOException writing to dumpWriter", (Throwable)e);
            }
        }
    }

    public void fetchEnd(@NotNull DBCSession session, @NotNull DBCResultSet resultSet) throws DBCException {
        if (this.dumpWriter != null) {
            try {
                this.dumpWriter.flush();
            }
            catch (IOException e) {
                throw new DBCException("IOException writing to dumpWriter", (Throwable)e);
            }
        }
    }

    public void close() {
    }

    public void setDumpWriter(Writer writer) {
        this.dumpWriter = writer;
    }

    public Writer getDumpWriter() {
        return this.dumpWriter;
    }
}

