/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.explorer;

import java.util.Collection;
import org.freeplane.features.explorer.AccessedNodes;
import org.freeplane.features.explorer.ExploringStep;
import org.freeplane.features.explorer.NodeMatcher;
import org.freeplane.features.map.NodeModel;

class Command {
    private final ExploringStep operator;
    private final AccessedNodes accessedNodes;
    private final String searchedString;

    public Command(ExploringStep operator, String searchedString, AccessedNodes accessedNodes) {
        this.searchedString = searchedString;
        operator.assertValidString(searchedString);
        this.accessedNodes = accessedNodes;
        this.operator = operator;
    }

    public Collection<? extends NodeModel> getNodes(NodeModel start) {
        NodeMatcher nodeMatcher = this.createMatcher();
        return this.operator.getNodes(start, nodeMatcher, this.accessedNodes);
    }

    private NodeMatcher createMatcher() {
        return new NodeMatcher(this.searchedString);
    }

    public String toString() {
        return "Command [operator=" + (Object)((Object)this.operator) + ", searchedString=" + this.searchedString + "]";
    }
}

