# SPDX-License-Identifier: GPL-2.0-or-later
# MonoidalCategories: Monoidal and monoidal (co)closed categories
#
# Implementations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE CAP_project/CAP/gap/MethodRecordTools.gi

## AssociatorLeftToRight
InstallMethod( AddAssociatorLeftToRight,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "AssociatorLeftToRight", category, func, -1 );
    
end );

InstallMethod( AddAssociatorLeftToRight,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "AssociatorLeftToRight", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## AssociatorLeftToRightWithGivenTensorProducts
InstallMethod( AddAssociatorLeftToRightWithGivenTensorProducts,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "AssociatorLeftToRightWithGivenTensorProducts", category, func, -1 );
    
end );

InstallMethod( AddAssociatorLeftToRightWithGivenTensorProducts,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "AssociatorLeftToRightWithGivenTensorProducts", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( AssociatorLeftToRightWithGivenTensorProducts,
                    "AssociatorLeftToRightWithGivenTensorProducts by calling AssociatorLeftToRight with the WithGiven argument(s) dropped",
                    [
                        [ AssociatorLeftToRight, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return AssociatorLeftToRight( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( AssociatorLeftToRight,
                    "AssociatorLeftToRight by calling AssociatorLeftToRightWithGivenTensorProducts with the WithGiven object(s)",
                    [
                        [ AssociatorLeftToRightWithGivenTensorProducts, 1 ],
                        [ TensorProductOnObjects, 4 ],
                    ],
  function( cat, a, b, c )
    
    return AssociatorLeftToRightWithGivenTensorProducts( cat, TensorProductOnObjects( cat, TensorProductOnObjects( cat, a, b ), c ), a, b, c, TensorProductOnObjects( cat, a, TensorProductOnObjects( cat, b, c ) ) );
    
end : is_with_given_derivation := true );

## AssociatorRightToLeft
InstallMethod( AddAssociatorRightToLeft,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "AssociatorRightToLeft", category, func, -1 );
    
end );

InstallMethod( AddAssociatorRightToLeft,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "AssociatorRightToLeft", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## AssociatorRightToLeftWithGivenTensorProducts
InstallMethod( AddAssociatorRightToLeftWithGivenTensorProducts,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "AssociatorRightToLeftWithGivenTensorProducts", category, func, -1 );
    
end );

InstallMethod( AddAssociatorRightToLeftWithGivenTensorProducts,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "AssociatorRightToLeftWithGivenTensorProducts", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( AssociatorRightToLeftWithGivenTensorProducts,
                    "AssociatorRightToLeftWithGivenTensorProducts by calling AssociatorRightToLeft with the WithGiven argument(s) dropped",
                    [
                        [ AssociatorRightToLeft, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return AssociatorRightToLeft( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( AssociatorRightToLeft,
                    "AssociatorRightToLeft by calling AssociatorRightToLeftWithGivenTensorProducts with the WithGiven object(s)",
                    [
                        [ AssociatorRightToLeftWithGivenTensorProducts, 1 ],
                        [ TensorProductOnObjects, 4 ],
                    ],
  function( cat, a, b, c )
    
    return AssociatorRightToLeftWithGivenTensorProducts( cat, TensorProductOnObjects( cat, a, TensorProductOnObjects( cat, b, c ) ), a, b, c, TensorProductOnObjects( cat, TensorProductOnObjects( cat, a, b ), c ) );
    
end : is_with_given_derivation := true );

## LeftUnitor
InstallMethod( AddLeftUnitor,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftUnitor", category, func, -1 );
    
end );

InstallMethod( AddLeftUnitor,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftUnitor", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftUnitorInverse
InstallMethod( AddLeftUnitorInverse,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftUnitorInverse", category, func, -1 );
    
end );

InstallMethod( AddLeftUnitorInverse,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftUnitorInverse", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftUnitorInverseWithGivenTensorProduct
InstallMethod( AddLeftUnitorInverseWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftUnitorInverseWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddLeftUnitorInverseWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftUnitorInverseWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftUnitorInverseWithGivenTensorProduct,
                    "LeftUnitorInverseWithGivenTensorProduct by calling LeftUnitorInverse with the WithGiven argument(s) dropped",
                    [
                        [ LeftUnitorInverse, 1 ],
                    ],
  function( cat, a, r )
    
    return LeftUnitorInverse( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftUnitorInverse,
                    "LeftUnitorInverse by calling LeftUnitorInverseWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ LeftUnitorInverseWithGivenTensorProduct, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return LeftUnitorInverseWithGivenTensorProduct( cat, a, TensorProductOnObjects( cat, TensorUnit( cat ), a ) );
    
end : is_with_given_derivation := true );

## LeftUnitorWithGivenTensorProduct
InstallMethod( AddLeftUnitorWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftUnitorWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddLeftUnitorWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftUnitorWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftUnitorWithGivenTensorProduct,
                    "LeftUnitorWithGivenTensorProduct by calling LeftUnitor with the WithGiven argument(s) dropped",
                    [
                        [ LeftUnitor, 1 ],
                    ],
  function( cat, a, s )
    
    return LeftUnitor( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftUnitor,
                    "LeftUnitor by calling LeftUnitorWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ LeftUnitorWithGivenTensorProduct, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return LeftUnitorWithGivenTensorProduct( cat, a, TensorProductOnObjects( cat, TensorUnit( cat ), a ) );
    
end : is_with_given_derivation := true );

## RightUnitor
InstallMethod( AddRightUnitor,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RightUnitor", category, func, -1 );
    
end );

InstallMethod( AddRightUnitor,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RightUnitor", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## RightUnitorInverse
InstallMethod( AddRightUnitorInverse,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RightUnitorInverse", category, func, -1 );
    
end );

InstallMethod( AddRightUnitorInverse,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RightUnitorInverse", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## RightUnitorInverseWithGivenTensorProduct
InstallMethod( AddRightUnitorInverseWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RightUnitorInverseWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddRightUnitorInverseWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RightUnitorInverseWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( RightUnitorInverseWithGivenTensorProduct,
                    "RightUnitorInverseWithGivenTensorProduct by calling RightUnitorInverse with the WithGiven argument(s) dropped",
                    [
                        [ RightUnitorInverse, 1 ],
                    ],
  function( cat, a, r )
    
    return RightUnitorInverse( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( RightUnitorInverse,
                    "RightUnitorInverse by calling RightUnitorInverseWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ RightUnitorInverseWithGivenTensorProduct, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return RightUnitorInverseWithGivenTensorProduct( cat, a, TensorProductOnObjects( cat, a, TensorUnit( cat ) ) );
    
end : is_with_given_derivation := true );

## RightUnitorWithGivenTensorProduct
InstallMethod( AddRightUnitorWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RightUnitorWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddRightUnitorWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RightUnitorWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( RightUnitorWithGivenTensorProduct,
                    "RightUnitorWithGivenTensorProduct by calling RightUnitor with the WithGiven argument(s) dropped",
                    [
                        [ RightUnitor, 1 ],
                    ],
  function( cat, a, s )
    
    return RightUnitor( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( RightUnitor,
                    "RightUnitor by calling RightUnitorWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ RightUnitorWithGivenTensorProduct, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return RightUnitorWithGivenTensorProduct( cat, a, TensorProductOnObjects( cat, a, TensorUnit( cat ) ) );
    
end : is_with_given_derivation := true );

## TensorProductOnMorphisms
InstallMethod( AddTensorProductOnMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductOnMorphisms", category, func, -1 );
    
end );

InstallMethod( AddTensorProductOnMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductOnMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductOnMorphismsWithGivenTensorProducts
InstallMethod( AddTensorProductOnMorphismsWithGivenTensorProducts,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductOnMorphismsWithGivenTensorProducts", category, func, -1 );
    
end );

InstallMethod( AddTensorProductOnMorphismsWithGivenTensorProducts,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductOnMorphismsWithGivenTensorProducts", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductOnMorphismsWithGivenTensorProducts,
                    "TensorProductOnMorphismsWithGivenTensorProducts by calling TensorProductOnMorphisms with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductOnMorphisms, 1 ],
                    ],
  function( cat, s, alpha, beta, r )
    
    return TensorProductOnMorphisms( cat, alpha, beta );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductOnMorphisms,
                    "TensorProductOnMorphisms by calling TensorProductOnMorphismsWithGivenTensorProducts with the WithGiven object(s)",
                    [
                        [ TensorProductOnMorphismsWithGivenTensorProducts, 1 ],
                        [ TensorProductOnObjects, 2 ],
                    ],
  function( cat, alpha, beta )
    
    return TensorProductOnMorphismsWithGivenTensorProducts( cat, TensorProductOnObjects( cat, Source( alpha ), Source( beta ) ), alpha, beta, TensorProductOnObjects( cat, Range( alpha ), Range( beta ) ) );
    
end : is_with_given_derivation := true );
