/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMInvalidAccessException;
import io.sf.carte.doc.DOMNotSupportedException;
import io.sf.carte.doc.DOMPolicyException;
import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSNamespaceRule;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSStyleRule;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.MediaQuery;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.impl.CSSUtil;
import io.sf.carte.doc.style.css.impl.MediaListAccess;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.PositionalCondition;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractRuleList;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.CSSValueMediaQueryFactory;
import io.sf.carte.doc.style.css.om.CompatStyleDeclaration;
import io.sf.carte.doc.style.css.om.CounterStyleRule;
import io.sf.carte.doc.style.css.om.FontFaceRule;
import io.sf.carte.doc.style.css.om.FontFeatureValuesRule;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.om.ImportRule;
import io.sf.carte.doc.style.css.om.KeyframesRule;
import io.sf.carte.doc.style.css.om.MarginRule;
import io.sf.carte.doc.style.css.om.MarginRuleList;
import io.sf.carte.doc.style.css.om.MediaRule;
import io.sf.carte.doc.style.css.om.NamespaceRule;
import io.sf.carte.doc.style.css.om.PageRule;
import io.sf.carte.doc.style.css.om.PropertyRule;
import io.sf.carte.doc.style.css.om.SheetHandler;
import io.sf.carte.doc.style.css.om.StandAloneErrorHandler;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.om.SupportsRule;
import io.sf.carte.doc.style.css.om.UnknownRule;
import io.sf.carte.doc.style.css.om.WrappedCSSStyleDeclaration;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import io.sf.carte.util.Visitor;
import io.sf.carte.util.agent.AgentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.stylesheets.MediaList;

public abstract class BaseCSSStyleSheet
extends AbstractCSSStyleSheet {
    private static final long serialVersionUID = 1L;
    private AbstractCSSStyleSheet parent = null;
    private String href = null;
    private final AbstractCSSRule ownerRule;
    private final int sheetOrigin;
    final CSSRuleArrayList cssRules;
    private int currentInsertionIndex = 0;
    private MediaQueryList destinationMedia;
    private HashMap<String, String> namespaces = new HashMap();
    private boolean disabled = false;
    private SheetErrorHandler sheetErrorHandler = null;

    protected BaseCSSStyleSheet(String title, MediaQueryList media, AbstractCSSRule ownerRule, int origin) {
        super(title);
        this.ownerRule = ownerRule;
        this.destinationMedia = media == null ? CSSValueMediaQueryFactory.getAllMediaInstance() : media;
        this.sheetOrigin = origin;
        this.cssRules = new CSSRuleArrayList(64);
    }

    protected void copyAllTo(BaseCSSStyleSheet myCopy) {
        this.copyFieldsTo(myCopy);
        this.copyRulesTo(myCopy);
    }

    protected void copyFieldsTo(BaseCSSStyleSheet myCopy) {
        myCopy.currentInsertionIndex = this.currentInsertionIndex;
        myCopy.setDisabled(this.getDisabled());
        myCopy.namespaces = this.namespaces;
        if (this.parent != null) {
            myCopy.setParentStyleSheet(this.parent);
        }
    }

    protected void copyRulesTo(BaseCSSStyleSheet myCopy) {
        myCopy.cssRules.ensureCapacity(this.cssRules.getLength());
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            myCopy.cssRules.add(((AbstractCSSRule)it.next()).clone(myCopy));
        }
    }

    @Override
    public abstract BaseCSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public AbstractCSSRule getOwnerRule() {
        return this.ownerRule;
    }

    @Override
    public Node getOwnerNode() {
        return null;
    }

    @Override
    public MediaQueryList getMedia() {
        return this.destinationMedia;
    }

    @Override
    protected void setMedia(MediaQueryList media) throws DOMException {
        if (media.hasErrors()) {
            throw new DOMException(11, "Media query has errors");
        }
        this.destinationMedia = media;
    }

    @Override
    public int getOrigin() {
        return this.sheetOrigin;
    }

    @Override
    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    int getCurrentInsertionIndex() {
        return this.currentInsertionIndex;
    }

    void setCurrentInsertionIndex(int currentInsertionIndex) {
        this.currentInsertionIndex = currentInsertionIndex;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (index > this.getCssRules().getLength() || index < 0) {
            throw new DOMException(1, "Invalid index: " + index);
        }
        StringReader re = new StringReader(rule);
        Parser psr = this.getStyleSheetFactory().createSACParser();
        SheetHandler handler = this.createSheetHandler((short)0);
        psr.setDocumentHandler(handler);
        psr.setErrorHandler(handler);
        this.currentInsertionIndex = index - 1;
        try {
            psr.parseRule(re, handler);
        }
        catch (CSSNamespaceParseException e) {
            DOMException ex = new DOMException(14, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (CSSException e) {
            throw new DOMSyntaxException(e);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        if (this.currentInsertionIndex != index && handler.getOutOfRuleException() != null) {
            DOMException ex;
            if (handler.getOutOfRuleException().getClass() == CSSNamespaceParseException.class) {
                ex = new DOMException(14, handler.getOutOfRuleException().getMessage());
                ex.initCause(handler.getOutOfRuleException());
            } else {
                ex = new DOMSyntaxException(handler.getOutOfRuleException());
            }
            throw ex;
        }
        return this.currentInsertionIndex;
    }

    @Override
    public void addRule(AbstractCSSRule cssrule) throws DOMException {
        cssrule.addToSheetAsLocal(this);
        cssrule.setParentStyleSheet(this);
    }

    @Override
    void addNamespaceRule(CSSNamespaceRule nsrule) {
        if (this.namespaces.containsKey(nsrule.getNamespaceURI())) {
            throw new DOMException(14, "Rule for this namespace URI already exists: " + nsrule.getNamespaceURI());
        }
        this.registerNamespace(nsrule);
        this.addLocalRule(nsrule);
    }

    @Override
    public void registerNamespacePrefix(String prefix, String namespaceURI) {
        this.namespaces.put(namespaceURI, prefix);
    }

    @Override
    protected void registerNamespace(CSSNamespaceRule nsrule) {
        this.namespaces.put(nsrule.getNamespaceURI(), nsrule.getPrefix());
    }

    @Override
    protected void unregisterNamespace(String namespaceURI) {
        this.namespaces.remove(namespaceURI);
    }

    @Override
    protected void addLocalRule(CSSRule cssrule) {
        this.currentInsertionIndex = this.cssRules.insertRule(cssrule, ++this.currentInsertionIndex);
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        CSSRule rule;
        try {
            rule = (CSSRule)this.cssRules.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMException(1, e.getMessage());
        }
        if (rule.getType() == 10 && this.containsRuleWithNamespace(((CSSNamespaceRule)rule).getNamespaceURI())) {
            throw new DOMException(14, "There are style rules with ");
        }
        this.cssRules.remove(index);
    }

    private boolean containsRuleWithNamespace(String namespaceURI) {
        for (CSSRule rule : this.cssRules) {
            StyleRule stylerule;
            if (rule.getType() != 1 || !BaseCSSStyleSheet.selectorListHasNamespace((stylerule = (StyleRule)rule).getAbsoluteSelectorList(), namespaceURI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addStyleSheet(AbstractCSSStyleSheet sheet) {
        if (!sheet.getDisabled()) {
            MediaList mediaList = sheet.getMedia();
            if (mediaList.isAllMedia()) {
                this.mergeNamespaces((BaseCSSStyleSheet)sheet);
                CSSRuleArrayList otherRules = sheet.getCssRules();
                this.addRuleList(otherRules, 0);
            } else if (!mediaList.isNotAllMedia()) {
                CSSRuleArrayList otherRules = sheet.getCssRules();
                MediaRule mrule = this.createMediaRule((MediaQueryList)mediaList);
                mrule.addRuleList(otherRules, 0);
                this.addLocalRule(mrule);
            }
            this.getErrorHandler().mergeState(sheet.getErrorHandler());
        }
    }

    private void mergeNamespaces(BaseCSSStyleSheet sheet) {
        if (this.namespaces != null) {
            if (sheet.namespaces != null) {
                this.namespaces.putAll(sheet.namespaces);
            }
        } else if (sheet.namespaces != null) {
            this.namespaces = (HashMap)sheet.namespaces.clone();
        }
    }

    @Override
    int addRuleList(CSSRuleArrayList otherRules, int importCount) {
        int orl = otherRules.getLength();
        for (int i = 0; i < orl; ++i) {
            AbstractCSSRule oRule = (AbstractCSSRule)otherRules.item(i);
            importCount = oRule.addToSheet(this, importCount);
        }
        return importCount;
    }

    private static boolean selectorListHasNamespace(SelectorList selist, String namespaceURI) {
        for (int i = 0; i < selist.getLength(); ++i) {
            if (!BaseCSSStyleSheet.selectorHasNamespace(selist.item(i), namespaceURI)) continue;
            return true;
        }
        return false;
    }

    private static boolean selectorHasNamespace(Selector sel, String namespaceURI) {
        switch (sel.getSelectorType()) {
            case ELEMENT: 
            case UNIVERSAL: {
                return namespaceURI.equals(((ElementSelector)sel).getNamespaceURI());
            }
            case CONDITIONAL: {
                ConditionalSelector csel = (ConditionalSelector)sel;
                return BaseCSSStyleSheet.selectorHasNamespace(csel.getSimpleSelector(), namespaceURI) || BaseCSSStyleSheet.conditionHasNamespace(csel.getCondition(), namespaceURI);
            }
            case CHILD: 
            case DESCENDANT: 
            case DIRECT_ADJACENT: 
            case SUBSEQUENT_SIBLING: 
            case COLUMN_COMBINATOR: {
                CombinatorSelector dsel = (CombinatorSelector)sel;
                return BaseCSSStyleSheet.selectorHasNamespace(dsel.getSelector(), namespaceURI) || BaseCSSStyleSheet.selectorHasNamespace(dsel.getSecondSelector(), namespaceURI);
            }
        }
        return false;
    }

    private static boolean conditionHasNamespace(Condition condition, String namespaceURI) {
        switch (condition.getConditionType()) {
            case ATTRIBUTE: 
            case BEGIN_HYPHEN_ATTRIBUTE: 
            case ONE_OF_ATTRIBUTE: 
            case BEGINS_ATTRIBUTE: 
            case ENDS_ATTRIBUTE: 
            case SUBSTRING_ATTRIBUTE: {
                AttributeCondition acond = (AttributeCondition)condition;
                return namespaceURI.equals(acond.getNamespaceURI());
            }
            case AND: {
                CombinatorCondition ccond = (CombinatorCondition)condition;
                int len = ccond.getLength();
                for (int i = 0; i < len; ++i) {
                    if (!BaseCSSStyleSheet.conditionHasNamespace(ccond.getCondition(i), namespaceURI)) continue;
                    return true;
                }
            }
            case POSITIONAL: {
                SelectorList oflist = ((PositionalCondition)condition).getOfList();
                if (oflist == null) break;
                return BaseCSSStyleSheet.selectorListHasNamespace(oflist, namespaceURI);
            }
            case SELECTOR_ARGUMENT: {
                ArgumentCondition argcond = (ArgumentCondition)condition;
                SelectorList selist = argcond.getSelectors();
                if (selist == null) break;
                return BaseCSSStyleSheet.selectorListHasNamespace(selist, namespaceURI);
            }
        }
        return false;
    }

    void prioritySplit(AbstractCSSStyleSheet importantSheet, AbstractCSSStyleSheet normalSheet) {
        AbstractCSSStyleDeclaration userImportantStyle = normalSheet.createStyleDeclaration();
        AbstractCSSStyleDeclaration userNormalStyle = normalSheet.createStyleDeclaration();
        for (AbstractCSSRule r : this.cssRules) {
            if (r.getType() == 1) {
                userImportantStyle.clear();
                userNormalStyle.clear();
                StyleRule rule = (StyleRule)r;
                rule.prioritySplit(importantSheet, normalSheet, importantSheet, normalSheet, userImportantStyle, userNormalStyle);
                continue;
            }
            r.prioritySplit(importantSheet, normalSheet, importantSheet, normalSheet);
        }
    }

    @Override
    public CounterStyleRule createCounterStyleRule(String name) throws DOMException {
        CounterStyleRule rule = new CounterStyleRule(this, this.getOrigin());
        rule.setName(name);
        return rule;
    }

    @Override
    public FontFaceRule createFontFaceRule() {
        return new FontFaceRule(this, this.getOrigin());
    }

    @Override
    public FontFeatureValuesRule createFontFeatureValuesRule(String[] fontFamily) {
        FontFeatureValuesRule rule = new FontFeatureValuesRule(this, this.getOrigin());
        rule.setFontFamily(fontFamily);
        return rule;
    }

    @Override
    public ImportRule createImportRule(MediaQueryList mediaList, String href) {
        return this.createImportRule(null, null, mediaList, null, href);
    }

    @Override
    public ImportRule createImportRule(String layerName, BooleanCondition supportsCondition, MediaQueryList mediaList, String defaultNamespaceURI, String href) {
        if (href == null) {
            throw new NullPointerException("Null @import URI");
        }
        return new ImportRule(this, layerName, supportsCondition, ((MediaListAccess)((Object)mediaList)).unmodifiable(), href, this.getOrigin());
    }

    @Override
    public KeyframesRule createKeyframesRule(String keyframesName) {
        KeyframesRule rule = new KeyframesRule((AbstractCSSStyleSheet)this, this.getOrigin());
        rule.setName(keyframesName);
        return rule;
    }

    @Override
    public MarginRule createMarginRule(String name) {
        return new MarginRule((AbstractCSSStyleSheet)this, this.getOrigin(), name);
    }

    @Override
    public MediaRule createMediaRule(MediaQueryList mediaList) {
        return new MediaRule((AbstractCSSStyleSheet)this, mediaList, this.getOrigin());
    }

    @Override
    public NamespaceRule createNamespaceRule(String prefix, String namespaceUri) {
        if (prefix == null || namespaceUri == null) {
            throw new DOMInvalidAccessException("Null parameter");
        }
        return new NamespaceRule(this, this.getOrigin(), prefix, namespaceUri);
    }

    @Override
    public PageRule createPageRule() {
        return new PageRule(this, this.getOrigin());
    }

    @Override
    public PropertyRule createPropertyRule(String name) {
        PropertyRule rule = new PropertyRule(this, this.getOrigin());
        rule.setName(name);
        return rule;
    }

    @Override
    public StyleRule createStyleRule() {
        return new StyleRule((AbstractCSSStyleSheet)this, this.getOrigin());
    }

    @Override
    public SupportsRule createSupportsRule(BooleanCondition condition) {
        return new SupportsRule((AbstractCSSStyleSheet)this, condition, this.getOrigin());
    }

    @Override
    public SupportsRule createSupportsRule(String conditionText) throws DOMException {
        SupportsRule cond = new SupportsRule((AbstractCSSStyleSheet)this, this.getOrigin());
        cond.setConditionText(conditionText);
        return cond;
    }

    @Override
    @Deprecated
    public SupportsRule createSupportsRule() {
        return new SupportsRule((AbstractCSSStyleSheet)this, this.getOrigin());
    }

    @Override
    public UnknownRule createUnknownRule() {
        return new UnknownRule(this, this.getOrigin());
    }

    @Override
    protected BaseCSSStyleDeclaration createStyleDeclaration(CSSDeclarationRule rule) {
        if (rule.getType() == 5) {
            return new WrappedCSSStyleDeclaration(rule);
        }
        BaseCSSStyleSheetFactory factory = this.getStyleSheetFactory();
        if (!factory.hasCompatValueFlags()) {
            return new BaseCSSStyleDeclaration(rule);
        }
        return new CompatStyleDeclaration(rule);
    }

    @Override
    public BaseCSSStyleDeclaration createStyleDeclaration() {
        return new BaseCSSStyleDeclaration();
    }

    @Override
    public boolean hasRuleErrorsOrWarnings() {
        for (AbstractCSSRule rule : this.cssRules) {
            if (!rule.hasErrorsOrWarnings()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SheetErrorHandler getErrorHandler() {
        if (this.sheetErrorHandler == null) {
            this.sheetErrorHandler = this.getStyleSheetFactory().createSheetErrorHandler(this);
        }
        return this.sheetErrorHandler;
    }

    @Override
    public void setErrorHandler(SheetErrorHandler sheetErrorHandler) {
        this.sheetErrorHandler = sheetErrorHandler;
    }

    @Override
    protected ErrorHandler getDocumentErrorHandler() {
        Node owner = null;
        for (AbstractCSSStyleSheet parent = this; parent != null && (owner = parent.getOwnerNode()) == null; parent = ((AbstractCSSStyleSheet)parent).getParentStyleSheet()) {
        }
        ErrorHandler eh = owner != null ? ((CSSDocument)owner.getOwnerDocument()).getErrorHandler() : StandAloneErrorHandler.getInstance(this);
        return eh;
    }

    @Override
    public String getType() {
        return "text/css";
    }

    @Override
    public String getNamespacePrefix(String uri) {
        return this.namespaces.get(uri);
    }

    @Override
    public String getNamespaceURI(String nsPrefix) {
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            String prefix = entry.getValue();
            if (!nsPrefix.equals(prefix)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public boolean hasDefaultNamespace() {
        return this.namespaces.containsValue("");
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public AbstractCSSStyleSheet getParentStyleSheet() {
        return this.parent;
    }

    @Override
    protected void setParentStyleSheet(AbstractCSSStyleSheet parent) {
        this.parent = parent;
        this.sheetErrorHandler = parent.getErrorHandler();
    }

    @Override
    public String getHref() {
        if (this.href == null && this.ownerRule != null) {
            return this.ownerRule.getParentStyleSheet().getHref();
        }
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public boolean loadStyleSheet(URL url, String referrerPolicy) throws DOMException, IOException {
        boolean result = false;
        URLConnection ucon = this.openConnection(url, referrerPolicy);
        ucon.connect();
        try (InputStream is = ucon.getInputStream();){
            String contentEncoding = ucon.getContentEncoding();
            String conType = ucon.getContentType();
            if (CSSUtil.isInvalidCSSContentType(url, conType) && !this.isRedirect(ucon)) {
                String msg;
                if (conType != null) {
                    conType = conType.replaceAll("\\p{Cc}", "*CTRL*");
                    msg = "Style sheet at " + url.toExternalForm() + " served with invalid type (" + conType + ").";
                } else {
                    msg = "Style sheet at " + url.toExternalForm() + " has no valid content type.";
                }
                this.getDocumentErrorHandler().policyError(this.getOwnerNode(), msg);
                throw new DOMPolicyException(msg);
            }
            Reader re = AgentUtil.inputStreamToReader((InputStream)is, (String)conType, (String)contentEncoding, (Charset)StandardCharsets.UTF_8);
            try {
                this.setHref(url.toExternalForm());
                result = this.parseStyleSheet(re);
            }
            catch (DOMException e) {
                this.getDocumentErrorHandler().linkedSheetError(e, this);
                throw e;
            }
        }
        if (ucon instanceof HttpURLConnection) {
            ((HttpURLConnection)ucon).disconnect();
        }
        return result;
    }

    private boolean isRedirect(URLConnection ucon) {
        if (ucon instanceof HttpURLConnection) {
            try {
                int code = ((HttpURLConnection)ucon).getResponseCode();
                return code > 300 && code < 400 && code != 304;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public CSSRuleArrayList getRulesForProperty(String longhandPropertyName) {
        CSSRuleArrayList list = new CSSRuleArrayList();
        BaseCSSStyleSheet.scanRulesForPropertyDeclaration(this.cssRules, longhandPropertyName, list);
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private static void scanRulesForPropertyDeclaration(CSSRuleArrayList rules, String propertyName, CSSRuleArrayList subset) {
        for (CSSRule rule : rules) {
            switch (rule.getType()) {
                case 1: {
                    StyleRule stylerule = (StyleRule)rule;
                    if (((BaseCSSStyleDeclaration)stylerule.getStyle()).isPropertySet(propertyName)) {
                        subset.add(stylerule);
                    }
                    if (stylerule.getCssRules() == null) break;
                }
                case 4: 
                case 12: {
                    GroupingRule grouping = (GroupingRule)rule;
                    BaseCSSStyleSheet.scanRulesForPropertyDeclaration(grouping.getCssRules(), propertyName, subset);
                    break;
                }
                case 6: {
                    BaseCSSDeclarationRule declrule = (BaseCSSDeclarationRule)rule;
                    if (!((BaseCSSStyleDeclaration)declrule.getStyle()).isPropertySet(propertyName)) break;
                    subset.add(declrule);
                }
            }
        }
    }

    @Override
    public Selector[] getSelectorsForProperty(String longhandPropertyName) {
        LinkedList<Selector> selectors = new LinkedList<Selector>();
        BaseCSSStyleSheet.scanRulesForPropertyDeclaration(this.cssRules, longhandPropertyName, selectors);
        if (selectors.isEmpty()) {
            return null;
        }
        return selectors.toArray(new Selector[0]);
    }

    private static void scanRulesForPropertyDeclaration(CSSRuleArrayList rules, String propertyName, LinkedList<Selector> selectors) {
        for (CSSRule rule : rules) {
            switch (rule.getType()) {
                case 1: {
                    StyleRule stylerule = (StyleRule)rule;
                    if (((BaseCSSStyleDeclaration)stylerule.getStyle()).isPropertySet(propertyName)) {
                        SelectorList list = stylerule.getAbsoluteSelectorList();
                        for (int i = 0; i < list.getLength(); ++i) {
                            selectors.add(list.item(i));
                        }
                    }
                    if (stylerule.getCssRules() == null) break;
                }
                case 4: 
                case 12: {
                    GroupingRule grouping = (GroupingRule)rule;
                    BaseCSSStyleSheet.scanRulesForPropertyDeclaration(grouping.getCssRules(), propertyName, selectors);
                }
            }
        }
    }

    public Selector[] getSelectorsForPropertyValue(String propertyName, String declaredValue) {
        LinkedList<Selector> selectors = new LinkedList<Selector>();
        BaseCSSStyleSheet.scanRulesForValue(this.cssRules, propertyName, declaredValue, selectors);
        if (selectors.isEmpty()) {
            return null;
        }
        return selectors.toArray(new Selector[0]);
    }

    private static void scanRulesForValue(CSSRuleArrayList rules, String propertyName, String value, LinkedList<Selector> selectors) {
        for (CSSRule rule : rules) {
            switch (rule.getType()) {
                case 1: {
                    StyleRule stylerule = (StyleRule)rule;
                    if (value.equalsIgnoreCase(stylerule.getStyle().getPropertyValue(propertyName))) {
                        SelectorList list = stylerule.getAbsoluteSelectorList();
                        for (int i = 0; i < list.getLength(); ++i) {
                            selectors.add(list.item(i));
                        }
                    }
                    if (stylerule.getCssRules() == null) break;
                }
                case 4: 
                case 12: {
                    GroupingRule grouping = (GroupingRule)rule;
                    BaseCSSStyleSheet.scanRulesForValue(grouping.getCssRules(), propertyName, value, selectors);
                }
            }
        }
    }

    @Override
    public StyleRule getFirstStyleRule(SelectorList selectorList) {
        return BaseCSSStyleSheet.scanRulesForSelector(this.cssRules, selectorList);
    }

    private static StyleRule scanRulesForSelector(CSSRuleArrayList rules, SelectorList selectorList) {
        for (CSSRule rule : rules) {
            switch (rule.getType()) {
                case 1: {
                    StyleRule stylerule = (StyleRule)rule;
                    SelectorList list = stylerule.getAbsoluteSelectorList();
                    if (list.equals(selectorList)) {
                        return stylerule;
                    }
                    if (stylerule.getCssRules() == null) break;
                }
                case 4: 
                case 12: {
                    GroupingRule grouping = (GroupingRule)rule;
                    StyleRule stylerule = BaseCSSStyleSheet.scanRulesForSelector(grouping.getCssRules(), selectorList);
                    if (stylerule == null) break;
                    return stylerule;
                }
            }
        }
        return null;
    }

    @Override
    public CSSRuleArrayList getStyleRules(Selector selector) {
        CSSRuleArrayList list = new CSSRuleArrayList();
        BaseCSSStyleSheet.scanRulesForSelector(this.cssRules, selector, list);
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private static void scanRulesForSelector(CSSRuleArrayList rules, Selector selector, CSSRuleArrayList styleRules) {
        for (CSSRule rule : rules) {
            switch (rule.getType()) {
                case 1: {
                    StyleRule stylerule = (StyleRule)rule;
                    SelectorList list = stylerule.getAbsoluteSelectorList();
                    if (list.contains(selector)) {
                        styleRules.add(stylerule);
                    }
                    if (stylerule.getCssRules() == null) break;
                }
                case 4: 
                case 12: {
                    GroupingRule grouping = (GroupingRule)rule;
                    BaseCSSStyleSheet.scanRulesForSelector(grouping.getCssRules(), selector, styleRules);
                }
            }
        }
    }

    @Override
    public void acceptStyleRuleVisitor(Visitor<CSSStyleRule> visitor) {
        this.acceptStyleRuleVisitor(this.cssRules, visitor);
    }

    private void acceptStyleRuleVisitor(CSSRuleArrayList rules, Visitor<CSSStyleRule> visitor) {
        for (CSSRule rule : rules) {
            switch (rule.getType()) {
                case 1: {
                    StyleRule stylerule = (StyleRule)rule;
                    visitor.visit((Object)stylerule);
                    if (stylerule.getCssRules() == null) break;
                }
                case 4: 
                case 12: {
                    GroupingRule grouping = (GroupingRule)rule;
                    this.acceptStyleRuleVisitor(grouping.getCssRules(), visitor);
                }
            }
        }
    }

    @Override
    public void acceptDeclarationRuleVisitor(Visitor<CSSDeclarationRule> visitor) {
        this.acceptDeclarationRuleVisitor(this.cssRules, visitor);
    }

    private void acceptDeclarationRuleVisitor(AbstractRuleList<? extends CSSRule> rules, Visitor<CSSDeclarationRule> visitor) {
        for (CSSRule cSSRule : rules) {
            switch (cSSRule.getType()) {
                case 1: {
                    CSSDeclarationRule declRule = (CSSDeclarationRule)cSSRule;
                    visitor.visit((Object)declRule);
                    GroupingRule grouping = (GroupingRule)cSSRule;
                    if (grouping.cssRules == null) break;
                    this.acceptDeclarationRuleVisitor(grouping.cssRules, visitor);
                    break;
                }
                case 4: 
                case 12: {
                    GroupingRule grouping = (GroupingRule)cSSRule;
                    this.acceptDeclarationRuleVisitor(grouping.getCssRules(), visitor);
                    break;
                }
                case 5: 
                case 8: 
                case 9: 
                case 11: 
                case 18: 
                case 19: {
                    CSSDeclarationRule declRule = (CSSDeclarationRule)cSSRule;
                    visitor.visit((Object)declRule);
                    break;
                }
                case 6: {
                    PageRule pageRule = (PageRule)cSSRule;
                    MarginRuleList marginBoxes = pageRule.getMarginRules();
                    if (marginBoxes != null) {
                        this.acceptDeclarationRuleVisitor(marginBoxes, visitor);
                    }
                    visitor.visit((Object)pageRule);
                    break;
                }
                case 7: {
                    KeyframesRule kfsRule = (KeyframesRule)cSSRule;
                    this.acceptDeclarationRuleVisitor(kfsRule.getCssRules(), visitor);
                }
            }
        }
    }

    @Override
    public void acceptDescriptorRuleVisitor(Visitor<CSSDeclarationRule> visitor) {
        this.acceptDescriptorRuleVisitor(this.cssRules, visitor);
    }

    private void acceptDescriptorRuleVisitor(AbstractRuleList<? extends CSSRule> rules, Visitor<CSSDeclarationRule> visitor) {
        for (CSSRule cSSRule : rules) {
            switch (cSSRule.getType()) {
                case 5: 
                case 8: 
                case 9: 
                case 11: 
                case 18: 
                case 19: {
                    CSSDeclarationRule declRule = (CSSDeclarationRule)cSSRule;
                    visitor.visit((Object)declRule);
                    break;
                }
                case 4: 
                case 12: {
                    GroupingRule grouping = (GroupingRule)cSSRule;
                    this.acceptDescriptorRuleVisitor(grouping.getCssRules(), visitor);
                    break;
                }
                case 6: {
                    PageRule pageRule = (PageRule)cSSRule;
                    MarginRuleList marginBoxes = pageRule.getMarginRules();
                    if (marginBoxes != null) {
                        this.acceptDescriptorRuleVisitor(marginBoxes, visitor);
                    }
                    visitor.visit((Object)pageRule);
                    break;
                }
                case 7: {
                    KeyframesRule kfsRule = (KeyframesRule)cSSRule;
                    this.acceptDescriptorRuleVisitor(kfsRule.getCssRules(), visitor);
                }
            }
        }
    }

    protected String getTargetMedium() {
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.cssRules, this.destinationMedia, this.disabled, this.href, this.namespaces, this.sheetOrigin);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BaseCSSStyleSheet)) {
            return false;
        }
        BaseCSSStyleSheet other = (BaseCSSStyleSheet)obj;
        return Objects.equals(this.cssRules, other.cssRules) && Objects.equals(this.destinationMedia, other.destinationMedia) && this.disabled == other.disabled && Objects.equals(this.href, other.href) && Objects.equals(this.namespaces, other.namespaces) && this.sheetOrigin == other.sheetOrigin;
    }

    @Override
    public String toMinifiedString() {
        return this.getCssRules().toMinifiedString();
    }

    public String toString() {
        StyleFormattingContext context = this.getStyleSheetFactory().getStyleFormattingFactory().createStyleFormattingContext();
        BufferSimpleWriter sw = new BufferSimpleWriter(this.getCssRules().getLength() * 20 + 32);
        try {
            this.getCssRules().writeCssText((SimpleWriter)sw, context);
            context.endRuleList((SimpleWriter)sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public String toStyleString() {
        StyleFormattingContext context = this.getStyleSheetFactory().getStyleFormattingFactory().createStyleFormattingContext();
        BufferSimpleWriter sw = new BufferSimpleWriter(this.getCssRules().getLength() * 20 + 92);
        try {
            sw.write((CharSequence)"<style type=\"text/css\"");
            if (!this.destinationMedia.isAllMedia()) {
                sw.write((CharSequence)" media=\"");
                sw.write((CharSequence)this.destinationMedia.getMediaText());
                sw.write('\"');
            }
            if (this.getTitle() != null) {
                sw.write((CharSequence)" title=\"");
                sw.write((CharSequence)this.getTitle());
                sw.write('\"');
            }
            sw.write('>');
            sw.newLine();
            this.getCssRules().writeCssText((SimpleWriter)sw, context);
            context.endRuleList((SimpleWriter)sw);
            sw.newLine();
            sw.write((CharSequence)"</style>");
            sw.newLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    SheetHandler createSheetHandler(short commentMode) {
        return this.createSheetHandler(this.getOrigin(), commentMode);
    }

    SheetHandler createSheetHandler(int origin, short commentMode) {
        return new SheetHandler(this, origin, commentMode);
    }

    @Override
    public boolean parseStyleSheet(Reader reader, short commentMode) throws DOMException, IOException {
        if (this.sheetErrorHandler != null) {
            this.sheetErrorHandler.reset();
        }
        int origin = this.getOrigin();
        for (AbstractCSSRule rule : this.getCssRules()) {
            int ruleo = rule.getOrigin();
            if (ruleo >= origin) continue;
            origin = ruleo;
        }
        Parser parser = this.getStyleSheetFactory().createSACParser();
        SheetHandler handler = this.createSheetHandler(origin, commentMode);
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(handler);
        this.parseStyleSheet(reader, parser);
        return !this.getErrorHandler().hasSacErrors();
    }

    private void parseStyleSheet(Reader reader, Parser parser) throws DOMException, IOException {
        try {
            parser.parseStyleSheet(reader);
        }
        catch (CSSNamespaceParseException e) {
            DOMException ex = new DOMException(14, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (CSSBudgetException e) {
            throw new DOMNotSupportedException(e.getMessage(), e);
        }
        catch (CSSParseException e) {
            DOMSyntaxException ex = new DOMSyntaxException("Parse error at [" + e.getLineNumber() + ',' + e.getColumnNumber() + "]: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (CSSException e) {
            throw new DOMInvalidAccessException(e.getMessage(), e);
        }
        catch (DOMException e) {
            throw e;
        }
        catch (RuntimeException e) {
            String message = e.getMessage();
            String href = this.getHref();
            if (href != null) {
                message = "Error in stylesheet at " + href + ": " + message;
            }
            DOMException ex = new DOMException(11, message);
            ex.initCause(e);
            throw ex;
        }
    }

    boolean match(MediaQueryList media, MediaQueryList mql) {
        if (media.isAllMedia()) {
            return true;
        }
        if (mql == null) {
            return !media.isNotAllMedia();
        }
        if (mql.isAllMedia() || this.appliesToAllMedia(mql)) {
            return true;
        }
        return media.matches(mql);
    }

    private boolean appliesToAllMedia(MediaQueryList mql) {
        MediaQuery mq;
        int len = mql.getLength();
        for (int i = 0; i < len && (mq = mql.getMediaQuery(i)) != null; ++i) {
            String media;
            if (mq.isNotAllMedia() || mq.isNegated() || (media = mq.getMediaType()) != null && !"all".equalsIgnoreCase(media)) continue;
            return true;
        }
        return false;
    }
}

