/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Locator;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.om.LexicalPropertyListener;
import io.sf.carte.doc.style.css.parser.EmptyCSSHandler;
import org.w3c.dom.DOMException;

class PropertyCSSHandler
extends EmptyCSSHandler {
    private LexicalPropertyListener listener = null;
    private ParserControl parserctl = null;

    PropertyCSSHandler() {
    }

    public void setLexicalPropertyListener(LexicalPropertyListener listener) {
        this.listener = listener;
    }

    @Override
    public void parseStart(ParserControl parserctl) {
        this.parserctl = parserctl;
    }

    ParserControl getParserControl() {
        return this.parserctl;
    }

    @Override
    public void property(String name, LexicalUnit value, boolean important) {
        try {
            this.listener.setProperty(name, value, important);
        }
        catch (DOMException e) {
            Locator locator = this.parserctl.createLocator();
            CSSParseException pe = new CSSParseException("Invalid value for property " + name, locator, e);
            this.error(pe);
            throw e;
        }
    }

    @Override
    public void lexicalProperty(String name, LexicalUnit value, boolean important) {
        try {
            this.listener.setLexicalProperty(name, value, important);
        }
        catch (DOMException e) {
            Locator locator = this.parserctl.createLocator();
            CSSParseException pe = new CSSParseException("Invalid value for property " + name, locator, e);
            this.error(pe);
            throw e;
        }
    }

    @Override
    public void error(CSSParseException exception) throws CSSParseException {
        throw exception;
    }
}

