/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jungrapht.visualization.layout.algorithms.AbstractIterativeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.IterativeContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.util.RandomLocationTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KKLayoutAlgorithm<V>
extends AbstractIterativeLayoutAlgorithm<V>
implements IterativeContext {
    private static final Logger log = LoggerFactory.getLogger(KKLayoutAlgorithm.class);
    private double EPSILON = 0.1;
    private int currentIteration;
    private int maxIterations;
    private String status = "KKLayout";
    private double L;
    private double K = 1.0;
    private double[][] dm;
    private boolean adjustForGravity = true;
    private boolean exchangevertices = true;
    private V[] vertices;
    private Point[] xydata;
    protected Map<Pair<V>, Integer> distance;
    protected double diameter;
    private double length_factor = 0.9;
    private double disconnected_multiplier = 0.5;

    public static <V> Builder<V, ?, ?> builder() {
        return new Builder();
    }

    public KKLayoutAlgorithm() {
        this(KKLayoutAlgorithm.builder());
    }

    protected KKLayoutAlgorithm(Builder<V, ?, ?> builder) {
        super(builder);
        this.maxIterations = builder.maxIterations;
        this.adjustForGravity = builder.adjustForGravity;
        this.exchangevertices = builder.exchangeVertices;
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        super.visit(layoutModel);
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            return;
        }
        if (graph != null) {
            this.distance = this.getDistances(graph);
        }
        this.initialize();
    }

    private Map<Pair<V>, Integer> getDistances(Graph<V, ?> graph) {
        DijkstraShortestPath dijkstra = new DijkstraShortestPath(graph);
        HashMap<Pair<Integer>, Integer> distanceMap = new HashMap<Pair<Integer>, Integer>();
        for (Object vertex : graph.vertexSet()) {
            ShortestPathAlgorithm.SingleSourcePaths distances = dijkstra.getPaths(vertex);
            for (Object n : graph.vertexSet()) {
                GraphPath graphPath = distances.getPath(n);
                if (graphPath == null || graphPath.getWeight() == 0.0) continue;
                distanceMap.put(Pair.of(vertex, n), (int)graphPath.getWeight());
            }
        }
        return distanceMap;
    }

    public void setLengthFactor(double length_factor) {
        this.length_factor = length_factor;
    }

    public void setDisconnectedDistanceMultiplier(double disconnected_multiplier) {
        this.disconnected_multiplier = disconnected_multiplier;
    }

    public String getStatus() {
        return this.status + this.layoutModel.getWidth() + " " + this.layoutModel.getHeight();
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public boolean done() {
        boolean done;
        if (this.cancelled) {
            return true;
        }
        boolean bl = done = this.currentIteration > this.maxIterations;
        if (done) {
            this.runAfter();
        }
        return done;
    }

    public void initialize() {
        this.currentIteration = 0;
        if (this.layoutModel != null) {
            Graph graph = this.layoutModel.getGraph();
            this.layoutModel.setInitializer(new RandomLocationTransformer(this.layoutModel.getWidth(), (double)this.layoutModel.getHeight(), graph.vertexSet().size()));
            double height = this.layoutModel.getHeight();
            double width = this.layoutModel.getWidth();
            int n = graph.vertexSet().size();
            this.dm = new double[n][n];
            this.vertices = graph.vertexSet().toArray();
            this.xydata = new Point[n];
            while (true) {
                try {
                    int index = 0;
                    for (Object vertex : graph.vertexSet()) {
                        Point xyd = (Point)this.layoutModel.apply(vertex);
                        this.vertices[index] = vertex;
                        this.xydata[index] = xyd;
                        ++index;
                    }
                }
                catch (ConcurrentModificationException index) {
                    continue;
                }
                break;
            }
            this.diameter = KKLayoutAlgorithm.diameter(graph, this.distance, true);
            log.trace("using diameter {}", (Object)this.diameter);
            double L0 = Math.min(height, width);
            this.L = L0 / this.diameter * this.length_factor;
            for (int i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    Number d_ij = this.distance.get(Pair.of(this.vertices[i], this.vertices[j]));
                    log.trace("distance from " + i + " to " + j + " is " + d_ij);
                    Number d_ji = this.distance.get(Pair.of(this.vertices[j], this.vertices[i]));
                    log.trace("distance from " + j + " to " + i + " is " + d_ji);
                    double dist = this.diameter * this.disconnected_multiplier;
                    log.trace("dist:" + dist);
                    if (d_ij != null && d_ij.intValue() < Integer.MAX_VALUE) {
                        dist = Math.min(d_ij.doubleValue(), dist);
                    }
                    if (d_ji != null && d_ji.intValue() < Integer.MAX_VALUE) {
                        dist = Math.min(d_ji.doubleValue(), dist);
                    }
                    double d = dist;
                    this.dm[j][i] = d;
                    this.dm[i][j] = d;
                }
            }
        }
    }

    @Override
    public void step() {
        int i;
        if (this.cancelled) {
            return;
        }
        Graph graph = this.layoutModel.getGraph();
        ++this.currentIteration;
        int n = graph.vertexSet().size();
        if (n == 0) {
            return;
        }
        double maxDeltaM = 0.0;
        int pm = -1;
        for (i = 0; i < n; ++i) {
            double deltam;
            if (this.layoutModel.isLocked(this.vertices[i]) || !(maxDeltaM < (deltam = this.calcDeltaM(i)))) continue;
            maxDeltaM = deltam;
            pm = i;
        }
        if (pm == -1) {
            return;
        }
        for (i = 0; i < 100; ++i) {
            double[] dxy = this.calcDeltaXY(pm);
            this.xydata[pm] = Point.of(this.xydata[pm].x + dxy[0], this.xydata[pm].y + dxy[1]);
            double deltam = this.calcDeltaM(pm);
            if (deltam < this.EPSILON) break;
        }
        if (this.adjustForGravity) {
            this.adjustForGravity();
        }
        if (this.exchangevertices && maxDeltaM < this.EPSILON) {
            double energy = this.calcEnergy();
            for (i = 0; i < n - 1; ++i) {
                if (this.layoutModel.isLocked(this.vertices[i])) continue;
                for (int j = i + 1; j < n; ++j) {
                    double xenergy;
                    if (this.layoutModel.isLocked(this.vertices[j]) || !(energy > (xenergy = this.calcEnergyIfExchanged(i, j)))) continue;
                    double sx = this.xydata[i].x;
                    double sy = this.xydata[i].y;
                    this.xydata[i] = Point.of(this.xydata[j].x, this.xydata[j].y);
                    this.xydata[j] = Point.of(sx, sy);
                    return;
                }
            }
        }
    }

    public void adjustForGravity() {
        double height = this.layoutModel.getHeight();
        double width = this.layoutModel.getWidth();
        double gx = 0.0;
        double gy = 0.0;
        for (Point aXydata : this.xydata) {
            gx += aXydata.x;
            gy += aXydata.y;
        }
        double diffx = width / 2.0 - (gx /= (double)this.xydata.length);
        double diffy = height / 2.0 - (gy /= (double)this.xydata.length);
        for (int i = 0; i < this.xydata.length && !this.cancelled; ++i) {
            this.xydata[i] = this.xydata[i].add(diffx, diffy);
            this.layoutModel.set(this.vertices[i], this.xydata[i]);
        }
    }

    public void setAdjustForGravity(boolean on) {
        this.adjustForGravity = on;
    }

    public boolean getAdjustForGravity() {
        return this.adjustForGravity;
    }

    public void setExchangevertices(boolean on) {
        this.exchangevertices = on;
    }

    public boolean getExchangevertices() {
        return this.exchangevertices;
    }

    private double[] calcDeltaXY(int m) {
        double dE_dxm = 0.0;
        double dE_dym = 0.0;
        double d2E_d2xm = 0.0;
        double d2E_dxmdym = 0.0;
        double d2E_dymdxm = 0.0;
        double d2E_d2ym = 0.0;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (i == m) continue;
            double dist = this.dm[m][i];
            double l_mi = this.L * dist;
            double k_mi = this.K / (dist * dist);
            double dx = this.xydata[m].x - this.xydata[i].x;
            double dy = this.xydata[m].y - this.xydata[i].y;
            double d = Math.sqrt(dx * dx + dy * dy);
            double ddd = d * d * d;
            dE_dxm += k_mi * (1.0 - l_mi / d) * dx;
            dE_dym += k_mi * (1.0 - l_mi / d) * dy;
            d2E_d2xm += k_mi * (1.0 - l_mi * dy * dy / ddd);
            d2E_dxmdym += k_mi * l_mi * dx * dy / ddd;
            d2E_d2ym += k_mi * (1.0 - l_mi * dx * dx / ddd);
        }
        d2E_dymdxm = d2E_dxmdym;
        double denomi = d2E_d2xm * d2E_d2ym - d2E_dxmdym * d2E_dymdxm;
        double deltaX = (d2E_dxmdym * dE_dym - d2E_d2ym * dE_dxm) / denomi;
        double deltaY = (d2E_dymdxm * dE_dxm - d2E_d2xm * dE_dym) / denomi;
        return new double[]{deltaX, deltaY};
    }

    private double calcDeltaM(int m) {
        double dEdxm = 0.0;
        double dEdym = 0.0;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (i == m) continue;
            double dist = this.dm[m][i];
            double l_mi = this.L * dist;
            double k_mi = this.K / (dist * dist);
            double dx = this.xydata[m].x - this.xydata[i].x;
            double dy = this.xydata[m].y - this.xydata[i].y;
            double d = Math.sqrt(dx * dx + dy * dy);
            double common = k_mi * (1.0 - l_mi / d);
            dEdxm += common * dx;
            dEdym += common * dy;
        }
        return Math.sqrt(dEdxm * dEdxm + dEdym * dEdym);
    }

    private double calcEnergy() {
        double energy = 0.0;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            for (int j = i + 1; j < this.vertices.length; ++j) {
                double dist = this.dm[i][j];
                double l_ij = this.L * dist;
                double k_ij = this.K / (dist * dist);
                double dx = this.xydata[i].x - this.xydata[j].x;
                double dy = this.xydata[i].y - this.xydata[j].y;
                double d = Math.sqrt(dx * dx + dy * dy);
                energy += k_ij / 2.0 * (dx * dx + dy * dy + l_ij * l_ij - 2.0 * l_ij * d);
            }
        }
        return energy;
    }

    private double calcEnergyIfExchanged(int p, int q) {
        if (p >= q) {
            throw new RuntimeException("p should be < q");
        }
        double energy = 0.0;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            for (int j = i + 1; j < this.vertices.length; ++j) {
                int ii = i;
                int jj = j;
                if (i == p) {
                    ii = q;
                }
                if (j == q) {
                    jj = p;
                }
                double dist = this.dm[i][j];
                double l_ij = this.L * dist;
                double k_ij = this.K / (dist * dist);
                double dx = this.xydata[ii].x - this.xydata[jj].x;
                double dy = this.xydata[ii].y - this.xydata[jj].y;
                double d = Math.sqrt(dx * dx + dy * dy);
                energy += k_ij / 2.0 * (dx * dx + dy * dy + l_ij * l_ij - 2.0 * l_ij * d);
            }
        }
        return energy;
    }

    private static <V> double diameter(Graph<V, ?> g, Map<Pair<V>, Integer> d, boolean use_max) {
        double diameter = 0.0;
        for (Object v : g.vertexSet()) {
            for (Object w : g.vertexSet()) {
                if (v.equals(w)) continue;
                Pair pair = Pair.of(v, w);
                if (d.containsKey(pair)) {
                    int dist = d.get(pair);
                    diameter = Math.max(diameter, (double)dist);
                    continue;
                }
                if (use_max) continue;
                return Double.POSITIVE_INFINITY;
            }
        }
        return diameter;
    }

    public static class Builder<V, T extends KKLayoutAlgorithm<V>, B extends Builder<V, T, B>>
    extends AbstractIterativeLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        protected int maxIterations = 2000;
        protected boolean adjustForGravity = true;
        protected boolean exchangeVertices = true;

        public B maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            return (B)((Builder)this.self());
        }

        public B adjustForGravity(boolean adjustForGravity) {
            this.adjustForGravity = adjustForGravity;
            return (B)((Builder)this.self());
        }

        public B exchangeVertices(boolean exchangeVertices) {
            this.exchangeVertices = exchangeVertices;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new KKLayoutAlgorithm(this);
        }
    }

    public static class Pair<V> {
        final V first;
        final V second;

        public static <V> Pair<V> of(V first, V second) {
            return new Pair<V>(first, second);
        }

        private Pair(V first, V second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return Objects.equals(this.first, pair.first) && Objects.equals(this.second, pair.second);
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "Pair{" + this.first + "," + this.second + "}";
        }
    }
}

