/*
 * Decompiled with CFR 0.152.
 */
package datagraph.graph.explore;

import com.google.common.base.Function;
import datagraph.graph.explore.AbstractExplorationGraph;
import datagraph.graph.explore.EgEdge;
import datagraph.graph.explore.EgEdgeRenderer;
import datagraph.graph.explore.EgEdgeTransformer;
import datagraph.graph.explore.EgVertex;
import datagraph.graph.explore.GraphLocationMap;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.layout.AbstractVisualGraphLayout;
import ghidra.graph.viewer.layout.GridLocationMap;
import ghidra.graph.viewer.layout.LayoutListener;
import ghidra.graph.viewer.layout.LayoutPositions;
import ghidra.graph.viewer.vertex.VisualGraphVertexShapeTransformer;
import ghidra.util.task.TaskMonitor;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.help.UnsupportedOperationException;

public abstract class EgGraphLayout<V extends EgVertex, E extends EgEdge<V>>
extends AbstractVisualGraphLayout<V, E> {
    private EgEdgeRenderer<V, E> edgeRenderer = new EgEdgeRenderer();
    private EgEdgeTransformer<V, E> edgeTransformer;
    private java.util.function.Function<V, Shape> vertexShapeTransformer = new VisualGraphVertexShapeTransformer();
    protected int verticalGap;
    protected int horizontalGap;

    protected EgGraphLayout(AbstractExplorationGraph<V, E> graph, String name, int verticalGap, int horizontalGap) {
        super(graph, name);
        this.verticalGap = verticalGap;
        this.horizontalGap = horizontalGap;
        this.edgeTransformer = this.createEdgeTransformer();
    }

    protected abstract EgEdgeTransformer<V, E> createEdgeTransformer();

    protected abstract Comparator<V> getIncommingVertexComparator();

    protected abstract Comparator<V> getOutgoingVertexComparator();

    public Point2D apply(V v) {
        if (((EgVertex)((Object)v)).hasUserChangedLocation()) {
            return v.getLocation();
        }
        return super.apply(v);
    }

    public VisualGraph<V, E> getVisualGraph() {
        return (VisualGraph)this.getGraph();
    }

    public BasicEdgeRenderer<V, E> getEdgeRenderer() {
        return this.edgeRenderer;
    }

    public Function<E, Shape> getEdgeShapeTransformer(RenderContext<V, E> context) {
        return this.edgeTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LayoutPositions<V, E> doCalculateLocations(VisualGraph<V, E> g, TaskMonitor taskMonitor) {
        if (!(g instanceof AbstractExplorationGraph)) {
            throw new IllegalArgumentException("This layout only supports Layered graphs!");
        }
        AbstractExplorationGraph layeredGraph = (AbstractExplorationGraph)g;
        try {
            this.monitor = taskMonitor;
            LayoutPositions<V, E> layoutPositions = this.computePositions(layeredGraph);
            return layoutPositions;
        }
        finally {
            this.monitor = TaskMonitor.DUMMY;
        }
    }

    private LayoutPositions<V, E> computePositions(AbstractExplorationGraph<V, E> g) {
        GraphLocationMap<V> locationMap = this.getLocationMap(g, g.getRoot());
        Map<V, Point2D> vertexLocations = locationMap.getVertexLocations();
        return LayoutPositions.createNewPositions(vertexLocations, Collections.emptyMap());
    }

    protected GridLocationMap<V, E> performInitialGridLayout(VisualGraph<V, E> g) {
        throw new UnsupportedOperationException();
    }

    private GraphLocationMap<V> getLocationMap(AbstractExplorationGraph<V, E> g, V v) {
        List<GraphLocationMap<V>> leftMaps = this.getMapsForIncommingEdges(g, v);
        List<GraphLocationMap<V>> rightMaps = this.getMapsForOutgoingEdges(g, v);
        Shape shape = this.vertexShapeTransformer.apply(v);
        Rectangle bounds = shape.getBounds();
        GraphLocationMap<V> baseMap = new GraphLocationMap<V>(v, bounds.width, bounds.height);
        if (leftMaps != null) {
            this.mergeLeftMaps(baseMap, leftMaps);
        }
        if (rightMaps != null) {
            this.mergeRightMaps(baseMap, rightMaps);
        }
        return baseMap;
    }

    private void mergeLeftMaps(GraphLocationMap<V> baseMap, List<GraphLocationMap<V>> leftMaps) {
        int shiftY = this.getTopGroupShift(leftMaps, this.verticalGap);
        int baseShiftX = baseMap.getMinX() - this.horizontalGap;
        for (GraphLocationMap<V> map : leftMaps) {
            int shiftX = baseShiftX - map.getMaxX();
            baseMap.merge(map, shiftX, shiftY += map.getHeight() / 2);
            shiftY += map.getHeight() / 2 + this.verticalGap;
        }
    }

    private void mergeRightMaps(GraphLocationMap<V> baseMap, List<GraphLocationMap<V>> rightMaps) {
        int shiftY = this.getTopGroupShift(rightMaps, this.verticalGap);
        int baseShiftX = baseMap.getMaxX() + this.horizontalGap;
        for (GraphLocationMap<V> map : rightMaps) {
            int shiftX = baseShiftX - map.getMinX();
            baseMap.merge(map, shiftX, shiftY += map.getHeight() / 2);
            shiftY += map.getHeight() / 2 + this.verticalGap;
        }
    }

    private int getTopGroupShift(List<GraphLocationMap<V>> maps, int gap) {
        int totalHeight = 0;
        for (GraphLocationMap<V> map : maps) {
            totalHeight += map.getHeight();
        }
        return -(totalHeight += (maps.size() - 1) * gap) / 2;
    }

    private List<GraphLocationMap<V>> getMapsForOutgoingEdges(AbstractExplorationGraph<V, E> g, V v) {
        List<E> edges = this.getOutgoingNextLayerEdges(g, v);
        if (edges == null || edges.isEmpty()) {
            return null;
        }
        return this.getOutgoingGraphMaps(g, edges);
    }

    private List<GraphLocationMap<V>> getMapsForIncommingEdges(AbstractExplorationGraph<V, E> g, V v) {
        List<E> edges = this.getIncommingNextLayerEdges(g, v);
        if (edges == null || edges.isEmpty()) {
            return null;
        }
        return this.getIncomingGraphMaps(g, edges);
    }

    private List<GraphLocationMap<V>> getOutgoingGraphMaps(AbstractExplorationGraph<V, E> g, List<E> edges) {
        ArrayList<GraphLocationMap<V>> maps = new ArrayList<GraphLocationMap<V>>(edges.size());
        for (EgEdge e : edges) {
            maps.add(this.getLocationMap(g, (EgVertex)e.getEnd()));
        }
        return maps;
    }

    private List<GraphLocationMap<V>> getIncomingGraphMaps(AbstractExplorationGraph<V, E> g, List<E> edges) {
        ArrayList<GraphLocationMap<V>> maps = new ArrayList<GraphLocationMap<V>>(edges.size());
        for (EgEdge e : edges) {
            maps.add(this.getLocationMap(g, (EgVertex)e.getStart()));
        }
        return maps;
    }

    private List<E> getOutgoingNextLayerEdges(AbstractExplorationGraph<V, E> g, V v) {
        Collection outEdges = g.getOutEdges(v);
        if (outEdges == null || outEdges.isEmpty()) {
            return null;
        }
        ArrayList<EgEdge> nextLayerEdges = new ArrayList<EgEdge>();
        for (EgEdge e : outEdges) {
            if (!v.equals((Object)((EgVertex)e.getEnd()).getSourceVertex())) continue;
            nextLayerEdges.add(e);
        }
        Comparator c = this.getOutgoingVertexComparator();
        nextLayerEdges.sort((e1, e2) -> c.compare((Object)((Object)((EgVertex)e1.getEnd())), (Object)((Object)((EgVertex)e2.getEnd()))));
        return nextLayerEdges;
    }

    private List<E> getIncommingNextLayerEdges(AbstractExplorationGraph<V, E> g, V v) {
        Collection inEdges = g.getInEdges(v);
        if (inEdges == null || inEdges.isEmpty()) {
            return null;
        }
        ArrayList<EgEdge> nextLayerEdges = new ArrayList<EgEdge>();
        for (EgEdge e : inEdges) {
            if (!v.equals((Object)((EgVertex)e.getStart()).getSourceVertex())) continue;
            nextLayerEdges.add(e);
        }
        Comparator c = this.getIncommingVertexComparator();
        nextLayerEdges.sort((e1, e2) -> c.compare((Object)((Object)((EgVertex)e1.getStart())), (Object)((Object)((EgVertex)e2.getStart()))));
        return nextLayerEdges;
    }

    protected void fireVertexLocationChanged(V v, Point2D p, LayoutListener.ChangeType type) {
        if (type == LayoutListener.ChangeType.USER) {
            ((EgVertex)((Object)v)).setUserChangedLocation(new Point2D.Double(p.getX(), p.getY()));
        }
        super.fireVertexLocationChanged(v, p, type);
    }
}

