/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.filechooser;

import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExtensionFileFilter
implements GhidraFileFilter {
    private List<String> extensions;
    private String description;
    private String fullDescription;

    public static ExtensionFileFilter forExtensions(String description, String ... exts) {
        ExtensionFileFilter eff = new ExtensionFileFilter(exts, description);
        return eff;
    }

    public ExtensionFileFilter(String extension, String description) {
        this(new String[]{extension}, description);
    }

    public ExtensionFileFilter(String[] filters, String description) {
        this.extensions = Arrays.asList(filters).stream().map(String::toLowerCase).collect(Collectors.toList());
        this.description = description;
    }

    @Override
    public boolean accept(File f, GhidraFileChooserModel model) {
        if (f == null) {
            return false;
        }
        if (model.isDirectory(f)) {
            return true;
        }
        if (this.extensions.isEmpty()) {
            return true;
        }
        String filename = f.getName().toLowerCase();
        if (filename.startsWith(".")) {
            return false;
        }
        int fnLen = filename.length();
        for (String ext : this.extensions) {
            int extLen = ext.length();
            int extStart = fnLen - extLen;
            if (extStart <= 0 || !filename.substring(extStart).equals(ext) || filename.charAt(extStart - 1) != '.') continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            this.fullDescription = Objects.requireNonNullElse(this.description, "");
            this.fullDescription = this.fullDescription + " (";
            this.fullDescription = this.fullDescription + (this.extensions.isEmpty() ? "*.*" : this.extensions.stream().map(s -> "*." + s).collect(Collectors.joining(",")));
            this.fullDescription = this.fullDescription + ")";
        }
        return this.fullDescription;
    }
}

