/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.events;

import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.ToolEventName;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.lang.ref.WeakReference;

@ToolEventName(value="Program Location Change")
public final class ExternalProgramLocationPluginEvent
extends PluginEvent {
    public static final String NAME = "External Program Location Change";
    public static final String TOOL_EVENT_NAME = "Program Location Change";
    private ProgramLocation loc;
    private WeakReference<Program> programRef;

    public ExternalProgramLocationPluginEvent(String src, ProgramLocation loc, Program program) {
        super(src, NAME);
        this.loc = loc;
        this.programRef = new WeakReference<Program>(program);
    }

    public ProgramLocation getLocation() {
        return this.loc;
    }

    public Program getProgram() {
        return (Program)this.programRef.get();
    }
}

