/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.ImageRuntimeFunctionEntries_X86;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PEx64UnwindInfoDataType;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

class PEx64UnwindInfo
implements StructConverter {
    static final int UNW_FLAG_NHANDLER = 0;
    static final int UNW_FLAG_EHANDLER = 1;
    static final int UNW_FLAG_UHANDLER = 2;
    static final int UNW_FLAG_CHAININFO = 4;
    private static final int UNWIND_INFO_VERSION_MASK = 7;
    private static final int UNWIND_INFO_FLAGS_MASK = 31;
    private static final int UNWIND_INFO_FLAGS_SHIFT = 3;
    private static final int UNWIND_INFO_FRAME_REGISTER_MASK = 15;
    private static final int UNWIND_INFO_FRAME_OFFSET_SHIFT = 4;
    private static final int UNWIND_INFO_OPCODE_MASK = 15;
    private static final int UNWIND_INFO_OPCODE_INFO_SHIFT = 4;
    private static final int UNWIND_INFO_OPCODE_INFO_MASK = 15;
    byte version;
    byte flags;
    int sizeOfProlog;
    int countOfUnwindCodes;
    byte frameRegister;
    byte frameOffset;
    UNWIND_CODE[] unwindCodes;
    int exceptionHandlerFunction;
    ImageRuntimeFunctionEntries_X86.ImageRuntimeFunctionEntry_X86 unwindHandlerChainInfo;
    long startOffset;

    public PEx64UnwindInfo(long offset) {
        this.startOffset = offset;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return PEx64UnwindInfoDataType.INSTANCE;
    }

    public boolean hasExceptionHandler() {
        return (this.flags & 1) == 1;
    }

    public boolean hasUnwindHandler() {
        return (this.flags & 2) == 2;
    }

    public boolean hasChainedUnwindInfo() {
        return (this.flags & 4) == 4;
    }

    static PEx64UnwindInfo readUnwindInfo(BinaryReader reader, long offset, NTHeader ntHeader) throws IOException {
        long origIndex = reader.getPointerIndex();
        long pointer = ntHeader.rvaToPointer(offset);
        PEx64UnwindInfo unwindInfo = new PEx64UnwindInfo(pointer);
        if (pointer < 0L) {
            return unwindInfo;
        }
        reader.setPointerIndex(pointer);
        byte splitByte = reader.readNextByte();
        unwindInfo.version = (byte)(splitByte & 7);
        unwindInfo.flags = (byte)(splitByte >> 3 & 0x1F);
        unwindInfo.sizeOfProlog = reader.readNextUnsignedByte();
        unwindInfo.countOfUnwindCodes = reader.readNextUnsignedByte();
        splitByte = reader.readNextByte();
        unwindInfo.frameRegister = (byte)(splitByte & 0xF);
        unwindInfo.frameOffset = (byte)(splitByte >> 4);
        unwindInfo.unwindCodes = new UNWIND_CODE[unwindInfo.countOfUnwindCodes];
        for (int i = 0; i < unwindInfo.countOfUnwindCodes; ++i) {
            UNWIND_CODE code = new UNWIND_CODE();
            code.offsetInProlog = reader.readNextByte();
            int opCodeData = reader.readNextUnsignedByte();
            code.opCode = UNWIND_CODE_OPCODE.fromInt(opCodeData & 0xF);
            code.opInfo = (byte)(opCodeData >> 4 & 0xF);
            unwindInfo.unwindCodes[i] = code;
        }
        if (unwindInfo.hasExceptionHandler() || unwindInfo.hasUnwindHandler()) {
            unwindInfo.exceptionHandlerFunction = reader.readNextInt();
        } else if (unwindInfo.hasChainedUnwindInfo()) {
            long beginAddress = reader.readNextUnsignedInt();
            long endAddress = reader.readNextUnsignedInt();
            long unwindInfoAddressOrData = reader.readNextUnsignedInt();
            PEx64UnwindInfo info = PEx64UnwindInfo.readUnwindInfo(reader, unwindInfoAddressOrData, ntHeader);
            unwindInfo.unwindHandlerChainInfo = new ImageRuntimeFunctionEntries_X86.ImageRuntimeFunctionEntry_X86(beginAddress, endAddress, unwindInfoAddressOrData, info);
        }
        reader.setPointerIndex(origIndex);
        return unwindInfo;
    }

    static class UNWIND_CODE {
        byte offsetInProlog;
        UNWIND_CODE_OPCODE opCode;
        byte opInfo;

        UNWIND_CODE() {
        }
    }

    public static enum UNWIND_CODE_OPCODE {
        UWOP_PUSH_NONVOL(0),
        UWOP_ALLOC_LARGE(1),
        UWOP_ALLOC_SMALL(2),
        UWOP_SET_FPREG(3),
        UWOP_SAVE_NONVOL(4),
        UWOP_SAVE_NONVOL_FAR(5),
        UWOP_SAVE_XMM(6),
        UWOP_SAVE_XMM_FAR(7),
        UWOP_SAVE_XMM128(8),
        UWOP_SAVE_XMM128_FAR(9),
        UWOP_PUSH_MACHFRAME(10);

        public final int id;

        private UNWIND_CODE_OPCODE(int value) {
            this.id = value;
        }

        public int id() {
            return this.id;
        }

        public static UNWIND_CODE_OPCODE fromInt(int id) {
            UNWIND_CODE_OPCODE[] values;
            for (UNWIND_CODE_OPCODE value : values = UNWIND_CODE_OPCODE.values()) {
                if (value.id != id) continue;
                return value;
            }
            return null;
        }
    }
}

