/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliSigMethodSpec
extends CliAbstractSig {
    private int genArgCount;
    private int genArgCountBytes;
    private CliAbstractSig.CliSigType[] types;
    private static final byte CLISIGMETHODSPEC_PROLOG = 10;

    public CliSigMethodSpec(CliBlob blob) throws IOException {
        super(blob);
        BinaryReader reader = this.getContentsReader();
        byte prolog = reader.readNextByte();
        if (prolog != 10) {
            Msg.warn((Object)this, (Object)("MethodSpec had unexpected prolog (0x" + Integer.toHexString(prolog) + ")."));
            return;
        }
        long origIndex = reader.getPointerIndex();
        this.genArgCount = CliSigMethodSpec.decodeCompressedUnsignedInt(reader);
        this.genArgCountBytes = (int)(reader.getPointerIndex() - origIndex);
        this.types = new CliAbstractSig.CliSigType[this.genArgCount];
        for (int i = 0; i < this.genArgCount; ++i) {
            try {
                this.types[i] = this.readCliType(reader);
                continue;
            }
            catch (InvalidInputException e) {
                this.types[i] = null;
            }
        }
    }

    @Override
    public String getContentsName() {
        return "MethodSpecSig";
    }

    @Override
    public String getContentsComment() {
        return "Specifies a generic method with GenArgCount types";
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs/Signatures"), this.getName(), 0);
        struct.add(BYTE, "GENRICINST", "Magic (0x0a)");
        struct.add(CliSigMethodSpec.getDataTypeForBytes(this.genArgCountBytes), "GenArgCount", "Number of types to follow");
        for (int i = 0; i < this.types.length; ++i) {
            struct.add(this.types[i].getDefinitionDataType(), "Type" + i, null);
        }
        return struct;
    }

    @Override
    public String getRepresentationCommon(CliStreamMetadata stream, boolean isShort) {
        Object typesRep = "";
        for (CliAbstractSig.CliSigType type : this.types) {
            typesRep = type == null ? (String)typesRep + "unidentified_param_type, " : (String)typesRep + this.getRepresentationOf(type, stream, isShort) + ", ";
        }
        if (this.types.length > 0) {
            typesRep = ((String)typesRep).substring(0, ((String)typesRep).length() - 2);
        }
        String rep = String.format("GenericInst %d %s", this.genArgCount, typesRep);
        return rep;
    }
}

