/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import ghidra.graph.viewer.layout.GridPoint;

public class GridBounds {
    private int minRow = 0;
    private int maxRow = 0;
    private int minCol = 0;
    private int maxCol = 0;

    public void update(GridPoint p) {
        this.minRow = Math.min(this.minRow, p.row);
        this.maxRow = Math.max(this.maxRow, p.row);
        this.minCol = Math.min(this.minCol, p.col);
        this.maxCol = Math.max(this.maxCol, p.col);
    }

    public void shift(int rowShift, int colShift) {
        this.minCol += colShift;
        this.maxCol += colShift;
        this.minRow += rowShift;
        this.maxRow += rowShift;
    }

    public String toString() {
        StringBuilder buffy = new StringBuilder();
        buffy.append("Grid Bounds: ");
        if (this.minRow == Integer.MAX_VALUE) {
            return "Empty";
        }
        buffy.append("rows: ").append(this.minRow).append(" -> ").append(this.maxRow);
        buffy.append(",  ");
        buffy.append("cols: ").append(this.minCol).append(" -> ").append(this.maxCol);
        return buffy.toString();
    }

    public int maxCol() {
        return this.maxCol;
    }

    public int minCol() {
        if (this.minCol > this.maxCol) {
            return 0;
        }
        return this.minCol;
    }

    public int maxRow() {
        return this.maxRow;
    }

    public int minRow() {
        if (this.minRow > this.maxRow) {
            return 0;
        }
        return this.minRow;
    }

    public boolean contains(GridPoint p) {
        if (p.row < this.minRow || p.row > this.maxRow) {
            return false;
        }
        return p.col >= this.minCol && p.col <= this.maxCol;
    }

    public void transpose() {
        int temp = this.minRow;
        this.minRow = this.minCol;
        this.minCol = temp;
        temp = this.maxRow;
        this.maxRow = this.maxCol;
        this.maxCol = temp;
    }
}

