/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.ContextChange;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.util.NumericUtilities;

public class ContextOp
implements ContextChange {
    PatternExpression patexp;
    int num;
    int mask;
    int shift;

    @Override
    public void apply(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException {
        int val = (int)this.patexp.getValue(walker);
        walker.getParserContext().setContextWord(this.num, val <<= this.shift, this.mask);
        if (debug != null) {
            debug.dumpContextSet(walker.getParserContext(), this.num, val, this.mask);
        }
    }

    @Override
    public void decode(Decoder decoder, SleighLanguage lang) throws DecoderException {
        int el = decoder.openElement(SlaFormat.ELEM_CONTEXT_OP);
        this.num = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_I);
        this.shift = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_SHIFT);
        this.mask = (int)decoder.readUnsignedInteger(SlaFormat.ATTRIB_MASK);
        this.patexp = PatternExpression.decodeExpression(decoder, lang);
        decoder.closeElement(el);
    }

    public PatternExpression getPatternExpression() {
        return this.patexp;
    }

    public int getWordIndex() {
        return this.num;
    }

    public int getMask() {
        return this.mask;
    }

    public int getShift() {
        return this.shift;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ctx&");
        for (int i = 0; i < this.num; ++i) {
            sb.append("SS:SS:SS:SS:");
        }
        sb.append(NumericUtilities.convertMaskToHexString((long)this.mask, (int)8, (boolean)false, (int)2, (String)":"));
        sb.append(" := ");
        sb.append(this.patexp);
        sb.append("( << ");
        sb.append(this.shift);
        sb.append(")");
        return sb.toString();
    }
}

