import { TokenType, StatementPosition } from '../types.js';
import '@grafana/ui';
import '@grafana/data';

function getStatementPosition(currentToken, statementPositionResolversRegistry) {
  var _a;
  const previousNonWhiteSpace = currentToken == null ? undefined : currentToken.getPreviousNonWhiteSpaceToken();
  const previousKeyword = currentToken == null ? undefined : currentToken.getPreviousKeyword();
  const previousIsSlash = (_a = currentToken == null ? undefined : currentToken.getPreviousNonWhiteSpaceToken()) == null ? undefined : _a.is(TokenType.Operator, "/");
  const resolvers = statementPositionResolversRegistry.list();
  const positions = [];
  for (const resolver of resolvers) {
    if (resolver.resolve(currentToken, previousKeyword != null ? previousKeyword : null, previousNonWhiteSpace != null ? previousNonWhiteSpace : null, Boolean(previousIsSlash))) {
      positions.push(resolver.id);
    }
  }
  if (positions.length === 0) {
    return [StatementPosition.Unknown];
  }
  return positions;
}

export { getStatementPosition };
//# sourceMappingURL=getStatementPosition.js.map
