// Generated by gmmproc 2.86.0 -- DO NOT MODIFY!
#ifndef _GTKMM_SVG_H
#define _GTKMM_SVG_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2025 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glibmm/object.h>
#include <glibmm/bytes.h>
#include <gdkmm/frameclock.h>
#include <gdkmm/paintable.h>
#include <gtkmm/symbolicpaintable.h>
#include <string>
#include <gtk/gtk.h> // Declares GtkSvg and GtkSvgClass


#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API Svg_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
class SvgError : public Glib::Error
{
public:
  /**  @var Code INVALID_ELEMENT
   * An XML element is invalid
   * (either because it is not part of SVG, or because it is
   * in the wrong place, or because it not implemented in GTK).
   * 
   *  @var Code INVALID_ATTRIBUTE
   * An XML attribute is invalid
   * (either because it is not part of SVG, or because it is
   * not implemented in GTK, or its value is problematic).
   * 
   *  @var Code MISSING_ATTRIBUTE
   * A required attribute is missing.
   * 
   *  @var Code INVALID_REFERENCE
   * A reference does not point to
   * a suitable element.
   * 
   *  @var Code FAILED_UPDATE
   * An animation could not be updated.
   * 
   *  @var Code FAILED_RENDERING
   * Rendering is not according to
   * expecations.
   */
   /** %Error codes in the `GTK_SVG_ERROR` domain for errors
   * that happen during parsing or rendering of SVG.
   * 
   * @newin{4,22}
   */
  enum Code
  {
    INVALID_ELEMENT,
    INVALID_ATTRIBUTE,
    MISSING_ATTRIBUTE,
    INVALID_REFERENCE,
    FAILED_UPDATE,
    FAILED_RENDERING
  };

  GTKMM_API SvgError(Code error_code, const Glib::ustring& error_message);
  GTKMM_API explicit SvgError(GError* gobject);
  GTKMM_API Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  GTKMM_API static void throw_func(GError* gobject);

  friend GTKMM_API void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GTKMM_API Value<Gtk::SvgError::Code> : public Glib::Value_Enum<Gtk::SvgError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{


/** Extra %SvgError functions.
 *
 * %Gtk::SvgErrorExtra provides information not easily reachable directly
 * from %Gtk::SvgError.
 *
 * @newin{4,22}
 */
class GTKMM_API SvgErrorExtra : public SvgError
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = SvgErrorExtra;
  using BaseObjectType = GError;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
  explicit SvgErrorExtra(GError* gobject);

  
  /** Returns context information about what XML element
   * the parsing error occurred in.
   * 
   * @newin{4,22}
   * 
   * @return The element name.
   */
  Glib::ustring get_element() const;
  
  /** Returns context information about what XML attribute
   * the parsing error occurred in.
   * 
   * @newin{4,22}
   * 
   * @return The attribute name.
   */
  Glib::ustring get_attribute() const;
  
  /** Returns context information about the start position
   * in the document where the parsing error occurred.
   * 
   * @newin{4,22}
   * 
   * @return The Gtk::SvgLocation.
   */
  const GtkSvgLocation* get_start() const;
  
  /** Returns context information about the end position
   * in the document where the parsing error occurred.
   * 
   * @newin{4,22}
   * 
   * @return The Gtk::SvgLocation.
   */
  const GtkSvgLocation* get_end() const;


};

/** A paintable implementation that renders (a subset of) SVG,
 * with animations.
 *
 * %Gtk::Svg objects are created by parsing a subset of SVG,
 * including SVG animations.
 *
 * The %Gtk::Svg fills or strokes paths with symbolic or fixed
 * colors. It can have multiple states, and paths can be included
 * in a subset of the states. The special 'empty' state is always
 * available. States can have animation, and the transition between
 * different states can also be animated.
 *
 * To find out what states a %Gtk::Svg has, use get_n_states().
 * To set the current state, use set_state().
 *
 * To play the animations in an SVG file, use
 * set_frame_clock() to connect the paintable to a frame clock,
 * and then use play() to start the animation.
 *
 * ## SVG Extensions
 *
 * The paintable supports a number of custom attributes that offer a convenient
 * way to define states, transitions and animations.
 * For example,
 * @code
 *     <circle cx='5' cy='5' r='5'
 *             gpa:states='0 1'
 *             gpa:animation-type='automatic'
 *             gpa:animation-direction='segment'
 *             gpa:animation-duration='600ms'/>
 * @endcode
 * defines the circle to be shown in states 0 and 1,
 * and animates a segment of the circle.
 *
 * @image html svg-renderer1.svg
 *
 * Note that the generated animations assume a `pathLengh` value of 1.
 * Setting `pathLength` in your SVG is therefore going to break such
 * generated animations.
 *
 * To connect general SVG animations to the states of the paintable,
 * use the custom `gpa:states(...)` condition in the `begin` and `end`
 * attributes of SVG animation elements. For example,
 * @code
 *     <animate href='path1'
 *              attributeName='fill'
 *              begin='gpa:states(0).begin'
 *              dur='300ms'
 *              fill='freeze'
 *              from='black'
 *              to='magenta'/>
 * @endcode
 * will make the fill color of path1 transition from black to
 * magenta when the renderer enters state 0.
 *
 * @image html svg-renderer2.svg
 *
 * Symbolic colors can also be specified as a custom paint server
 * reference, like this: `url(gpa:#warning)`. This works in `fill`
 * and `stroke` attributes, but also when specifying colors in SVG
 * animation attributes like `to` or `values`. Note that the SVG
 * syntax allows for a fallback RGB color to be specified after the
 * url, for compatibility with other SVG consumers:
 *
 *     fill='url(gpa:#warning) orange'
 *
 * In contrast to SVG 1.1 and 2.0, we allow the `transform` attribute
 * to be animated with `<animate>`.
 *
 * ## The supported subset of SVG
 *
 * The renderer does not support text or images, only paths. From the
 * shape elements of SVG, only `<circle>`, `<ellipse>`, `<rect>` and
 * `<path>` are supported, leaving out `<line>`, `<polyline>` and
 * `<polygon>`.
 *
 * In `<defs>`, only `<clipPath>`, `<mask>`, gradients and shapes are
 * supported, not `<filter>`, `<pattern>` or other things.
 *
 * Gradient templating is not implemented, and radial gradients with
 * `fx,fy != cx,cy` are not supported.
 *
 * The support for filters is limited to filter functions minus
 * `drop-shadow()` plus a custom `alpha-level()` function, which
 * implements one particular case of feComponentTransfer.
 *
 * The `transform-origin` and `transform-box` attributes are not supported.
 *
 * The support for the `mask` attribute is limited to just a url
 * referring to the `<mask>` element by ID.
 *
 * In animation elements, the parsing of `begin` and `end` attributes
 * is limited, and the `by`, `min` and `max` attributes are not supported.
 *
 * Lastly, there is no CSS support, and no interactivity.
 *
 * ## Error handling
 *
 * Loading an SVG into %Gtk::Svg will always produce a (possibly empty)
 * paintable. GTK will drop things that it can't handle and try to make
 * sense of the rest.
 *
 * To track errors during parsing or rendering, connect to signal_error().
 *
 * For parsing errors in the `GTK_SVG_ERROR` domain, the functions
 * Gtk::SvgErrorExtra::get_start(), Gtk::SvgErrorExtra::get_end(),
 * Gtk::SvgErrorExtra::get_element() and Gtk::SvgErrorExtra::get_attribute()
 * can be used to obtain information about where the error occurred.
 *
 * @newin{4,22}
 */

class GTKMM_API Svg : public Glib::Object, public Gdk::Paintable, public SymbolicPaintable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Svg;
  using CppClassType = Svg_Class;
  using BaseObjectType = GtkSvg;
  using BaseClassType = GtkSvgClass;

  // noncopyable
  Svg(const Svg&) = delete;
  Svg& operator=(const Svg&) = delete;

private:  friend class Svg_Class;
  static CppClassType svg_class_;

protected:
  explicit Svg(const Glib::ConstructParams& construct_params);
  explicit Svg(GtkSvg* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Svg(Svg&& src) noexcept;
  Svg& operator=(Svg&& src) noexcept;

  ~Svg() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSvg*       gobj()       { return reinterpret_cast<GtkSvg*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSvg* gobj() const { return reinterpret_cast<GtkSvg*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSvg* gobj_copy();

private:

  
protected:
  Svg();

public:
  /** @addtogroup gtkmmEnums gtkmm Enums and Flags */

  /** 
   *  @var Features::ANIMATIONS
   * Whether to run animations.
   * If disabled, state changes are applied without
   * transitions.
   * 
   *  @var Features::SYSTEM_RESOURCES
   * Whether to use system resources,
   * such as fonts. If disabled, only embedded fonts are used.
   * 
   *  @var Features::EXTERNAL_RESOURCES
   * Whether to load external
   * resources, such as images. If disabled, only embedded
   * images are loaded.
   * 
   *  @var Features::EXTENSIONS
   * Whether to allow gpa extensions, such
   * as states and transitions.
   */
   /** Features of the SVG renderer that can be disabled.
   * 
   * By default, all features are enabled.
   * 
   * New values may be added in the future.
   * 
   * @newin{4,22}
   *
   * @ingroup gtkmmEnums
   * @par Bitwise operators:
   * <tt>Svg::Features operator|(Svg::Features, Svg::Features)</tt><br>
   * <tt>Svg::Features operator&(Svg::Features, Svg::Features)</tt><br>
   * <tt>Svg::Features operator^(Svg::Features, Svg::Features)</tt><br>
   * <tt>Svg::Features operator~(Svg::Features)</tt><br>
   * <tt>Svg::Features& operator|=(Svg::Features&, Svg::Features)</tt><br>
   * <tt>Svg::Features& operator&=(Svg::Features&, Svg::Features)</tt><br>
   * <tt>Svg::Features& operator^=(Svg::Features&, Svg::Features)</tt><br>
   */
  enum class Features
  {
    ANIMATIONS = 1 << 0,
    SYSTEM_RESOURCES = 1 << 1,
    EXTERNAL_RESOURCES = 1 << 2,
    EXTENSIONS = 1 << 3
  };


  /** Creates a new, empty SVG paintable.
   */
  
  static Glib::RefPtr<Svg> create();


  // gtk_svg_new_from_bytes() and gtk_svg_new_from_resource() do more than call g_object_new().
  
  /** Parses the SVG data in @a bytes and creates a paintable.
   * 
   * @newin{4,22}
   * 
   * @param bytes The data.
   * @return The paintable.
   */
  static Glib::RefPtr<Svg> create(const Glib::RefPtr<const Glib::Bytes>& bytes);
  
  /** Parses the SVG data in the resource and creates a paintable.
   * 
   * @newin{4,22}
   * 
   * @param path The resource path.
   * @return The paintable.
   */
  static Glib::RefPtr<Svg> create(const std::string& path);

  
  /** Loads SVG content into an existing SVG paintable.
   * 
   * To track errors while loading SVG content,
   * connect to the signal_error() signal.
   * 
   * This clears any previously loaded content.
   * 
   * @newin{4,22}
   * 
   * @param bytes The data to load.
   */
  void load_from_bytes(const Glib::RefPtr<const Glib::Bytes>& bytes);
  
  /** Loads SVG content into an existing SVG paintable.
   * 
   * To track errors while loading SVG content,
   * connect to the signal_error() signal.
   * 
   * This clears any previously loaded content.
   * 
   * @newin{4,22}
   * 
   * @param path The resource path.
   */
  void load_from_resource(const std::string& path);
  
  /** Serializes the content of the renderer as SVG.
   * 
   * The SVG will be similar to the orignally loaded one,
   * but is not guaranteed to be 100% identical.
   * 
   * This function serializes the DOM, i.e. the results
   * of parsing the SVG. It does not reflect the effect
   * of applying animations.
   * 
   * @newin{4,22}
   * 
   * @return The serialized contents.
   */
  Glib::RefPtr<Glib::Bytes> serialize() const;
  
  /** Serializes the paintable, and saves the result to a file.
   * 
   * @newin{4,22}
   * 
   * @param filename The file to save to.
   * 
   * @throws Glib::Error
   */
  void write_to_file(const std::string& filename) const;
  
  /** Sets the weight that is used when rendering.
   * 
   * The default value of -1 means to use the font weight
   * from CSS.
   * 
   * @newin{4,22}
   * 
   * @param weight The font weight, as a value between -1 and 1000.
   */
  void set_weight(double weight);
  
  /** Gets the value of the weight property.
   * 
   * @newin{4,22}
   * 
   * @return The weight.
   */
  double get_weight() const;
  
  /** Sets the state of the paintable.
   * 
   * Use get_n_states() to find out
   * what states @a self has.
   * 
   * Note that play() must have been
   * called for the SVG paintable to react to state changes.
   * 
   * @newin{4,22}
   * 
   * @param state The state to set, as a value between 0 and 63,
   * or `(unsigned int) -1`.
   */
  void set_state(unsigned int state);
  
  /** Gets the current state of the paintable.
   * 
   * @newin{4,22}
   * 
   * @return The state.
   */
  unsigned int get_state() const;
  
  /** Gets the number of states defined in the SVG.
   * 
   * Note that there is always an empty state, which does
   * not count towards this number. If this function returns
   * the value N, the meaningful states of the SVG are
   * 0, 1, ..., N - 1 and `GTK_SVG_STATE_EMPTY`.
   * 
   * @newin{4,22}
   * 
   * @return The number of states.
   */
  unsigned int get_n_states() const;
  
  /** Sets a frame clock.
   * 
   * Without a frame clock, GTK has to rely
   * on simple timeouts to run animations.
   * 
   * @newin{4,22}
   * 
   * @param clock The frame clock.
   */
  void set_frame_clock(const Glib::RefPtr<Gdk::FrameClock>& clock);
  
  /** Start playing animations.
   * 
   * Note that this is necessary for state changes as
   * well.
   * 
   * @newin{4,22}
   */
  void play();
  
  /** Stop any playing animations.
   * 
   * Animations can be paused and started repeatedly.
   * 
   * @newin{4,22}
   */
  void pause();
  
  /** Enables or disables features of the SVG paintable.
   * 
   * By default, all features are enabled.
   * 
   * Note that this call only has an effect before the
   * SVG is loaded.
   * 
   * @newin{4,22}
   * 
   * @param features Features to enable.
   */
  void set_features(Features features);
  
  /** Returns the currently enabled features.
   * 
   * @newin{4,22}
   * 
   * @return The enabled features.
   */
  Features get_features() const;

 
  // no_default_handler because GtkSvgClass is private.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%error(const SvgErrorExtra& error)</tt>
   *
   * Flags: Run Last
   *
   * Signals that an error occurred.
   * 
   * Errors can occur both during parsing and during rendering.
   * 
   * The expected error values are in the Gtk::SvgError enumeration,
   * context information about the location of parsing errors can
   * be obtained with the various `gtk_svg_error` functions.
   * 
   * Parsing errors are never fatal, so the parsing will resume after
   * the error. Errors may however cause parts of the given data or
   * even all of it to not be parsed at all. So it is a useful idea
   * to check that the parsing succeeds by connecting to this signal.
   * 
   * ::: note
   * This signal is emitted in the middle of parsing or rendering,
   * and if you handle it, you must be careful. Logging the errors
   * you receive is fine, but modifying the widget hierarchy or
   * changing the paintable state definitively isn't.
   * 
   * If in doubt, defer to an idle.
   * 
   * @newin{4,22}
   * 
   * @param error The error.
   */

  Glib::SignalProxy<void(const SvgErrorExtra&)> signal_error();


  /** Resource to load SVG data from.
   * 
   * This property is meant to create a paintable
   * from a resource in ui files.
   * 
   * @newin{4,22}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< std::string > property_resource() ;

/** Resource to load SVG data from.
   * 
   * This property is meant to create a paintable
   * from a resource in ui files.
   * 
   * @newin{4,22}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::string > property_resource() const;

  /** Enabled features for this paintable.
   * 
   * Note that features have to be set before
   * loading SVG data to take effect.
   * 
   * @newin{4,22}
   *
   * Default value: Gtk::Svg::Features::ANIMATIONS | Gtk::Svg::Features::SYSTEM_RESOURCES | Gtk::Svg::Features::EXTERNAL_RESOURCES | Gtk::Svg::Features::EXTENSIONS
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Features > property_features() ;

/** Enabled features for this paintable.
   * 
   * Note that features have to be set before
   * loading SVG data to take effect.
   * 
   * @newin{4,22}
   *
   * Default value: Gtk::Svg::Features::ANIMATIONS | Gtk::Svg::Features::SYSTEM_RESOURCES | Gtk::Svg::Features::EXTERNAL_RESOURCES | Gtk::Svg::Features::EXTENSIONS
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Features > property_features() const;

  /** Whether the paintable is currently animating its content.
   * 
   * To set this property, use the Gtk::Svg::play() and
   * Gtk::Svg::pause() functions.
   * 
   * @newin{4,22}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_playing() ;

/** Whether the paintable is currently animating its content.
   * 
   * To set this property, use the Gtk::Svg::play() and
   * Gtk::Svg::pause() functions.
   * 
   * @newin{4,22}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_playing() const;

  /** If not set to -1, this value overrides the weight used
   * when rendering the paintable.
   * 
   * @newin{4,22}
   *
   * Default value: -1
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_weight() ;

/** If not set to -1, this value overrides the weight used
   * when rendering the paintable.
   * 
   * @newin{4,22}
   *
   * Default value: -1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_weight() const;

  /** The current state of the renderer.
   * 
   * This can be a number between 0 and 63, or the special value
   * `(unsigned int) -1` to indicate the 'empty' state in which
   * nothing is drawn.
   * 
   * @newin{4,22}
   *
   * Default value: 4294967295
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< unsigned int > property_state() ;

/** The current state of the renderer.
   * 
   * This can be a number between 0 and 63, or the special value
   * `(unsigned int) -1` to indicate the 'empty' state in which
   * nothing is drawn.
   * 
   * @newin{4,22}
   *
   * Default value: 4294967295
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< unsigned int > property_state() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk

namespace Gtk
{

/** @ingroup gtkmmEnums */
inline constexpr Svg::Features operator|(Svg::Features lhs, Svg::Features rhs)
  { return static_cast<Svg::Features>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline constexpr Svg::Features operator&(Svg::Features lhs, Svg::Features rhs)
  { return static_cast<Svg::Features>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline constexpr Svg::Features operator^(Svg::Features lhs, Svg::Features rhs)
  { return static_cast<Svg::Features>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline constexpr Svg::Features operator~(Svg::Features flags)
  { return static_cast<Svg::Features>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline Svg::Features& operator|=(Svg::Features& lhs, Svg::Features rhs)
  { return (lhs = static_cast<Svg::Features>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline Svg::Features& operator&=(Svg::Features& lhs, Svg::Features rhs)
  { return (lhs = static_cast<Svg::Features>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline Svg::Features& operator^=(Svg::Features& lhs, Svg::Features rhs)
  { return (lhs = static_cast<Svg::Features>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }
} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GTKMM_API Value<Gtk::Svg::Features> : public Glib::Value_Flags<Gtk::Svg::Features>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Svg
   */
  GTKMM_API
  Glib::RefPtr<Gtk::Svg> wrap(GtkSvg* object, bool take_copy = false);
}


#endif /* _GTKMM_SVG_H */

