#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-pandoc-z-xml-light
version:              3.4
package-name:         pandoc
lib-name:             xml-light
id:                   pandoc-3.4-Gd2294sHMNK8Rr47FS9mrP-xml-light
key:                  pandoc-3.4-Gd2294sHMNK8Rr47FS9mrP-xml-light
license:              GPL-2.0-or-later
copyright:            (c) 2006-2024 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  29d7203adc09a942a21385fd21ecfc04
exposed-modules:
    Text.Pandoc.XML.Light Text.Pandoc.XML.Light.Output
    Text.Pandoc.XML.Light.Proc Text.Pandoc.XML.Light.Types

import-dirs:          /usr/lib/ghc-9.6.6/site-local/pandoc-3.4
library-dirs:         /usr/lib/ghc-9.6.6/site-local/pandoc-3.4
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/pandoc-3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.4-Gd2294sHMNK8Rr47FS9mrP-xml-light
depends:
    base-4.18.2.1 containers-0.6.7 text-2.0.2
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    xml-conduit-1.9.1.4-GIDamUBLjrqAkx7UMSJfmz
    xml-types-0.3.8-ISf6rjkeTjSFXsXdIGBwau

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pandoc
version:              3.4
visibility:           public
id:                   pandoc-3.4-8crF8V9foAeAZlGYbkGt7Y
key:                  pandoc-3.4-8crF8V9foAeAZlGYbkGt7Y
license:              GPL-2.0-or-later
copyright:            (c) 2006-2024 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  340999fd8bf7595f19044cdf3e394b0f
exposed:              True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.Chunks
    Text.Pandoc.Citeproc Text.Pandoc.Class Text.Pandoc.Class.IO
    Text.Pandoc.Data Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Filter Text.Pandoc.Format
    Text.Pandoc.Highlighting Text.Pandoc.ImageSize Text.Pandoc.Logging
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Process
    Text.Pandoc.Readers Text.Pandoc.Readers.BibTeX
    Text.Pandoc.Readers.CSV Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.Creole Text.Pandoc.Readers.CslJson
    Text.Pandoc.Readers.Djot Text.Pandoc.Readers.DocBook
    Text.Pandoc.Readers.Docx Text.Pandoc.Readers.DokuWiki
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.EndNote
    Text.Pandoc.Readers.FB2 Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.Ipynb
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.Jira
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.Man
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.ODT Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RIS
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.RTF
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Typst Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.Scripting Text.Pandoc.SelfContained Text.Pandoc.Shared
    Text.Pandoc.Slides Text.Pandoc.Sources Text.Pandoc.Templates
    Text.Pandoc.Transforms Text.Pandoc.Translations
    Text.Pandoc.Translations.Types Text.Pandoc.UTF8 Text.Pandoc.Version
    Text.Pandoc.Writers Text.Pandoc.Writers.ANSI
    Text.Pandoc.Writers.AnnotatedTable Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.BibTeX Text.Pandoc.Writers.ChunkedHTML
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.CslJson Text.Pandoc.Writers.Djot
    Text.Pandoc.Writers.DocBook Text.Pandoc.Writers.Docx
    Text.Pandoc.Writers.DokuWiki Text.Pandoc.Writers.EPUB
    Text.Pandoc.Writers.FB2 Text.Pandoc.Writers.HTML
    Text.Pandoc.Writers.Haddock Text.Pandoc.Writers.ICML
    Text.Pandoc.Writers.Ipynb Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.Jira Text.Pandoc.Writers.LaTeX
    Text.Pandoc.Writers.Man Text.Pandoc.Writers.Markdown
    Text.Pandoc.Writers.Math Text.Pandoc.Writers.MediaWiki
    Text.Pandoc.Writers.Ms Text.Pandoc.Writers.Muse
    Text.Pandoc.Writers.Native Text.Pandoc.Writers.ODT
    Text.Pandoc.Writers.OOXML Text.Pandoc.Writers.OPML
    Text.Pandoc.Writers.OpenDocument Text.Pandoc.Writers.Org
    Text.Pandoc.Writers.Powerpoint Text.Pandoc.Writers.RST
    Text.Pandoc.Writers.RTF Text.Pandoc.Writers.Shared
    Text.Pandoc.Writers.TEI Text.Pandoc.Writers.Texinfo
    Text.Pandoc.Writers.Textile Text.Pandoc.Writers.Typst
    Text.Pandoc.Writers.XWiki Text.Pandoc.Writers.ZimWiki
    Text.Pandoc.XML

hidden-modules:
    Text.Pandoc.App.CommandLineOptions Text.Pandoc.App.Input
    Text.Pandoc.App.Opt Text.Pandoc.App.OutputSettings
    Text.Pandoc.Class.CommonState Text.Pandoc.Class.PandocMonad
    Text.Pandoc.Class.PandocIO Text.Pandoc.Class.PandocPure
    Text.Pandoc.Class.Sandbox Text.Pandoc.Filter.Environment
    Text.Pandoc.Filter.JSON Text.Pandoc.Parsing.Capabilities
    Text.Pandoc.Parsing.Citations Text.Pandoc.Parsing.General
    Text.Pandoc.Parsing.GridTable Text.Pandoc.Parsing.Lists
    Text.Pandoc.Parsing.Math Text.Pandoc.Parsing.Smart
    Text.Pandoc.Parsing.State Text.Pandoc.Parsing.Future
    Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
    Text.Pandoc.Readers.Docx.Parse
    Text.Pandoc.Readers.Docx.Parse.Styles Text.Pandoc.Readers.Docx.Util
    Text.Pandoc.Readers.Docx.Symbols Text.Pandoc.Readers.Docx.Fields
    Text.Pandoc.Readers.HTML.Parsing Text.Pandoc.Readers.HTML.Table
    Text.Pandoc.Readers.HTML.TagCategories
    Text.Pandoc.Readers.HTML.Types Text.Pandoc.Readers.LaTeX.Inline
    Text.Pandoc.Readers.LaTeX.Citation Text.Pandoc.Readers.LaTeX.Lang
    Text.Pandoc.Readers.LaTeX.Macro Text.Pandoc.Readers.LaTeX.Math
    Text.Pandoc.Readers.LaTeX.Parsing Text.Pandoc.Readers.LaTeX.SIunitx
    Text.Pandoc.Readers.LaTeX.Table Text.Pandoc.Readers.Typst.Parsing
    Text.Pandoc.Readers.Typst.Math Text.Pandoc.Readers.ODT.Base
    Text.Pandoc.Readers.ODT.Namespaces
    Text.Pandoc.Readers.ODT.StyleReader
    Text.Pandoc.Readers.ODT.ContentReader
    Text.Pandoc.Readers.ODT.Generic.Fallible
    Text.Pandoc.Readers.ODT.Generic.SetMap
    Text.Pandoc.Readers.ODT.Generic.Utils
    Text.Pandoc.Readers.ODT.Generic.Namespaces
    Text.Pandoc.Readers.ODT.Generic.XMLConverter
    Text.Pandoc.Readers.ODT.Arrows.State
    Text.Pandoc.Readers.ODT.Arrows.Utils
    Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
    Text.Pandoc.Readers.Org.DocumentTree
    Text.Pandoc.Readers.Org.ExportSettings
    Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
    Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
    Text.Pandoc.Readers.Org.Shared Text.Pandoc.Readers.Metadata
    Text.Pandoc.Readers.Roff Text.Pandoc.Writers.Docx.OpenXML
    Text.Pandoc.Writers.Docx.StyleMap Text.Pandoc.Writers.Docx.Table
    Text.Pandoc.Writers.Docx.Types Text.Pandoc.Writers.GridTable
    Text.Pandoc.Writers.JATS.References Text.Pandoc.Writers.JATS.Table
    Text.Pandoc.Writers.JATS.Types Text.Pandoc.Writers.LaTeX.Caption
    Text.Pandoc.Writers.LaTeX.Notes Text.Pandoc.Writers.LaTeX.Table
    Text.Pandoc.Writers.LaTeX.Lang Text.Pandoc.Writers.LaTeX.Types
    Text.Pandoc.Writers.LaTeX.Citation Text.Pandoc.Writers.LaTeX.Util
    Text.Pandoc.Writers.Markdown.Table
    Text.Pandoc.Writers.Markdown.Types
    Text.Pandoc.Writers.Markdown.Inline Text.Pandoc.Writers.Roff
    Text.Pandoc.Writers.Blaze
    Text.Pandoc.Writers.Powerpoint.Presentation
    Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.Char
    Text.Pandoc.TeX Text.Pandoc.URI Text.Pandoc.CSS Text.Pandoc.CSV
    Text.Pandoc.RoffChar Text.Pandoc.UUID Text.Pandoc.Image
    Text.Pandoc.Citeproc.BibTeX Text.Pandoc.Citeproc.Name
    Text.Pandoc.Citeproc.CslJson Text.Pandoc.Citeproc.Data
    Text.Pandoc.Citeproc.Locator Text.Pandoc.Citeproc.MetaValue
    Text.Pandoc.Citeproc.Util Paths_pandoc

import-dirs:          /usr/lib/ghc-9.6.6/site-local/pandoc-3.4
library-dirs:         /usr/lib/ghc-9.6.6/site-local/pandoc-3.4
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/pandoc-3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.4-8crF8V9foAeAZlGYbkGt7Y
depends:
    Glob-0.10.2-2ocPujhthTrK7apkiFGGkz
    JuicyPixels-3.3.9-H92eO6ezoExCwYzjFHzAm7
    SHA-1.6.4.4-KRZJCS52poaHfqPlW5b8Sg
    aeson-2.1.2.1-JZeWX2s1eQL7Ta3HF3w6fW
    aeson-pretty-0.8.10-LBJ177aL2uN3HrqwVlBpw9 array-0.5.6.0
    attoparsec-0.14.4-K96akOPZKYDKXaMIGNQXgm base-4.18.2.1
    base64-bytestring-1.2.1.0-B0w0hfBZVmq3UW6lmjr7G binary-0.8.9.1
    blaze-html-0.9.2.0-LUjYdeknUl1Ef7LhdtXXgs
    blaze-markup-0.8.3.0-Donjg3mDQKIJPFMPJHNoUU bytestring-0.11.5.3
    case-insensitive-1.2.1.0-LnNRkIvaVf25YvATjz2MZ1
    citeproc-0.8.1.1-H7oyuffiFFDHUOwUQroraf
    commonmark-0.2.6.1-aSbfNCuh5C5ubY7ZqA8aC
    commonmark-extensions-0.2.5.5-IXB8Cr7D1YXL5WKedEyL4s
    commonmark-pandoc-0.2.2.3-D7874W6EL435Sqj7gRcjDk containers-0.6.7
    crypton-connection-0.4.5-IRXuN8rt5iD9iK3x9Ixu0j
    crypton-x509-system-1.6.7-Ft9fFVe6WEjD6Y0uH72qLv
    data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz deepseq-1.4.8.1
    directory-1.3.8.5 djot-0.1.2.3-9U3iapezP1KITJRDiK1BVZ
    doclayout-0.5-3uEvNcwSawAKaZhYDKWTsB
    doctemplates-0.11.0.1-4Oihfq7nLExBE82fNODnxN
    emojis-0.1.4.1-L7mOnPsQOMB2xPGhke4egp exceptions-0.10.7
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    gridtables-0.1.1.0-FqNwBe1i88u3jldvaFiCh1
    haddock-library-1.11.0-UMQ0TvguMWDP9DkSDZFwl
    http-client-0.7.19-KAsH6CgaLEPAFMwCgIBejb
    http-client-tls-0.3.6.4-JIwEy8eUUufD8fETx9XfAs
    http-types-0.12.4-Ab6499xPt6j7ocIybq2ygA
    ipynb-0.2-98FIYCms8hd4XImwnKxoJR
    jira-wiki-markup-1.5.1-AL9cUNYYENKHo3pTAHtmr9
    mime-types-0.1.2.0-2lnuHjhOzQ4DFNhuFJ9ART mtl-2.3.1
    network-3.1.4.0-DqImTC0JtBs7wAjAQOfbw6
    network-uri-2.6.4.2-4GU1spYfCy5EsCjKjgc97p
    pandoc-3.4-Gd2294sHMNK8Rr47FS9mrP-xml-light
    pandoc-types-1.23.1-ExyetKadj41IRCG9E6pUvm parsec-3.1.16.1
    pretty-1.1.3.6 pretty-show-1.10-EXsS4VwIV5tJ56gbmVdfrR
    process-1.6.19.0 random-1.2.1.3-AnjXBTm5XaC2u12cWBrzsX
    safe-0.3.21-EsRFO8M87PCEtDqVSuBNfo
    scientific-0.3.8.0-7SlgUkp6kxxBFUUY5SNCvh
    skylighting-0.14.3-8pv6NyUYkE84Mp4kiQeoYu
    skylighting-core-0.14.3-4OvtToZbATn9LjaZSROdF
    split-0.2.5-LIo01L9HFTI75RwsLzYVkn syb-0.7.3-7GPFF4ffw0kLXaCjDkD2wt
    tagsoup-0.14.8-C5zdnVYyiZc2uQ23ongVC7
    temporary-1.3-D64vl65CCuJL1VfIJwvdvy
    texmath-0.12.8.11-CQcL9LlSTtj76UOYC0rQfW text-2.0.2
    text-conversions-0.3.1.1-DzbT6snPMNb8LCZNfq5xEy time-1.12.2
    tls-2.0.6-G6rzAgmALmfESxoheKWYR8 typst-0.6-At6KNNo85ri4T7hQ0mtLny
    unicode-collation-0.1.3.6-7Ke4gk4oNL3HLdrIpN5ACF
    unicode-transforms-0.4.0.1-Belvegl8osM1X1Dierw4gy unix-2.8.4.0
    vector-0.13.2.0-JoP5POFPMLsLn1of7TvjGI
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    yaml-0.11.11.2-CS9jj0skP8B8obc9v5e4bH
    zip-archive-0.4.3.2-LZVIXJHNIlm9n9yyOiWrMh
    zlib-0.7.0.0-1ujaGtF2c5l6Jpv01tSCEr

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

