/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.inspections.YAMLDuplicatedKeysInspection;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/yaml/inspections/YAMLDuplicatedKeysInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "MergeDuplicatedSectionsQuickFix", "RemoveDuplicatedKeyQuickFix", "intellij.yaml.backend"})
public final class YAMLDuplicatedKeysInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new YamlPsiElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitMapping(YAMLMapping mapping) {
                Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
                MultiMap occurrences = new MultiMap();
                for (YAMLKeyValue keyValue : mapping.getKeyValues()) {
                    String keyName;
                    String $this$trim$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)keyValue.getKeyText(), (String)"getKeyText(...)");
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    if (Intrinsics.areEqual((Object)(keyName = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (Object)"<<") || ((CharSequence)keyName).length() == 0) continue;
                    occurrences.putValue((Object)keyName, (Object)keyValue);
                }
                for (Map.Entry entry : occurrences.entrySet()) {
                    LocalQuickFix[] localQuickFixArray;
                    boolean allLists;
                    boolean allObjects;
                    Collection value;
                    String key;
                    block14: {
                        boolean bl;
                        block13: {
                            Intrinsics.checkNotNull((Object)entry);
                            key = (String)entry.getKey();
                            value = (Collection)entry.getValue();
                            if (value.size() <= 1) continue;
                            Intrinsics.checkNotNull((Object)value);
                            Iterable $this$all$iv = value;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (T element$iv : $this$all$iv) {
                                    YAMLKeyValue it = (YAMLKeyValue)element$iv;
                                    boolean bl3 = false;
                                    if (it.getValue() instanceof YAMLMapping) continue;
                                    bl = false;
                                    break block13;
                                }
                                bl = true;
                            }
                        }
                        allObjects = bl;
                        Iterable $this$all$iv = value;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            v2 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                YAMLKeyValue it = (YAMLKeyValue)element$iv;
                                boolean bl4 = false;
                                if (it.getValue() instanceof YAMLSequence) continue;
                                v2 = false;
                                break block14;
                            }
                            v2 = allLists = true;
                        }
                    }
                    if (allObjects || allLists) {
                        var10_18 = new LocalQuickFix[]{new MergeDuplicatedSectionsQuickFix(), new RemoveDuplicatedKeyQuickFix()};
                        localQuickFixArray = var10_18;
                    } else {
                        var10_18 = new RemoveDuplicatedKeyQuickFix[]{new RemoveDuplicatedKeyQuickFix()};
                        localQuickFixArray = var10_18;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    value.forEach(arg_0 -> buildVisitor.1.visitMapping$lambda$3(this.$holder, key, fixes, arg_0));
                }
            }

            private static final void visitMapping$lambda$3(ProblemsHolder $holder, String $key, LocalQuickFix[] $fixes, YAMLKeyValue duplicatedKey) {
                Intrinsics.checkNotNullParameter((Object)duplicatedKey, (String)"duplicatedKey");
                if (duplicatedKey.getKey() == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                if (duplicatedKey.getParentMapping() == null) {
                    boolean bl = false;
                    String string = "This key is gotten from mapping";
                    throw new IllegalStateException(string.toString());
                }
                PsiElement psiElement = duplicatedKey.getKey();
                Intrinsics.checkNotNull((Object)psiElement);
                Object[] objectArray = new Object[]{$key};
                $holder.registerProblem(psiElement, YAMLBundle.message((String)"YAMLDuplicatedKeysInspection.duplicated.key", (Object[])objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf($fixes, $fixes.length));
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/yaml/inspections/YAMLDuplicatedKeysInspection$MergeDuplicatedSectionsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "mergeDuplicates", "generator", "Lorg/jetbrains/yaml/YAMLElementGenerator;", "keyVal", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "mergeMappings", "", "mapping", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "it", "mergeSequences", "sequence", "Lorg/jetbrains/yaml/psi/YAMLSequence;", "deleteWithPrecedingEol", "Lcom/intellij/psi/PsiElement;", "intellij.yaml.backend"})
    @SourceDebugExtension(value={"SMAP\nYAMLDuplicatedKeysInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAMLDuplicatedKeysInspection.kt\norg/jetbrains/yaml/inspections/YAMLDuplicatedKeysInspection$MergeDuplicatedSectionsQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n774#2:158\n865#2,2:159\n1869#2,2:161\n295#2,2:163\n1869#2,2:165\n1869#2:167\n1761#2,3:168\n1870#2:171\n*S KotlinDebug\n*F\n+ 1 YAMLDuplicatedKeysInspection.kt\norg/jetbrains/yaml/inspections/YAMLDuplicatedKeysInspection$MergeDuplicatedSectionsQuickFix\n*L\n71#1:158\n71#1:159,2\n75#1:161,2\n85#1:163,2\n95#1:165,2\n118#1:167\n120#1:168,3\n118#1:171\n*E\n"})
    private static final class MergeDuplicatedSectionsQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = YAMLBundle.message((String)"YAMLDuplicatedKeysInspection.merge.quickfix.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiElement psiElement = descriptor.getPsiElement().getParent();
            YAMLKeyValue yAMLKeyValue = psiElement instanceof YAMLKeyValue ? (YAMLKeyValue)psiElement : null;
            if (yAMLKeyValue == null) {
                return;
            }
            YAMLKeyValue keyVal = yAMLKeyValue;
            this.mergeDuplicates(new YAMLElementGenerator(project), keyVal);
        }

        /*
         * WARNING - void declaration
         */
        private final void mergeDuplicates(YAMLElementGenerator generator, YAMLKeyValue keyVal) {
            block16: {
                Object v5;
                block13: {
                    void $this$filterTo$iv$iv;
                    YAMLMapping yAMLMapping = keyVal.getParentMapping();
                    if (yAMLMapping == null) {
                        return;
                    }
                    YAMLMapping parentMapping = yAMLMapping;
                    String string = keyVal.getKeyText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeyText(...)");
                    String key = string;
                    Collection collection = parentMapping.getKeyValues();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeyValues(...)");
                    Iterable $this$filter$iv = collection;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        YAMLKeyValue it = (YAMLKeyValue)element$iv$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getKeyText(), (Object)key)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List allProps = (List)destination$iv$iv;
                    if (allProps.size() <= 1) {
                        return;
                    }
                    YAMLKeyValue firstProperty = (YAMLKeyValue)allProps.get(0);
                    boolean hadMerges = false;
                    Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)allProps, (int)1);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        YAMLKeyValue it;
                        block15: {
                            YAMLSequence sequence;
                            block14: {
                                it = (YAMLKeyValue)element$iv;
                                boolean bl = false;
                                YAMLValue bl2 = firstProperty.getValue();
                                YAMLMapping mapping = bl2 instanceof YAMLMapping ? (YAMLMapping)bl2 : null;
                                YAMLValue yAMLValue = firstProperty.getValue();
                                YAMLSequence yAMLSequence = sequence = yAMLValue instanceof YAMLSequence ? (YAMLSequence)yAMLValue : null;
                                if (mapping == null) break block14;
                                Intrinsics.checkNotNull((Object)it);
                                if (this.mergeMappings(mapping, it, generator)) break block15;
                            }
                            if (sequence == null) continue;
                            Intrinsics.checkNotNull((Object)it);
                            if (!this.mergeSequences(sequence, it, generator)) continue;
                        }
                        hadMerges = true;
                        this.deleteWithPrecedingEol((PsiElement)it);
                    }
                    if (!hadMerges) break block16;
                    Collection collection2 = parentMapping.getKeyValues();
                    Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getKeyValues(...)");
                    Iterable $this$firstOrNull$iv = collection2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        YAMLKeyValue it = (YAMLKeyValue)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getKeyText(), (Object)key)) continue;
                        v5 = element$iv;
                        break block13;
                    }
                    v5 = null;
                }
                YAMLKeyValue yAMLKeyValue = v5;
                if (yAMLKeyValue != null) {
                    YAMLKeyValue it = yAMLKeyValue;
                    boolean bl = false;
                    Editor editor = PsiEditorUtil.findEditor((PsiElement)((PsiElement)it));
                    if (editor != null && (editor = editor.getCaretModel()) != null) {
                        editor.moveToOffset(PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)it)));
                    }
                }
            }
        }

        private final boolean mergeMappings(YAMLMapping mapping, YAMLKeyValue it, YAMLElementGenerator generator) {
            YAMLValue yAMLValue = it.getValue();
            YAMLMapping yAMLMapping = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
            if (yAMLMapping == null) {
                return false;
            }
            YAMLMapping currentMapping = yAMLMapping;
            Collection collection = currentMapping.getKeyValues();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeyValues(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                YAMLKeyValue it2;
                YAMLKeyValue pp = (YAMLKeyValue)element$iv;
                boolean bl = false;
                if (mapping.getKeyValueByKey(pp.getKeyText()) != null) {
                    boolean bl2 = false;
                    YAMLValue yAMLValue2 = it2.getValue();
                    YAMLValue yAMLValue3 = pp.getValue();
                    if (Intrinsics.areEqual((Object)(yAMLValue2 != null ? yAMLValue2.getText() : null), (Object)(yAMLValue3 != null ? yAMLValue3.getText() : null))) continue;
                }
                if (pp.getValue() != null) {
                    YAMLKeyValue addedProp;
                    YAMLKeyValue newProp;
                    String string = pp.getName();
                    Intrinsics.checkNotNull((Object)string);
                    YAMLKeyValue p = it2 = generator.createYamlKeyValue(string, "foo");
                    boolean bl3 = false;
                    YAMLValue yAMLValue4 = p.getValue();
                    Intrinsics.checkNotNull((Object)yAMLValue4);
                    YAMLValue yAMLValue5 = pp.getValue();
                    Intrinsics.checkNotNull((Object)yAMLValue5);
                    yAMLValue4.replace((PsiElement)yAMLValue5);
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"also(...)");
                    PsiElement psiElement = generator.createEol();
                    Collection collection2 = mapping.getKeyValues();
                    Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getKeyValues(...)");
                    PsiElement eol = mapping.addAfter(psiElement, (PsiElement)CollectionsKt.last((Iterable)collection2));
                    PsiElement psiElement2 = mapping.addAfter((PsiElement)newProp, eol);
                    YAMLKeyValue yAMLKeyValue = addedProp = psiElement2 instanceof YAMLKeyValue ? (YAMLKeyValue)psiElement2 : null;
                    if (addedProp != null) {
                        boolean bl4 = false;
                        this.mergeDuplicates(generator, addedProp);
                    }
                }
                Intrinsics.checkNotNull((Object)pp);
                this.deleteWithPrecedingEol((PsiElement)pp);
            }
            return true;
        }

        private final boolean mergeSequences(YAMLSequence sequence, YAMLKeyValue it, YAMLElementGenerator generator) {
            YAMLValue yAMLValue = it.getValue();
            YAMLSequence yAMLSequence = yAMLValue instanceof YAMLSequence ? (YAMLSequence)yAMLValue : null;
            if (yAMLSequence == null) {
                return false;
            }
            YAMLSequence currentSequence = yAMLSequence;
            List list = currentSequence.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                YAMLSequenceItem pp = (YAMLSequenceItem)element$iv;
                boolean bl = false;
                if (pp.getValue() != null) {
                    YAMLSequenceItem newItem;
                    YAMLSequenceItem yAMLSequenceItem;
                    boolean bl2;
                    block6: {
                        List list2 = sequence.getItems();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
                        Iterable $this$any$iv = list2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            yAMLSequenceItem = $this$any$iv.iterator();
                            while (yAMLSequenceItem.hasNext()) {
                                Object element$iv2 = yAMLSequenceItem.next();
                                YAMLSequenceItem it2 = (YAMLSequenceItem)element$iv2;
                                boolean bl3 = false;
                                YAMLValue yAMLValue2 = it2.getValue();
                                YAMLValue yAMLValue3 = pp.getValue();
                                if (!Intrinsics.areEqual((Object)(yAMLValue2 != null ? yAMLValue2.getText() : null), (Object)(yAMLValue3 != null ? yAMLValue3.getText() : null))) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) continue;
                    YAMLSequenceItem p = yAMLSequenceItem = generator.createSequenceItem("foo");
                    boolean bl4 = false;
                    YAMLValue yAMLValue4 = p.getValue();
                    Intrinsics.checkNotNull((Object)yAMLValue4);
                    YAMLValue yAMLValue5 = pp.getValue();
                    Intrinsics.checkNotNull((Object)yAMLValue5);
                    yAMLValue4.replace((PsiElement)yAMLValue5);
                    Intrinsics.checkNotNullExpressionValue((Object)yAMLSequenceItem, (String)"also(...)");
                    PsiElement psiElement = generator.createEol();
                    List list3 = sequence.getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getItems(...)");
                    PsiElement eol = sequence.addAfter(psiElement, (PsiElement)CollectionsKt.last((List)list3));
                    sequence.addAfter((PsiElement)newItem, eol);
                }
                Intrinsics.checkNotNull((Object)pp);
                this.deleteWithPrecedingEol((PsiElement)pp);
            }
            return true;
        }

        private final void deleteWithPrecedingEol(PsiElement it) {
            PsiElement prevSibling = it.getPrevSibling();
            it.delete();
            if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)prevSibling), (Object)YAMLTokenTypes.EOL)) {
                prevSibling.delete();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/yaml/inspections/YAMLDuplicatedKeysInspection$RemoveDuplicatedKeyQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "availableInBatchMode", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.yaml.backend"})
    private static final class RemoveDuplicatedKeyQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = YAMLBundle.message((String)"YAMLDuplicatedKeysInspection.remove.key.quickfix.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                PsiElement psiElement = descriptor.getPsiElement().getParent();
                YAMLKeyValue yAMLKeyValue = psiElement instanceof YAMLKeyValue ? (YAMLKeyValue)psiElement : null;
                if (yAMLKeyValue == null) {
                    return;
                }
                YAMLKeyValue keyVal = yAMLKeyValue;
                YAMLMapping yAMLMapping = keyVal.getParentMapping();
                if (yAMLMapping == null) break block1;
                yAMLMapping.deleteKeyValue(keyVal);
            }
        }
    }
}

