/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.semconv.network.internal;

import io.opentelemetry.instrumentation.api.semconv.network.ServerAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;

public final class ServerAddressAndPortExtractor<REQUEST>
implements AddressAndPortExtractor<REQUEST> {
    private final ServerAttributesGetter<REQUEST> getter;
    private final AddressAndPortExtractor<REQUEST> fallbackAddressAndPortExtractor;

    public ServerAddressAndPortExtractor(ServerAttributesGetter<REQUEST> getter, AddressAndPortExtractor<REQUEST> fallbackAddressAndPortExtractor) {
        this.getter = getter;
        this.fallbackAddressAndPortExtractor = fallbackAddressAndPortExtractor;
    }

    @Override
    public void extract(AddressAndPortExtractor.AddressPortSink sink, REQUEST request) {
        String address = this.getter.getServerAddress(request);
        Integer port = this.getter.getServerPort(request);
        if (address == null && port == null) {
            this.fallbackAddressAndPortExtractor.extract(sink, request);
        } else {
            sink.setAddress(address);
            sink.setPort(port);
        }
    }
}

