/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public final class EagerSecurityInterceptorMethodsBuildItem
extends MultiBuildItem {
    final Map<String, List<MethodInfo>> bindingValueToInterceptedMethods;
    final DotName interceptorBinding;
    private final boolean requiresSecurityCheck;

    EagerSecurityInterceptorMethodsBuildItem(Map<String, List<MethodInfo>> bindingValueToInterceptedMethods, DotName interceptorBinding, boolean requiresSecurityCheck) {
        this.bindingValueToInterceptedMethods = Map.copyOf(bindingValueToInterceptedMethods);
        this.interceptorBinding = interceptorBinding;
        this.requiresSecurityCheck = requiresSecurityCheck;
    }

    private Stream<MethodInfo> interceptedMethods() {
        return this.bindingValueToInterceptedMethods.values().stream().flatMap(Collection::stream);
    }

    public static Map<MethodInfo, Boolean> collectInterceptedMethods(List<EagerSecurityInterceptorMethodsBuildItem> items) {
        HashMap<MethodInfo, Boolean> result = new HashMap<MethodInfo, Boolean>();
        for (EagerSecurityInterceptorMethodsBuildItem item : items) {
            item.interceptedMethods().forEach(mi -> {
                if (result.containsKey(mi)) {
                    Boolean requiresCheck = (Boolean)result.get(mi);
                    if (!requiresCheck.booleanValue() && item.requiresSecurityCheck) {
                        result.put((MethodInfo)mi, true);
                    }
                } else {
                    result.put((MethodInfo)mi, item.requiresSecurityCheck);
                }
            });
        }
        return result;
    }
}

