/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.MappingNotFoundException;
import org.hibernate.boot.jaxb.JaxbLogger;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.internal.InputStreamXmlSource;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.jaxb.spi.JaxbBindableMappingDescriptor;

public class JarFileEntryXmlSource {
    public static void fromJar(File jar, MappingBinder mappingBinder, Consumer<Binding<? extends JaxbBindableMappingDescriptor>> consumer) {
        JaxbLogger.JAXB_LOGGER.tracef("Seeking mapping documents in jar file: %s", jar.getName());
        Origin origin = new Origin(SourceType.JAR, jar.getAbsolutePath());
        try (JarFile jarFile = new JarFile(jar);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!jarEntry.getName().endsWith(".hbm.xml")) continue;
                JaxbLogger.JAXB_LOGGER.tracef("Found 'hbm.xml' mapping in jar: %s", jarEntry.getName());
                consumer.accept(JarFileEntryXmlSource.fromJarEntry(jarFile, jarEntry, origin, mappingBinder));
            }
        }
        catch (IOException e) {
            throw new MappingNotFoundException(e, origin);
        }
    }

    public static Binding<? extends JaxbBindableMappingDescriptor> fromJarEntry(JarFile jarFile, ZipEntry jarFileEntry, Origin origin, MappingBinder mappingBinder) {
        InputStream stream;
        try {
            stream = jarFile.getInputStream(jarFileEntry);
        }
        catch (IOException e) {
            throw new MappingException(String.format("Unable to open InputStream for jar file entry [%s : %s]", jarFile.getName(), jarFileEntry.getName()), e, origin);
        }
        return InputStreamXmlSource.fromStream(stream, origin, true, mappingBinder);
    }
}

