/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import oracle.ons.Node;
import oracle.ons.NodeAddress;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONSConfiguration;

public class ONSConnection {
    private NodeAddress baseAddress;
    private ONSConfiguration.NodeList baseNodeList;
    private static final int STATE_IDLE = 0;
    private static final int STATE_CONNECTING = 1;
    private static final int STATE_CONNECTED = 2;

    ONSConnection(NodeAddress nodeAddress, ONSConfiguration.NodeList nodeList) {
        this.baseAddress = nodeAddress;
        this.baseNodeList = nodeList;
    }

    public String getId() {
        return this.baseAddress.toString();
    }

    public String getHost() {
        return this.baseAddress.hostname;
    }

    public int getPort() {
        return this.baseAddress.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        int n = 0;
        NotificationNetwork notificationNetwork = this.baseNodeList.config.getNetwork();
        synchronized (notificationNetwork) {
            for (Node node : this.baseNodeList.connected) {
                if (!node.getAddress().equals(this.baseAddress)) continue;
                n = 2;
                break;
            }
            if (n == 0) {
                for (Node node : this.baseNodeList.pending) {
                    if (!node.getAddress().equals(this.baseAddress)) continue;
                    n = 1;
                    break;
                }
            }
        }
        return n;
    }

    public static String getStateString(int n) {
        String string = n == 2 ? "connected" : (n == 1 ? "connecting" : "idle");
        return string;
    }
}

