/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.OraclePreparedStatement;

class CopiedNullBinder
extends Binder {
    CopiedNullBinder(short type, int bytelen) {
        this.type = type;
        this.bytelen = bytelen;
    }

    @Override
    Binder copyingBinder() {
        return this;
    }

    @Override
    boolean isCopying() {
        return true;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        bindIndicators[indoffset] = -1;
        if (bindUseDBA) {
            bindDataOffsets[bindDataIndex] = 0L;
            bindDataLengths[bindDataIndex] = 0;
        }
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length);
        }
        return localCheckSum;
    }
}

