/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.action;

import java.io.IOException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.TransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.rule.RulePersistenceService;
import org.opensearch.rule.RulePersistenceServiceRegistry;
import org.opensearch.rule.RuleRoutingServiceRegistry;
import org.opensearch.rule.action.CreateRuleRequest;
import org.opensearch.rule.action.CreateRuleResponse;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportService;

public class TransportCreateRuleAction
extends TransportAction<CreateRuleRequest, CreateRuleResponse> {
    private final ThreadPool threadPool;
    private final RuleRoutingServiceRegistry ruleRoutingServiceRegistry;
    private final RulePersistenceServiceRegistry rulePersistenceServiceRegistry;

    @Inject
    public TransportCreateRuleAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, RulePersistenceServiceRegistry rulePersistenceServiceRegistry, RuleRoutingServiceRegistry ruleRoutingServiceRegistry) {
        super("cluster:admin/opensearch/rule/_create", actionFilters, transportService.getTaskManager());
        this.ruleRoutingServiceRegistry = ruleRoutingServiceRegistry;
        this.threadPool = threadPool;
        this.rulePersistenceServiceRegistry = rulePersistenceServiceRegistry;
        transportService.registerRequestHandler("cluster:admin/opensearch/rule/_create", "same", CreateRuleRequest::new, (TransportRequestHandler)new TransportRequestHandler<CreateRuleRequest>(){

            public void messageReceived(CreateRuleRequest request, TransportChannel channel, Task task) {
                TransportCreateRuleAction.this.executeLocally(request, (ActionListener<CreateRuleResponse>)ActionListener.wrap(response -> {
                    try {
                        channel.sendResponse((TransportResponse)response);
                    }
                    catch (IOException e) {
                        TransportCreateRuleAction.this.logger.error("Failed to send CreateRuleResponse to transport channel", (Throwable)e);
                        throw new TransportException("Fail to send", (Throwable)e);
                    }
                }, exception -> {
                    try {
                        channel.sendResponse(exception);
                    }
                    catch (IOException e) {
                        TransportCreateRuleAction.this.logger.error("Failed to send exception response to transport channel", (Throwable)e);
                        throw new TransportException("Fail to send", (Throwable)e);
                    }
                }));
            }
        });
    }

    protected void doExecute(Task task, CreateRuleRequest request, ActionListener<CreateRuleResponse> listener) {
        this.ruleRoutingServiceRegistry.getRuleRoutingService(request.getRule().getFeatureType()).handleCreateRuleRequest(request, listener);
    }

    private void executeLocally(CreateRuleRequest request, ActionListener<CreateRuleResponse> listener) {
        this.threadPool.executor("rule_serial_executor").execute(() -> {
            RulePersistenceService rulePersistenceService = this.rulePersistenceServiceRegistry.getRulePersistenceService(request.getRule().getFeatureType());
            rulePersistenceService.createRule(request, listener);
        });
    }
}

