/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.hadoop.metrics2.util.MBeans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsLoggerTask
implements Runnable {
    public static final Logger LOG = LoggerFactory.getLogger(MetricsLoggerTask.class);
    private static ObjectName objectName = null;
    private Logger metricsLog;
    private String nodeName;
    private short maxLogLineLength;

    public MetricsLoggerTask(String metricsLog, String nodeName, short maxLogLineLength) {
        this.metricsLog = LoggerFactory.getLogger((String)metricsLog);
        this.nodeName = nodeName;
        this.maxLogLineLength = maxLogLineLength;
    }

    @Override
    public void run() {
        if (!this.metricsLog.isInfoEnabled() || !MetricsLoggerTask.hasAppenders(this.metricsLog) || objectName == null) {
            return;
        }
        this.metricsLog.info(" >> Begin " + this.nodeName + " metrics dump");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (ObjectName mbeanName : server.queryNames(objectName, null)) {
            try {
                MBeanInfo mBeanInfo = server.getMBeanInfo(mbeanName);
                String mBeanNameName = MBeans.getMbeanNameName((ObjectName)mbeanName);
                Set<String> attributeNames = MetricsLoggerTask.getFilteredAttributes(mBeanInfo);
                AttributeList attributes = server.getAttributes(mbeanName, attributeNames.toArray(new String[attributeNames.size()]));
                for (Object o : attributes) {
                    Attribute attribute = (Attribute)o;
                    Object value = attribute.getValue();
                    String valueStr = value != null ? value.toString() : "null";
                    this.metricsLog.info(mBeanNameName + ":" + attribute.getName() + "=" + this.trimLine(valueStr));
                }
            }
            catch (Exception e) {
                this.metricsLog.error("Failed to get " + this.nodeName + " metrics for mbean " + mbeanName.toString(), (Throwable)e);
            }
        }
        this.metricsLog.info(" << End " + this.nodeName + " metrics dump");
    }

    private String trimLine(String valueStr) {
        if (this.maxLogLineLength <= 0) {
            return valueStr;
        }
        return valueStr.length() < this.maxLogLineLength ? valueStr : valueStr.substring(0, this.maxLogLineLength) + "...";
    }

    private static boolean hasAppenders(Logger logger) {
        return org.apache.log4j.Logger.getLogger((String)logger.getName()).getAllAppenders().hasMoreElements();
    }

    private static Set<String> getFilteredAttributes(MBeanInfo mBeanInfo) {
        HashSet<String> attributeNames = new HashSet<String>();
        for (MBeanAttributeInfo attributeInfo : mBeanInfo.getAttributes()) {
            if (attributeInfo.getType().equals("javax.management.openmbean.TabularData") || attributeInfo.getType().equals("javax.management.openmbean.CompositeData") || attributeInfo.getType().equals("[Ljavax.management.openmbean.CompositeData;")) continue;
            attributeNames.add(attributeInfo.getName());
        }
        return attributeNames;
    }

    static {
        try {
            objectName = new ObjectName("Hadoop:*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

