/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.writer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONAwareEx;
import net.minidev.json.JSONObject;
import net.minidev.json.writer.ArraysMapper;
import net.minidev.json.writer.BeansMapper;
import net.minidev.json.writer.CollectionMapper;
import net.minidev.json.writer.DefaultMapper;
import net.minidev.json.writer.DefaultMapperCollection;
import net.minidev.json.writer.DefaultMapperOrdered;
import net.minidev.json.writer.JsonReaderI;
import net.minidev.json.writer.MapperRemapped;

public class JsonReader {
    private final ConcurrentHashMap<Type, JsonReaderI<?>> cache = new ConcurrentHashMap(100);
    public JsonReaderI<JSONAwareEx> DEFAULT;
    public JsonReaderI<JSONAwareEx> DEFAULT_ORDERED;

    public JsonReader() {
        this.cache.put((Type)((Object)Date.class), BeansMapper.MAPPER_DATE);
        this.cache.put((Type)((Object)int[].class), ArraysMapper.MAPPER_PRIM_INT);
        this.cache.put((Type)((Object)Integer[].class), ArraysMapper.MAPPER_INT);
        this.cache.put((Type)((Object)short[].class), ArraysMapper.MAPPER_PRIM_INT);
        this.cache.put((Type)((Object)Short[].class), ArraysMapper.MAPPER_INT);
        this.cache.put((Type)((Object)long[].class), ArraysMapper.MAPPER_PRIM_LONG);
        this.cache.put((Type)((Object)Long[].class), ArraysMapper.MAPPER_LONG);
        this.cache.put((Type)((Object)byte[].class), ArraysMapper.MAPPER_PRIM_BYTE);
        this.cache.put((Type)((Object)Byte[].class), ArraysMapper.MAPPER_BYTE);
        this.cache.put((Type)((Object)char[].class), ArraysMapper.MAPPER_PRIM_CHAR);
        this.cache.put((Type)((Object)Character[].class), ArraysMapper.MAPPER_CHAR);
        this.cache.put((Type)((Object)float[].class), ArraysMapper.MAPPER_PRIM_FLOAT);
        this.cache.put((Type)((Object)Float[].class), ArraysMapper.MAPPER_FLOAT);
        this.cache.put((Type)((Object)double[].class), ArraysMapper.MAPPER_PRIM_DOUBLE);
        this.cache.put((Type)((Object)Double[].class), ArraysMapper.MAPPER_DOUBLE);
        this.cache.put((Type)((Object)boolean[].class), ArraysMapper.MAPPER_PRIM_BOOL);
        this.cache.put((Type)((Object)Boolean[].class), ArraysMapper.MAPPER_BOOL);
        this.DEFAULT = new DefaultMapper<JSONAwareEx>(this);
        this.DEFAULT_ORDERED = new DefaultMapperOrdered(this);
        this.cache.put((Type)((Object)JSONAwareEx.class), this.DEFAULT);
        this.cache.put((Type)((Object)JSONAware.class), this.DEFAULT);
        this.cache.put((Type)((Object)JSONArray.class), this.DEFAULT);
        this.cache.put((Type)((Object)JSONObject.class), this.DEFAULT);
    }

    public <T> void remapField(Class<T> type2, String fromJson, String toJava) {
        JsonReaderI<T> map = this.getMapper(type2);
        if (!(map instanceof MapperRemapped)) {
            map = new MapperRemapped<T>(map);
            this.registerReader(type2, map);
        }
        ((MapperRemapped)map).renameField(fromJson, toJava);
    }

    public <T> void registerReader(Class<T> type2, JsonReaderI<T> mapper) {
        this.cache.put(type2, mapper);
    }

    public <T> JsonReaderI<T> getMapper(Type type2) {
        if (type2 instanceof ParameterizedType) {
            return this.getMapper((ParameterizedType)type2);
        }
        return this.getMapper((Class)type2);
    }

    public <T> JsonReaderI<T> getMapper(Class<T> type2) {
        JsonReaderI map = this.cache.get(type2);
        if (map != null) {
            return map;
        }
        if (type2 instanceof Class) {
            if (Map.class.isAssignableFrom(type2)) {
                map = new DefaultMapperCollection(this, type2);
            } else if (List.class.isAssignableFrom(type2)) {
                map = new DefaultMapperCollection(this, type2);
            }
            if (map != null) {
                this.cache.put(type2, map);
                return map;
            }
        }
        map = type2.isArray() ? new ArraysMapper.GenericMapper(this, type2) : (List.class.isAssignableFrom(type2) ? new CollectionMapper.ListClass(this, type2) : (Map.class.isAssignableFrom(type2) ? new CollectionMapper.MapClass(this, type2) : new BeansMapper.Bean(this, type2)));
        this.cache.putIfAbsent(type2, map);
        return map;
    }

    public <T> JsonReaderI<T> getMapper(ParameterizedType type2) {
        JsonReaderI<?> map = this.cache.get(type2);
        if (map != null) {
            return map;
        }
        Class clz = (Class)type2.getRawType();
        if (List.class.isAssignableFrom(clz)) {
            map = new CollectionMapper.ListType(this, type2);
        } else if (Map.class.isAssignableFrom(clz)) {
            map = new CollectionMapper.MapType(this, type2);
        }
        this.cache.putIfAbsent(type2, map);
        return map;
    }
}

