/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Sets;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.requirementsTxt.PythonRequirementTxtSdkUtils;
import com.jetbrains.python.packaging.requirementsTxt.PythonRequirementsTxtManager;
import com.jetbrains.python.packaging.setupPy.SetupPyHelpers;
import com.jetbrains.python.packaging.setupPy.SetupPyManager;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.sdk.CredentialsTypeExChecker;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.flavors.conda.CondaEnvSdkFlavor;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import com.jetbrains.python.target.targetWithVfs.TargetWithMappedLocalVfs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PyPackageUtil {
    public static final String SETUPTOOLS = "setuptools";
    public static final String PIP = "pip";
    public static final String DISTRIBUTE = "distribute";
    private static final Logger LOG = Logger.getInstance(PyPackageUtil.class);

    private PyPackageUtil() {
    }

    public static boolean hasSetupPy(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(0);
        }
        return PyPackageUtil.findSetupPy(module2) != null;
    }

    @ApiStatus.Internal
    @Nullable
    public static VirtualFile findSetupPyFile(@NotNull Module module2) {
        Sdk sdk2;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(1);
        }
        if ((sdk2 = PythonSdkUtil.findPythonSdk((Module)module2)) == null) {
            return null;
        }
        return SetupPyManager.getInstance(module2.getProject(), sdk2).getDependenciesFile();
    }

    @Nullable
    public static PyFile findSetupPy(@NotNull Module module2) {
        Sdk sdk2;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(2);
        }
        if ((sdk2 = PythonSdkUtil.findPythonSdk((Module)module2)) == null) {
            return SetupPyHelpers.detectSetupPyInModule(module2);
        }
        return SetupPyManager.getInstance(module2.getProject(), sdk2).getRequirementsPsiFile();
    }

    public static boolean hasRequirementsTxt(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(3);
        }
        return PyPackageUtil.findRequirementsTxt(module2) != null;
    }

    @Nullable
    public static VirtualFile findRequirementsTxt(@NotNull Module module2) {
        Sdk sdk2;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(4);
        }
        if ((sdk2 = PythonSdkUtil.findPythonSdk((Module)module2)) == null) {
            return PythonRequirementTxtSdkUtils.detectRequirementsTxtInModule(module2);
        }
        return PythonRequirementsTxtManager.getInstance(module2.getProject(), sdk2).getDependenciesFile();
    }

    @RequiresReadLock(generateAssertion=false)
    @Nullable
    public static List<PyRequirement> getRequirementsFromTxt(@NotNull Module module2) {
        Sdk sdk2;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(5);
        }
        if ((sdk2 = PythonSdkUtil.findPythonSdk((Module)module2)) == null) {
            return null;
        }
        return PythonRequirementsTxtManager.getInstance(module2.getProject(), sdk2).getDependencies();
    }

    @Nullable
    public static List<PyRequirement> findSetupPyRequires(@NotNull Module module2) {
        Sdk sdk2;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(6);
        }
        if ((sdk2 = PythonSdkUtil.findPythonSdk((Module)module2)) == null) {
            return null;
        }
        return SetupPyManager.getInstance(module2.getProject(), sdk2).getDependencies();
    }

    @Nullable
    public static Map<String, List<PyRequirement>> findSetupPyExtrasRequire(@NotNull Module module2) {
        Sdk sdk2;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(7);
        }
        if ((sdk2 = PythonSdkUtil.findPythonSdk((Module)module2)) == null) {
            return null;
        }
        PyFile pyFile = SetupPyManager.getInstance(module2.getProject(), sdk2).getRequirementsPsiFile();
        if (pyFile == null) {
            return null;
        }
        return SetupPyHelpers.findSetupPyExtrasRequire(pyFile);
    }

    @NotNull
    public static List<String> getPackageNames(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(8);
        }
        ArrayList<String> packageNames = new ArrayList<String>();
        Project project = module2.getProject();
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module2).getSourceRoots();
        if (roots.length == 0) {
            roots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        }
        for (VirtualFile root : roots) {
            PyPackageUtil.collectPackageNames(project, root, packageNames);
        }
        ArrayList<String> arrayList = packageNames;
        if (arrayList == null) {
            PyPackageUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public static String requirementsToString(@NotNull List<? extends PyRequirement> requirements) {
        if (requirements == null) {
            PyPackageUtil.$$$reportNull$$$0(10);
        }
        String string = StringUtil.join(requirements, requirement -> String.format("'%s'", requirement.getPresentableText()), (String)", ");
        if (string == null) {
            PyPackageUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static PyCallExpression findSetupCall(@NotNull Module module2) {
        PyFile pyFile;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(12);
        }
        if ((pyFile = PyPackageUtil.findSetupPy(module2)) == null) {
            return null;
        }
        return SetupPyHelpers.findSetupCall(pyFile);
    }

    private static void collectPackageNames(@NotNull Project project, final @NotNull VirtualFile root, final @NotNull List<String> results) {
        if (project == null) {
            PyPackageUtil.$$$reportNull$$$0(13);
        }
        if (root == null) {
            PyPackageUtil.$$$reportNull$$$0(14);
        }
        if (results == null) {
            PyPackageUtil.$$$reportNull$$$0(15);
        }
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file.equals(root)) {
                    return true;
                }
                if (!fileIndex.isExcluded(file) && file.isDirectory() && file.findChild("__init__.py") != null) {
                    results.add(VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'.'));
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/packaging/PyPackageUtil$1", "visitFile"));
            }
        });
    }

    public static boolean packageManagementEnabled(@Nullable Sdk sdk2, boolean newUi, boolean calledFromInspection) {
        PythonSdkAdditionalData data;
        if (sdk2 == null) {
            return false;
        }
        PythonSdkAdditionalData pythonSdkAdditionalData = data = calledFromInspection ? (PythonSdkAdditionalData)ObjectUtils.tryCast((Object)sdk2.getSdkAdditionalData(), PythonSdkAdditionalData.class) : PySdkExtKt.getOrCreateAdditionalData(sdk2);
        if (!newUi && data != null && data.getFlavor() instanceof CondaEnvSdkFlavor && PySdkExtKt.getTargetEnvConfiguration(sdk2) != null) {
            LOG.warn("Remote Conda package manager is disabled");
            return false;
        }
        Boolean supported = PythonInterpreterTargetEnvironmentFactory.isPackageManagementSupported(sdk2);
        if (supported != null) {
            return supported;
        }
        if (!PythonSdkUtil.isRemote((Sdk)sdk2)) {
            return true;
        }
        return new CredentialsTypeExChecker(){

            @Override
            protected boolean checkLanguageContribution(PyCredentialsContribution languageContribution) {
                return languageContribution.isPackageManagementEnabled();
            }
        }.check(sdk2);
    }

    public static void addRequirementToTxtOrSetupPy(@NotNull Module module2, @NotNull String requirementName, @NotNull LanguageLevel languageLevel) {
        Sdk sdk2;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(16);
        }
        if (requirementName == null) {
            PyPackageUtil.$$$reportNull$$$0(17);
        }
        if (languageLevel == null) {
            PyPackageUtil.$$$reportNull$$$0(18);
        }
        if ((sdk2 = PythonSdkUtil.findPythonSdk((Module)module2)) == null) {
            return;
        }
        boolean isSuccess = PythonRequirementsTxtManager.getInstance(module2.getProject(), sdk2).addDependency(requirementName);
        if (isSuccess) {
            return;
        }
        SetupPyManager.getInstance(module2.getProject(), sdk2).addDependency(requirementName);
    }

    public static void runOnChangeUnderInterpreterPaths(final @NotNull Sdk sdk2, @NotNull Disposable parentDisposable, final @NotNull Runnable runnable) {
        if (sdk2 == null) {
            PyPackageUtil.$$$reportNull$$$0(19);
        }
        if (parentDisposable == null) {
            PyPackageUtil.$$$reportNull$$$0(20);
        }
        if (runnable == null) {
            PyPackageUtil.$$$reportNull$$$0(21);
        }
        final Application app = ApplicationManager.getApplication();
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){

            @Nullable
            public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (sdk2 instanceof Disposable && Disposer.isDisposed((Disposable)((Disposable)sdk2))) {
                    throw new AlreadyDisposedException("SDK " + String.valueOf(sdk2) + " (" + String.valueOf(sdk2.getClass()) + ") is already disposed");
                }
                Set<VirtualFile> roots = PyPackageUtil.getPackagingAwareSdkRoots(sdk2);
                if (roots.isEmpty()) {
                    return null;
                }
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileContentChangeEvent || vFileEvent instanceof VFilePropertyChangeEvent) continue;
                    VirtualFile parent = null;
                    if (vFileEvent instanceof VFileCreateEvent) {
                        parent = ((VFileCreateEvent)vFileEvent).getParent();
                    } else {
                        VirtualFile file = vFileEvent.getFile();
                        if (file != null) {
                            parent = file.getParent();
                        }
                    }
                    if (parent == null || !roots.contains(parent)) continue;
                    InterpreterChangeEvents.LOG.debug("Interpreter change in " + String.valueOf(parent) + " indicated by " + String.valueOf(vFileEvent) + " (all events: " + String.valueOf(events) + ")");
                    app.executeOnPooledThread(runnable);
                    break;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/python/packaging/PyPackageUtil$3", "prepareChange"));
            }
        }, parentDisposable);
    }

    @NotNull
    private static Set<VirtualFile> getPackagingAwareSdkRoots(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PyPackageUtil.$$$reportNull$$$0(22);
        }
        HashSet result2 = Sets.newHashSet((Object[])sdk2.getRootProvider().getFiles(OrderRootType.CLASSES));
        PyTargetAwareAdditionalData targetAdditionalData = PySdkExtKt.getTargetAdditionalData(sdk2);
        if (targetAdditionalData != null) {
            for (Map.Entry<VirtualFile, VirtualFile> remoteSourceToVfs : PyPackageUtil.getRemoteSourceToVfsMapping(targetAdditionalData).entrySet()) {
                if (!result2.contains(remoteSourceToVfs.getKey())) continue;
                result2.add(remoteSourceToVfs.getValue());
            }
        }
        String skeletonsPath = PythonSdkUtil.getSkeletonsPath((String)PathManager.getSystemPath(), (String)sdk2.getHomePath());
        VirtualFile skeletonsRoot = LocalFileSystem.getInstance().findFileByPath(skeletonsPath);
        result2.removeIf(vf -> vf.equals(skeletonsRoot) || PyTypeShed.INSTANCE.isInside(vf));
        HashSet hashSet = result2;
        if (hashSet == null) {
            PyPackageUtil.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    @NotNull
    private static @NotNull Map<@NotNull VirtualFile, @NotNull VirtualFile> getRemoteSourceToVfsMapping(@NotNull PyTargetAwareAdditionalData additionalData) {
        TargetEnvironmentConfiguration configuration;
        if (additionalData == null) {
            PyPackageUtil.$$$reportNull$$$0(24);
        }
        if ((configuration = additionalData.getTargetEnvironmentConfiguration()) == null) {
            Map<VirtualFile, VirtualFile> map2 = Collections.emptyMap();
            if (map2 == null) {
                PyPackageUtil.$$$reportNull$$$0(25);
            }
            return map2;
        }
        TargetWithMappedLocalVfs vfsMapper = PythonInterpreterTargetEnvironmentFactory.getTargetWithMappedLocalVfs(configuration);
        if (vfsMapper == null) {
            Map<VirtualFile, VirtualFile> map3 = Collections.emptyMap();
            if (map3 == null) {
                PyPackageUtil.$$$reportNull$$$0(26);
            }
            return map3;
        }
        LocalFileSystem vfs = LocalFileSystem.getInstance();
        HashMap<VirtualFile, VirtualFile> result2 = new HashMap<VirtualFile, VirtualFile>();
        for (Pair remoteSourceAndVfs : ContainerUtil.map((Collection)additionalData.getPathMappings().getPathMappings(), m -> Pair.create((Object)vfs.findFileByPath(m.getLocalRoot()), (Object)vfsMapper.getVfsFromTargetPath(m.getRemoteRoot())))) {
            VirtualFile remoteSourceDir = (VirtualFile)remoteSourceAndVfs.first;
            VirtualFile vfsDir = (VirtualFile)remoteSourceAndVfs.second;
            if (remoteSourceDir == null || vfsDir == null) continue;
            result2.put(remoteSourceDir, vfsDir);
        }
        HashMap<VirtualFile, VirtualFile> hashMap = result2;
        if (hashMap == null) {
            PyPackageUtil.$$$reportNull$$$0(27);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11, 23, 25, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: 
            case 11: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "requirementsToString";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagingAwareSdkRoots";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSourceToVfsMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasSetupPy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSetupPyFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSetupPy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasRequirementsTxt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRequirementsTxt";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRequirementsFromTxt";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findSetupPyRequires";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSetupPyExtrasRequire";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNames";
                break;
            }
            case 9: 
            case 11: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "requirementsToString";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findSetupCall";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectPackageNames";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addRequirementToTxtOrSetupPy";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "runOnChangeUnderInterpreterPaths";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPackagingAwareSdkRoots";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSourceToVfsMapping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11, 23, 25, 26, 27 -> new IllegalStateException(string);
        };
    }

    private static class InterpreterChangeEvents {
        private static final Logger LOG = Logger.getInstance(InterpreterChangeEvents.class);

        private InterpreterChangeEvents() {
        }
    }
}

