/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.operation;

import java.util.ArrayList;
import java.util.Collection;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.command.text.operation.OperationCommand;
import schemacrawler.tools.command.text.operation.options.OperationOptions;
import schemacrawler.tools.command.text.operation.options.OperationOptionsBuilder;
import schemacrawler.tools.command.text.operation.options.OperationType;
import schemacrawler.tools.command.text.operation.options.OperationsOutputFormat;
import schemacrawler.tools.executable.BaseCommandProvider;
import schemacrawler.tools.executable.CommandOptions;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import us.fatehi.utility.property.PropertyName;

public final class OperationCommandProvider
extends BaseCommandProvider {
    private static Collection<PropertyName> operationCommands() {
        ArrayList<PropertyName> supportedCommands = new ArrayList<PropertyName>();
        for (OperationType operation : OperationType.values()) {
            supportedCommands.add(new PropertyName(operation.name(), operation.getDescription()));
        }
        return supportedCommands;
    }

    public OperationCommandProvider() {
        super(OperationCommandProvider.operationCommands());
    }

    public OperationCommand newSchemaCrawlerCommand(String command, Config config) {
        PropertyName commandName = this.isNamedQuery(command, config) ? new PropertyName(command) : this.lookupSupportedCommand(command);
        if (commandName == null) {
            throw new IllegalArgumentException("Cannot support command, " + command);
        }
        OperationOptions operationOptions = OperationOptionsBuilder.builder().withCommand(command).fromConfig(config).toOptions();
        OperationCommand scCommand = new OperationCommand(commandName);
        scCommand.configure((CommandOptions)operationOptions);
        return scCommand;
    }

    public boolean supportsOutputFormat(String command, OutputOptions outputOptions) {
        return this.supportsOutputFormat(command, outputOptions, OperationsOutputFormat::isSupportedFormat);
    }

    public PluginCommand getHelpCommand() {
        PluginCommand pluginCommand = this.getCommandLineCommand();
        pluginCommand.addOption("output-format", OperationsOutputFormat.class, new String[]{"Supported data output formats", "<output-format> is one of ${COMPLETION-CANDIDATES}", "Optional, inferred from the extension of the output file", "Defaults to " + OperationsOutputFormat.json.name()});
        return pluginCommand;
    }

    public boolean supportsSchemaCrawlerCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfig, OutputOptions outputOptions) {
        boolean isOperation = this.supportsCommand(command);
        boolean isNamedQuery = this.isNamedQuery(command, additionalConfig);
        boolean supportsSchemaCrawlerCommand = isOperation || isNamedQuery;
        return supportsSchemaCrawlerCommand;
    }

    private boolean isNamedQuery(String command, Config additionalConfig) {
        boolean isNamedQuery = additionalConfig != null ? additionalConfig.containsKey(command) : false;
        return isNamedQuery;
    }
}

