/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.weakassociations;

import java.util.function.Predicate;
import schemacrawler.loader.weakassociations.ProposedWeakAssociation;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;

public final class ExtensionTableMatcher
implements Predicate<ProposedWeakAssociation> {
    private final boolean inferExtensionTables;

    public ExtensionTableMatcher(boolean inferExtensionTables) {
        this.inferExtensionTables = inferExtensionTables;
    }

    @Override
    public boolean test(ProposedWeakAssociation proposedWeakAssociation) {
        String fkColumnName;
        if (!this.inferExtensionTables || proposedWeakAssociation == null) {
            return false;
        }
        Column foreignKeyColumn = proposedWeakAssociation.getForeignKeyColumn();
        Column primaryKeyColumn = proposedWeakAssociation.getPrimaryKeyColumn();
        String pkColumnName = primaryKeyColumn.getName().replaceAll("[^\\p{L}\\{d}]", "").toLowerCase();
        if (pkColumnName.equals(fkColumnName = foreignKeyColumn.getName().replaceAll("[^\\p{L}\\{d}]", "").toLowerCase())) {
            Table pkTable = (Table)primaryKeyColumn.getParent();
            Table fkTable = (Table)foreignKeyColumn.getParent();
            boolean fkIsUnique = foreignKeyColumn.isPartOfPrimaryKey() || foreignKeyColumn.isPartOfUniqueIndex();
            boolean pkTableSortsFirst = pkTable.compareTo(fkTable) < 0;
            return fkIsUnique && pkTableSortsFirst;
        }
        return false;
    }
}

