/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.IOBaseBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.IOBaseBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.IOBaseBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyErrChainExceptions;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.ArrayBuilder;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.ByteArrayOutputStream;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PIOBase})
public final class IOBaseBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = IOBaseBuiltinsSlotsGen.SLOTS;
    public static final int BUFSIZ = 8192;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return IOBaseBuiltinsFactory.getFactories();
    }

    private static boolean isClosed(Node inliningTarget, PythonObject self, VirtualFrame frame, PyObjectLookupAttr lookup) {
        return !PGuards.isNoValue(lookup.execute((Frame)frame, inliningTarget, self, IONodes.T___IOBASE_CLOSED));
    }

    private static PException unsupported(Node inliningTarget, PRaiseNode raiseNode, TruffleString message) {
        throw raiseNode.raise(inliningTarget, PythonErrorType.IOUnsupportedOperation, message);
    }

    @Builtin(name="readlines", minNumOfPositionalArgs=1, parameterNames={"$self", "hint"})
    @ArgumentClinic(name="hint", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadlinesNode
    extends PythonBinaryClinicBuiltinNode {
        ReadlinesNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return IOBaseBuiltinsClinicProviders.ReadlinesNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object withHint(VirtualFrame frame, Object self, int hintIn, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached InlinedConditionProfile isNegativeHintProfile, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode, @Cached PyObjectSizeNode sizeNode) {
            int hint = isNegativeHintProfile.profile(inliningTarget, hintIn <= 0) ? Integer.MAX_VALUE : hintIn;
            int length = 0;
            Object iterator = getIter.execute((Frame)frame, inliningTarget, self);
            ArrayBuilder<Object> list = new ArrayBuilder<Object>();
            while (true) {
                Object line;
                try {
                    line = nextNode.execute((Frame)frame, inliningTarget, iterator);
                }
                catch (IteratorExhausted e) {
                    break;
                }
                list.add(line);
                int lineLength = sizeNode.execute((Frame)frame, inliningTarget, line);
                if (lineLength > hint - length) break;
                length += lineLength;
            }
            return PFactory.createList(language, list.toArray(new Object[0]));
        }
    }

    @Builtin(name="readline", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadlineNode
    extends PythonBinaryClinicBuiltinNode {
        ReadlineNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return IOBaseBuiltinsClinicProviders.ReadlineNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PBytes readline(VirtualFrame frame, Object self, int limit, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PyObjectLookupAttr lookupPeek, @Cached CallNode callPeek, @Cached PyObjectCallMethodObjArgs callRead, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile hasPeek, @Cached InlinedConditionProfile isBytes, @Cached PRaiseNode raiseNode) {
            Object peek = lookupPeek.execute((Frame)frame, inliningTarget, self, IONodes.T_PEEK);
            ByteArrayOutputStream buffer = BytesUtils.createOutputStream();
            while (limit < 0 || buffer.size() < limit) {
                Object b;
                int nreadahead = 1;
                if (hasPeek.profile(inliningTarget, peek != PNone.NO_VALUE)) {
                    Object readahead = callPeek.execute((Frame)frame, peek, 1);
                    if (isBytes.profile(inliningTarget, !(readahead instanceof PBytes))) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.OSError, ErrorMessages.S_SHOULD_RETURN_BYTES_NOT_P, "peek()", readahead);
                    }
                    byte[] buf = bufferLib.getInternalOrCopiedByteArray(readahead);
                    int bufLen = bufferLib.getBufferLength(readahead);
                    if (bufLen > 0) {
                        int n = 0;
                        while ((limit < 0 || n < limit) && n < bufLen && buf[n++] != 10) {
                        }
                        nreadahead = n;
                    }
                }
                if (isBytes.profile(inliningTarget, !((b = callRead.execute((Frame)frame, inliningTarget, self, IONodes.T_READ, nreadahead)) instanceof PBytes))) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.OSError, ErrorMessages.S_SHOULD_RETURN_BYTES_NOT_P, "read()", b);
                }
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(b);
                int bytesLen = bufferLib.getBufferLength(b);
                if (bytesLen == 0) break;
                BytesUtils.append(buffer, bytes, bytesLen);
                if (bytes[bytesLen - 1] != 10) continue;
                break;
            }
            return PFactory.createBytes(language, BytesUtils.toByteArray(buffer));
        }
    }

    @Builtin(name="writelines", minNumOfPositionalArgs=2, parameterNames={"$self", "lines"})
    @GenerateNodeFactory
    static abstract class WriteLinesNode
    extends PythonBinaryBuiltinNode {
        WriteLinesNode() {
        }

        @Specialization
        static Object writeLines(VirtualFrame frame, PythonObject self, Object lines, @Bind Node inliningTarget, @Cached CheckClosedHelperNode checkClosedNode, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode) {
            checkClosedNode.execute(frame, inliningTarget, self);
            Object iter = getIter.execute((Frame)frame, inliningTarget, lines);
            while (true) {
                Object line;
                try {
                    line = nextNode.execute((Frame)frame, inliningTarget, iter);
                }
                catch (IteratorExhausted e) {
                    break;
                }
                callMethod.execute((Frame)frame, inliningTarget, self, IONodes.T_WRITE, line);
            }
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        NextNode() {
        }

        @Specialization
        static Object next(VirtualFrame frame, PythonObject self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PyObjectSizeNode sizeNode) {
            Object line = callMethod.execute((Frame)frame, inliningTarget, self, IONodes.T_READLINE, new Object[0]);
            if (sizeNode.execute((Frame)frame, inliningTarget, line) <= 0) {
                throw NextNode.iteratorExhausted();
            }
            return line;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        static PythonObject iter(VirtualFrame frame, PythonObject self, @Bind Node inliningTarget, @Cached CheckClosedHelperNode checkClosedNode) {
            checkClosedNode.execute(frame, inliningTarget, self);
            return self;
        }
    }

    @Builtin(name="isatty", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsattyNode
    extends PythonUnaryBuiltinNode {
        IsattyNode() {
        }

        @Specialization
        static boolean isatty(VirtualFrame frame, PythonObject self, @Bind Node inliningTarget, @Cached CheckClosedHelperNode checkClosedNode) {
            checkClosedNode.execute(frame, inliningTarget, self);
            return false;
        }
    }

    @Builtin(name="fileno", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FilenoNode
    extends PythonUnaryBuiltinNode {
        FilenoNode() {
        }

        @Specialization
        static Object fileno(PythonObject self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            throw IOBaseBuiltins.unsupported(inliningTarget, raiseNode, SpecialMethodNames.T_FILENO);
        }
    }

    @Builtin(name="__exit__", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class ExitNode
    extends PythonBuiltinNode {
        ExitNode() {
        }

        @Specialization
        static Object exit(VirtualFrame frame, PythonObject self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self, IONodes.T_CLOSE, new Object[0]);
        }
    }

    @Builtin(name="__enter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class EnterNode
    extends PythonUnaryBuiltinNode {
        EnterNode() {
        }

        @Specialization
        static PythonObject enter(VirtualFrame frame, PythonObject self, @Bind Node inliningTarget, @Cached CheckClosedHelperNode checkClosedNode) {
            checkClosedNode.execute(frame, inliningTarget, self);
            return self;
        }
    }

    @Builtin(name="tell", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TellNode
    extends PythonUnaryBuiltinNode {
        TellNode() {
        }

        @Specialization
        static Object tell(VirtualFrame frame, PythonObject self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self, IONodes.T_SEEK, 0, 1);
        }
    }

    @Builtin(name="truncate", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class TruncateNode
    extends PythonBuiltinNode {
        TruncateNode() {
        }

        @Specialization
        static Object truncate(PythonObject self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            throw IOBaseBuiltins.unsupported(inliningTarget, raiseNode, IONodes.T_TRUNCATE);
        }
    }

    @Builtin(name="seek", minNumOfPositionalArgs=2, parameterNames={"$self", "offset", "whence"})
    @GenerateNodeFactory
    static abstract class SeekNode
    extends PythonTernaryBuiltinNode {
        SeekNode() {
        }

        @Specialization
        static Object seek(PythonObject self, Object offset, Object whence, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            throw IOBaseBuiltins.unsupported(inliningTarget, raiseNode, IONodes.T_SEEK);
        }
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FlushNode
    extends PythonUnaryBuiltinNode {
        FlushNode() {
        }

        @Specialization
        static PNone flush(VirtualFrame frame, PythonObject self, @Bind Node inliningTarget, @Cached PyObjectLookupAttr lookup, @Cached PRaiseNode raiseNode) {
            if (IOBaseBuiltins.isClosed(inliningTarget, self, frame, lookup)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @ImportStatic(value={IONodes.class})
    @GenerateNodeFactory
    static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        CloseNode() {
        }

        @Specialization
        static PNone close(VirtualFrame frame, PythonObject self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PyObjectLookupAttr lookup, @Cached PyObjectSetAttr setAttributeNode, @Cached InlinedBranchProfile errorProfile, @Cached PyErrChainExceptions chainExceptions) {
            if (!IOBaseBuiltins.isClosed(inliningTarget, self, frame, lookup)) {
                try {
                    callMethod.execute((Frame)frame, inliningTarget, self, IONodes.T_FLUSH, new Object[0]);
                }
                catch (PException e) {
                    errorProfile.enter(inliningTarget);
                    try {
                        setAttributeNode.execute((Frame)frame, inliningTarget, self, IONodes.T___IOBASE_CLOSED, true);
                    }
                    catch (PException e1) {
                        throw chainExceptions.execute(inliningTarget, e1, e);
                    }
                    throw e;
                }
                setAttributeNode.execute((Frame)frame, inliningTarget, self, IONodes.T___IOBASE_CLOSED, true);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="_checkWritable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CheckWritableNode
    extends PythonUnaryBuiltinNode {
        CheckWritableNode() {
        }

        @Specialization
        boolean doCheckWritable(VirtualFrame frame, PythonObject self, @Bind Node inliningTarget, @Cached CheckBoolMethodHelperNode helper) {
            return helper.checkWriteable(frame, inliningTarget, self);
        }
    }

    @Builtin(name="_checkReadable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CheckReadableNode
    extends PythonUnaryBuiltinNode {
        CheckReadableNode() {
        }

        @Specialization
        boolean doCheckReadable(VirtualFrame frame, PythonObject self, @Bind Node inliningTarget, @Cached CheckBoolMethodHelperNode helper) {
            return helper.checkReadable(frame, inliningTarget, self);
        }
    }

    @Builtin(name="_checkSeekable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CheckSeekableNode
    extends PythonUnaryBuiltinNode {
        CheckSeekableNode() {
        }

        @Specialization
        boolean doCheckSeekable(VirtualFrame frame, PythonObject self, @Bind Node inliningTarget, @Cached CheckBoolMethodHelperNode helper) {
            return helper.checkSeekable(frame, inliningTarget, self);
        }
    }

    @GenerateCached(value=false)
    @GenerateUncached(value=false)
    @GenerateInline
    static abstract class CheckBoolMethodHelperNode
    extends Node {
        CheckBoolMethodHelperNode() {
        }

        final boolean checkSeekable(VirtualFrame frame, Node inliningTarget, Object self) {
            return this.execute(frame, inliningTarget, self, IONodes.T_SEEKABLE, ErrorMessages.FILE_OR_STREAM_IS_NOT_SEEKABLE);
        }

        final boolean checkWriteable(VirtualFrame frame, Node inliningTarget, Object self) {
            return this.execute(frame, inliningTarget, self, IONodes.T_WRITABLE, ErrorMessages.FILE_OR_STREAM_IS_NOT_WRITABLE);
        }

        final boolean checkReadable(VirtualFrame frame, Node inliningTarget, Object self) {
            return this.execute(frame, inliningTarget, self, IONodes.T_READABLE, ErrorMessages.FILE_OR_STREAM_IS_NOT_READABLE);
        }

        abstract boolean execute(VirtualFrame var1, Node var2, Object var3, TruffleString var4, TruffleString var5);

        @Specialization
        static boolean doIt(VirtualFrame frame, Node inliningTarget, Object self, TruffleString method, TruffleString errorMessage, @Cached PyObjectCallMethodObjArgs callMethod, @Cached(inline=false) IsNode isNode, @Cached PRaiseNode raiseNode) {
            CompilerAsserts.partialEvaluationConstant((Object)method);
            CompilerAsserts.partialEvaluationConstant((Object)errorMessage);
            Object v = callMethod.execute((Frame)frame, inliningTarget, self, method, new Object[0]);
            if (isNode.isTrue(v)) {
                return true;
            }
            throw IOBaseBuiltins.unsupported(inliningTarget, raiseNode, errorMessage);
        }
    }

    @Builtin(name="_checkClosed", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CheckClosedNode
    extends PythonUnaryBuiltinNode {
        CheckClosedNode() {
        }

        @Specialization
        Object doCheckClosed(VirtualFrame frame, PythonObject self, @Bind Node inliningTarget, @Cached CheckClosedHelperNode helper) {
            return helper.execute(frame, inliningTarget, self);
        }
    }

    @GenerateCached(value=false)
    @GenerateUncached(value=false)
    @GenerateInline
    static abstract class CheckClosedHelperNode
    extends Node {
        CheckClosedHelperNode() {
        }

        abstract PNone execute(VirtualFrame var1, Node var2, PythonObject var3);

        @Specialization
        static PNone doIt(VirtualFrame frame, Node inliningTarget, PythonObject self, @Cached PyObjectGetAttr getAttr, @Cached PyObjectIsTrueNode isTrueNode, @Cached PRaiseNode raiseNode) {
            if (isTrueNode.execute((Frame)frame, getAttr.execute((Frame)frame, inliningTarget, self, IONodes.T_CLOSED))) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="writable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class WritableNode
    extends PythonUnaryBuiltinNode {
        WritableNode() {
        }

        @Specialization
        static boolean writable(PythonObject self) {
            return false;
        }
    }

    @Builtin(name="readable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReadableNode
    extends PythonUnaryBuiltinNode {
        ReadableNode() {
        }

        @Specialization
        static boolean readable(PythonObject self) {
            return false;
        }
    }

    @Builtin(name="seekable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SeekableNode
    extends PythonUnaryBuiltinNode {
        SeekableNode() {
        }

        @Specialization
        static boolean seekable(PythonObject self) {
            return false;
        }
    }

    @Builtin(name="closed", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ClosedNode
    extends PythonUnaryBuiltinNode {
        ClosedNode() {
        }

        @Specialization
        static boolean closed(VirtualFrame frame, PythonObject self, @Bind Node inliningTarget, @Cached PyObjectLookupAttr lookup) {
            return IOBaseBuiltins.isClosed(inliningTarget, self, frame, lookup);
        }
    }
}

