/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.firebirdsql.gds.ng.wire.AsynchronousChannelListener;
import org.firebirdsql.gds.ng.wire.FbWireAsynchronousChannel;

public final class AsynchronousProcessor {
    private static final System.Logger log = System.getLogger(AsynchronousProcessor.class.getName());
    private final AsynchronousChannelListener channelListener = new ProcessorChannelListener();
    private final List<FbWireAsynchronousChannel> newChannels = Collections.synchronizedList(new ArrayList());
    private final SelectorTask selectorTask = new SelectorTask();
    private final Selector selector;

    private AsynchronousProcessor() {
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to initialize asynchronous processor", e);
        }
        Thread selectorThread = new Thread((Runnable)this.selectorTask, "Jaybird asynchronous processing");
        selectorThread.setDaemon(true);
        selectorThread.setUncaughtExceptionHandler(new LogUncaughtExceptionHandler());
        selectorThread.start();
    }

    public static AsynchronousProcessor getInstance() {
        return ProcessorHolder.INSTANCE;
    }

    public void registerAsynchronousChannel(FbWireAsynchronousChannel channel) {
        channel.addChannelListener(this.channelListener);
        this.newChannels.add(channel);
        this.selector.wakeup();
    }

    public void unregisterAsynchronousChannel(FbWireAsynchronousChannel channel) {
        if (!this.newChannels.remove(channel)) {
            for (SelectionKey key : new ArrayList<SelectionKey>(this.selector.keys())) {
                if (!key.isValid() || key.attachment() != channel) continue;
                key.cancel();
                break;
            }
        }
        channel.removeChannelListener(this.channelListener);
    }

    public void shutdown() {
        this.selectorTask.stop();
        this.selector.wakeup();
    }

    private final class ProcessorChannelListener
    implements AsynchronousChannelListener {
        private ProcessorChannelListener() {
        }

        @Override
        public void channelClosing(FbWireAsynchronousChannel channel) {
            AsynchronousProcessor.this.unregisterAsynchronousChannel(channel);
        }

        @Override
        public void eventReceived(FbWireAsynchronousChannel channel, AsynchronousChannelListener.Event event) {
        }
    }

    private class SelectorTask
    implements Runnable {
        private volatile boolean running = true;

        private SelectorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running && !Thread.currentThread().isInterrupted()) {
                try {
                    List<FbWireAsynchronousChannel> list = AsynchronousProcessor.this.newChannels;
                    synchronized (list) {
                        for (FbWireAsynchronousChannel channel : AsynchronousProcessor.this.newChannels) {
                            this.addChannel(channel);
                        }
                        AsynchronousProcessor.this.newChannels.clear();
                    }
                    AsynchronousProcessor.this.selector.select(this::handleReadable);
                }
                catch (Exception ex) {
                    log.log(System.Logger.Level.ERROR, "Exception in async event processing", (Throwable)ex);
                }
            }
            try {
                AsynchronousProcessor.this.selector.close();
            }
            catch (Exception e) {
                log.log(System.Logger.Level.ERROR, "Exception closing event selector", (Throwable)e);
            }
            finally {
                AsynchronousProcessor.this.newChannels.clear();
            }
        }

        private void addChannel(FbWireAsynchronousChannel channel) throws ClosedChannelException {
            try {
                channel.getSocketChannel().register(AsynchronousProcessor.this.selector, 1, channel);
            }
            catch (SQLException ex) {
                channel.removeChannelListener(AsynchronousProcessor.this.channelListener);
            }
        }

        private void handleReadable(SelectionKey selectionKey) {
            try {
                FbWireAsynchronousChannel channel;
                ByteBuffer eventBuffer;
                if (!selectionKey.isValid() || !selectionKey.isReadable()) {
                    return;
                }
                SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                int count = socketChannel.read(eventBuffer = (channel = (FbWireAsynchronousChannel)selectionKey.attachment()).getEventBuffer());
                if (count > 0) {
                    channel.processEventData();
                } else if (count < 0) {
                    SelectorTask.closeSilently(channel, "SQLException closing event channel");
                }
            }
            catch (AsynchronousCloseException e) {
                log.log(System.Logger.Level.TRACE, "AsynchronousCloseException reading from event channel; cancelling key", (Throwable)e);
                selectionKey.cancel();
            }
            catch (CancelledKeyException e) {
            }
            catch (Exception e) {
                log.log(System.Logger.Level.ERROR, "Exception reading from event channel; attempting to close async channel", (Throwable)e);
                FbWireAsynchronousChannel channel = (FbWireAsynchronousChannel)selectionKey.attachment();
                SelectorTask.closeSilently(channel, "Attempt to close async channel failed");
            }
        }

        private static void closeSilently(FbWireAsynchronousChannel channel, String logMessageOnException) {
            try {
                channel.close();
            }
            catch (SQLException e) {
                log.log(System.Logger.Level.ERROR, logMessageOnException, (Throwable)e);
            }
        }

        private void stop() {
            this.running = false;
        }
    }

    private static class LogUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private LogUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.log(System.Logger.Level.ERROR, "Jaybird asynchronous processing terminated. Uncaught exception on " + t.getName(), e);
        }
    }

    private static final class ProcessorHolder {
        private static final AsynchronousProcessor INSTANCE = new AsynchronousProcessor();

        private ProcessorHolder() {
        }
    }
}

